/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class DB2JdbcHelper {
    private static final String DRIVER_CLASS = "com.ibm.db2.jcc.DB2Driver";
    private static final String URL_PREFIX = "jdbc:db2://";
    private static final String CLASS_NAME = "DB2JdbcHelper";
    private String host;
    private String portNo;
    private String user;
    private String password;
    private String dbName;
    private boolean debug = true;
    private static Hashtable syncHash = new Hashtable();
    private static String syncFlag = new String("syncFlag");
    private static Hashtable db2VersionHash = new Hashtable();
    private String ssl = "";

    public DB2JdbcHelper(String string, String string2, String string3, String string4, String string5) {
        this.host = string;
        this.portNo = string2;
        this.user = string3;
        this.password = string4;
        this.dbName = string5;
    }

    public DB2JdbcHelper(String string, String string2, String string3, String string4, String string5, String string6) {
        this.host = string;
        this.portNo = string2;
        this.user = string3;
        this.password = string4;
        this.dbName = string5;
        this.ssl = string6;
    }

    public Connection getConnection() {
        Connection connection;
        block6: {
            connection = null;
            String string = "";
            string = this.ssl.equalsIgnoreCase("true") ? URL_PREFIX + this.host + ":" + this.portNo + "/" + this.dbName + ":sslConnection=true;" : URL_PREFIX + this.host + ":" + this.portNo + "/" + this.dbName;
            System.out.println("GetConnection url\t:" + string);
            try {
                Class.forName(DRIVER_CLASS);
                connection = DriverManager.getConnection(string, this.user, this.password);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                if (this.debug) {
                    System.out.println("DB2JdbcHelper: Could not load DB2 JDBC driver " + classNotFoundException);
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                if (this.debug) {
                    System.out.println("DB2JdbcHelper: SQL Exception " + sQLException);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block6;
                System.out.println("DB2JdbcHelper: Exception" + exception);
            }
        }
        return connection;
    }

    public void closeConnection(Connection connection) {
        block3: {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing connection " + exception);
            }
        }
        connection = null;
    }

    public void closeStatement(Statement statement) {
        block3: {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing statement " + exception);
            }
        }
        statement = null;
    }

    public void closeResultSet(ResultSet resultSet) {
        block3: {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!this.debug) break block3;
                System.out.println("DB2JdbcHelper: Exception while closing resultset " + exception);
            }
        }
        resultSet = null;
    }

    public int getDb2MajorVersion(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public String getDbSnapshotFunction(Connection connection) {
        int n = 8;
        int n2 = 1;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
            n2 = connection.getMetaData().getDatabaseMinorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_DATABASE(cast(NULL as varchar(128)),-2)";
        } else if (n == 9) {
            string = "SNAP_GET_DB_V" + n + "" + n2 + "(CAST (NULL AS VARCHAR(128)),-2)";
        } else if (n > 9) {
            string = "SNAP_GET_DB(CAST (NULL AS VARCHAR(128)),-2)";
        }
        return string;
    }

    public String getDbmSnapshotFunction(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_DBM(-2)";
        } else if (n >= 9) {
            string = "SNAP_GET_DBM(-2)";
        }
        return string;
    }

    public String getTbsSnapshotFunction(Connection connection) {
        int n = 8;
        try {
            n = connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = "";
        if (n == 8) {
            string = "SNAPSHOT_TBS_CFG(cast(NULL as varchar(128)),-2)";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8;
        String string9 = string7 + ":" + string2 + ":" + string3;
        String string10 = "";
        string10 = (String)syncHash.get(string9);
        if (string10 == null) {
            string8 = syncFlag;
            synchronized (string8) {
                string10 = (String)syncHash.get(string9);
                if (string10 == null) {
                    string10 = new String(string9);
                    syncHash.put(string9, string10);
                }
            }
        }
        string8 = string10;
        synchronized (string8) {
            String string11 = "";
            if (db2VersionHash != null && db2VersionHash.containsKey(string10)) {
                string11 = (String)db2VersionHash.get(string10);
            } else {
                int n = 8;
                int n2 = 1;
                Connection connection = null;
                try {
                    connection = this.getConnection();
                    if (connection == null) {
                        DB2JdbcHelper.logToErrorFile("Error  :", string, " getVersion() Connection is null for targetHost:" + string2 + " reportingName :" + string7 + " Port :" + string3 + " dbName :" + string6);
                        String string12 = null;
                        return string12;
                    }
                    n = connection.getMetaData().getDatabaseMajorVersion();
                    n2 = connection.getMetaData().getDatabaseMinorVersion();
                    string11 = n + "." + n2;
                    db2VersionHash.put(string10, string11);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string11 = null;
                }
                finally {
                    this.closeConnection(connection);
                }
            }
            return string11;
        }
    }

    private static void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        String string4 = "agent";
        EgDateInfo egDateInfo = new EgDateInfo();
        EgConfigInfo egConfigInfo = new EgConfigInfo(string4);
        if (string3 == null) {
            return;
        }
        String string5 = egDateInfo.egetDate();
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string6 = new String(string5 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string6);
        printWriter.close();
        printWriter = null;
    }
}

