/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class CpHAStatusTest
extends EgSnmpGenericTest {
    boolean isActiveFirst = false;
    boolean isStandbyFirst = false;

    public CpHAStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = this.getMeasures(".1.3.6.1.4.1.2620.1.5.6");
            System.out.println(this.entity + " HA Status == >" + string);
            double d = -5.0;
            double d2 = -5.0;
            if (string.equalsIgnoreCase("Active")) {
                d = 1.0;
                if (this.isActiveFirst) {
                    d2 = 1.0;
                    this.isActiveFirst = false;
                } else {
                    d2 = 0.0;
                    this.isStandbyFirst = true;
                }
            } else if (string.equalsIgnoreCase("standby")) {
                d = 0.0;
                if (this.isStandbyFirst) {
                    d2 = 1.0;
                    this.isStandbyFirst = false;
                } else {
                    d2 = 0.0;
                    this.isActiveFirst = true;
                }
            } else {
                d = -5.0;
                d2 = -5.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            System.out.println(this.entity + " MeasureList == >" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception ", "CpHAStatusTest Exception occured in computeMeasures for ", this.targetHost);
            exception.printStackTrace();
        }
    }

    private String getMeasures(String string) {
        String string2 = "";
        boolean bl = this.runSnmpCmdForOid(string);
        if (bl) {
            try {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.rhs[i] != null && this.rhs[i].trim().length() > 0 ? this.rhs[i].trim() : "-5";
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error ", "CpHAStatusTest Error occured in getMeasures for ", this.targetHost);
                exception.printStackTrace();
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        CpHAStatusTest cpHAStatusTest = new CpHAStatusTest(stringArray);
        cpHAStatusTest.computeMeasures(new Hashtable());
    }
}

