/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class CiscoQFPThruputTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;

    public CiscoQFPThruputTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.2.1.47.1.1.1.1.2");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.8.1.1");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.8.1.2");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.9.9.715.1.1.8.1.5");
            if (hashtable3 == null || hashtable3.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Error :", "CiscoQFPThruputTest No QFP throughput relevant data available for :", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                String string = "";
                String string2 = (String)enumeration.nextElement();
                string = string2 != null && string2.trim().indexOf(".") > -1 ? string2.substring(0, string2.indexOf(".")) : string2;
                String string3 = (String)hashtable3.get(string2);
                String string4 = (String)hashtable4.get(string2);
                String string5 = (String)hashtable5.get(string2);
                System.out.println(this.entity + " Key ==>" + string2 + " phyIndexKey ==>" + string);
                String string6 = (String)hashtable2.get(string);
                double d = this.getDoubleValue(string3);
                double d2 = this.getDoubleValue(string4);
                double d3 = this.getDoubleValue(string5);
                double d4 = -5.0;
                if (d > 0.0) {
                    d /= 1000000.0;
                }
                if (d3 > 0.0) {
                    d3 /= 1000000.0;
                }
                if (d > 0.0 && d3 <= d) {
                    d4 = d3 / d * 100.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                String string7 = string6;
                System.out.println(this.entity + " Info ==>" + string7 + " measureList ==>" + arrayList);
                this.addNewMeasure(string7, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception:", "CiscoQFPThruputTest Exception occured in computeMeasures()", this.targetHost);
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoQFPThruputTest Exception occured in getMeasure() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string != null && string.trim().length() > 0) {
                d = Double.parseDouble(string);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "CiscoQFPThruputTest Exception occured in getDoubleValue() for " + this.targetHost, exception.toString());
        }
        return d;
    }
}

