/*
 * Decompiled with CFR 0.152.
 */
public class CheckPointTest
extends EgSnmpTest {
    private static String filterNameOid = ".1.3.6.1.4.1.2620.1.1.2";
    private static String acceptedPacketsOid = ".1.3.6.1.4.1.2620.1.1.4";
    private static String rejectedPacketsOid = ".1.3.6.1.4.1.2620.1.1.5";
    private static String droppedPacketsOid = ".1.3.6.1.4.1.2620.1.1.6";
    private static int pktProcessingRateIndex = 0;
    private static int pctAcceptedPktsIndex = 1;
    private static int pctRejectedPktsIndex = 2;
    private static int pctDroppedPktsIndex = 3;
    private long currentTotalPackets = 0L;
    private double pktProcessingRate = -1.0;
    private double pctAcceptedPkts = -1.0;
    private double pctRejectedPkts = -1.0;
    private double pctDroppedPkts = -1.0;
    private long prevAcceptedPackets = -1L;
    private long prevRejectedPackets = -1L;
    private long prevDroppedPackets = -1L;
    private long prevTotalPackets = -1L;

    public CheckPointTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 4;
    }

    public static void main(String[] stringArray) {
        CheckPointTest checkPointTest = new CheckPointTest(stringArray);
        checkPointTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkPointTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkPointTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkPointTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkPointTest.executeTest();
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        checkPointTest.executeTest();
    }

    public boolean executeTest() {
        long l;
        long l2;
        long l3;
        this.initTest();
        long l4 = this.getAcceptedPackets(acceptedPacketsOid);
        long l5 = this.getRejectedPackets(rejectedPacketsOid);
        long l6 = this.getDroppedPackets(droppedPacketsOid);
        if (l4 < 0L || l5 < 0L || l6 < 0L) {
            this.resetCntrs();
            this.updateAllResultSets();
            return true;
        }
        l3 = this.prevAcceptedPackets >= 0L ? ((l3 = l4 - this.prevAcceptedPackets) >= 0L ? l3 : -1L) : -1L;
        l2 = this.prevRejectedPackets >= 0L ? ((l2 = l5 - this.prevRejectedPackets) >= 0L ? l2 : -1L) : -1L;
        l = this.prevDroppedPackets >= 0L ? ((l = l6 - this.prevDroppedPackets) >= 0L ? l : -1L) : -1L;
        if (l3 < 0L || l2 < 0L || l < 0L) {
            this.prevAcceptedPackets = l4;
            this.prevRejectedPackets = l5;
            this.prevDroppedPackets = l6;
            this.updateAllResultSets();
            return true;
        }
        this.currentTotalPackets = l4 + l5 + l6;
        this.prevTotalPackets = this.prevAcceptedPackets + this.prevRejectedPackets + this.prevDroppedPackets;
        if (this.prevTotalPackets < 0L || this.timeSinceLastTest <= 0.0) {
            this.pktProcessingRate = -1.0;
        } else {
            this.pktProcessingRate = (double)(this.currentTotalPackets - this.prevTotalPackets) / this.timeSinceLastTest;
            this.pktProcessingRate = this.pktProcessingRate < 0.0 ? -1.0 : this.pktProcessingRate;
        }
        this.currentTotalPackets = l3 + l2 + l;
        this.pctAcceptedPkts = (double)l3 / (double)this.currentTotalPackets * 100.0;
        this.pctAcceptedPkts = this.pctAcceptedPkts < 0.0 ? -1.0 : this.pctAcceptedPkts;
        this.pctRejectedPkts = (double)l2 / (double)this.currentTotalPackets * 100.0;
        this.pctRejectedPkts = this.pctRejectedPkts < 0.0 ? -1.0 : this.pctRejectedPkts;
        this.pctDroppedPkts = (double)l / (double)this.currentTotalPackets * 100.0;
        this.pctDroppedPkts = this.pctDroppedPkts < 0.0 ? -1.0 : this.pctDroppedPkts;
        String string = this.getFilterName(filterNameOid);
        string = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string;
        this.addValueToResultSet(string, pktProcessingRateIndex, this.pktProcessingRate);
        this.addValueToResultSet(string, pctAcceptedPktsIndex, this.pctAcceptedPkts);
        this.addValueToResultSet(string, pctRejectedPktsIndex, this.pctRejectedPkts);
        this.addValueToResultSet(string, pctDroppedPktsIndex, this.pctDroppedPkts);
        this.prevAcceptedPackets = l4;
        this.prevRejectedPackets = l5;
        this.prevDroppedPackets = l6;
        this.updateAllResultSets();
        return true;
    }

    private void resetCntrs() {
        this.prevAcceptedPackets = -1L;
        this.prevRejectedPackets = -1L;
        this.prevDroppedPackets = -1L;
    }

    private long getAcceptedPackets(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return -1L;
    }

    private String getFilterName(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return string2;
        }
        return "No filter available";
    }

    private long getDroppedPackets(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return -1L;
    }

    private long getRejectedPackets(String string) {
        String string2 = null;
        if (this.runSnmpCmdForOid(string)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
            }
        }
        if (string2 != null) {
            return Long.parseLong(string2);
        }
        return -1L;
    }
}

