/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class BasicBattStatusTest
extends EgSnmpGenericTest {
    private static String startOid = ".1.3.6.1.4.1.318.1.1.1.2.1";
    private static int numMeasures = 1;
    public String ddReplace = "";

    public BasicBattStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
            if (d < 0.0) {
                d = -5.0;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "BasicBattStatusTest Exception occured in getValue() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.ddReplace = "-";
        double d = -5.0;
        boolean bl = false;
        try {
            bl = this.runSnmpCmdForOid(startOid);
            if (!bl) {
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith("1")) {
                    d = this.getValue(i);
                    if (d == 2.0) {
                        d = 100.0;
                        continue;
                    }
                    if (d != 3.0) continue;
                    d = 0.0;
                    continue;
                }
                if (!this.lhs[i].startsWith("3")) continue;
                this.ddReplace = this.rhs[i];
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            System.out.println("[BasicBattStatusTest] Measures  : " + arrayList);
            System.out.println("[BasicBattStatusTest] Measures DD : " + this.ddReplace);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BasicBattStatusTest basicBattStatusTest = new BasicBattStatusTest(stringArray);
        basicBattStatusTest.computeMeasures(new Hashtable());
    }
}

