/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgAgentInfo;
import com.eg.apm.APMUtils;
import com.eg.apm.AgentJavaSocketServer;
import com.eg.apm.AgentNodeSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.Container;
import com.eg.apm.ContainerInstanceFactory;
import com.eg.apm.SocketIpSelectorUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;

public class BTMOffloadServerSocketCreater
extends Thread {
    private static final String logPrefix = " [BTMOffloadServerSocketCreater] ";
    private static final String threadName = "BTM_Offload_Server_Socket_Creator";
    private SocketIpSelectorUtil javaSocketUtil = null;

    public BTMOffloadServerSocketCreater() {
        this.setName(threadName);
        this.setDaemon(true);
        AgentStartupLogger.logger.trace("{} {} thread initiated !!!", (Object)logPrefix, (Object)threadName);
        this.javaSocketUtil = SocketIpSelectorUtil.getInstance();
    }

    public void run() {
        if (ApmConfigManager.getInstance().isBtmOffloadPortStartupDelayEnabled()) {
            AgentStartupLogger.logger.info("{} {} - BTM offload server socket will start after {} milliseconds ", new Object[]{logPrefix, threadName, ApmConfigManager.getInstance().getBtmOffloadPortStartupDelayPeriod()});
            this.suspendThread(ApmConfigManager.getInstance().getBtmOffloadPortStartupDelayPeriod());
        }
        AgentStartupLogger.logger.trace("{} {} started !!!", (Object)logPrefix, (Object)threadName);
        this.checkHostType();
        long counter = 0L;
        long maxAttempt = 15L;
        while (true) {
            try {
                while (true) {
                    BTMOffloadAPMSocketConfiguration configuration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
                    boolean open_offload_port = configuration.isOpenOffloadPort();
                    AgentStartupLogger.logger.trace("{} Open Java BTM Offload Server Socket Port : {}", (Object)logPrefix, (Object)open_offload_port);
                    EgAgentInfo info = new EgAgentInfo("agent");
                    ArrayList testList = info.getCurrentTests();
                    AgentStartupLogger.logger.trace("{} Current tests:  {} ", (Object)logPrefix, (Object)testList);
                    this.socket4JavaTechnology(configuration, open_offload_port, testList);
                    this.socket4NodeJsTechnology(configuration, open_offload_port, testList);
                    long sleepTime = configuration.getCheckInterval();
                    this.suspendThread(sleepTime * 60L * 1000L * 1L);
                    counter = 0L;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                AgentStartupLogger.logger.error("{} Counter : {}, Error occurred in BTMOffloadServerSocketCreater ", new Object[]{logPrefix, ++counter, e});
                this.printWarning(counter, maxAttempt);
                continue;
            }
            break;
        }
    }

    private void printWarning(long counter, long maxAttempt) {
        if (counter > maxAttempt) {
            AgentStartupLogger.logger.warn("{}   Error in BTMOffloadServerSocketCreater, {} - Maximum number of re-attempt completed, 15 mins sleep before next attempt", (Object)logPrefix, (Object)maxAttempt);
            this.suspendThread(900000L);
        } else {
            AgentStartupLogger.logger.error("{}  Error occurred in BTMOffloadServerSocketCreater, One minute sleep before next attempt, Current counter : {} ", (Object)logPrefix, (Object)counter);
            this.suspendThread(60000L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void socket4NodeJsTechnology(BTMOffloadAPMSocketConfiguration configuration, boolean open_offload_port, ArrayList runningTests) throws Error, Exception {
        boolean btmNodeJSSocketServerStarted = AgentNodeSocketServer.getInstance().isSocketServerStarted();
        boolean inside = false;
        if (open_offload_port || this.isOffloadNodeJsTestsEnabled(runningTests)) {
            inside = true;
            try {
                if (btmNodeJSSocketServerStarted) return;
                AgentNodeSocketServer.getInstance().startServer(configuration, this.javaSocketUtil.isContainerzHost());
                btmNodeJSSocketServerStarted = true;
                System.out.println(new Date() + " BTM Offload NodeJS Server Socket Started : " + btmNodeJSSocketServerStarted);
                return;
            }
            catch (Exception e) {
                AgentStartupLogger.logger.error("{} Unable to Start Offload NodeJS Server with Agent : {}", (Object)logPrefix, (Object)e);
                throw new Exception(e);
            }
        }
        if (inside) return;
        try {
            if (!btmNodeJSSocketServerStarted) return;
            AgentNodeSocketServer.getInstance().closeServerSocket();
            return;
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to close BTM Offload NodeJS socket server {}", (Object)logPrefix, (Object)e);
            throw new Exception(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void socket4JavaTechnology(BTMOffloadAPMSocketConfiguration configuration, boolean open_offload_port, ArrayList runningTests) throws Error, Exception {
        boolean btmSocketServerStarted = AgentJavaSocketServer.getInstance().isSocketServerStarted();
        boolean inside = false;
        if (open_offload_port || this.isOffloadTestsEnabled(runningTests)) {
            inside = true;
            try {
                if (btmSocketServerStarted) return;
                AgentJavaSocketServer.getInstance().startServer(configuration, this.javaSocketUtil.isContainerzHost());
                btmSocketServerStarted = true;
                System.out.println(new Date() + " BTM Offload Server Socket Started : " + btmSocketServerStarted);
                return;
            }
            catch (Exception e) {
                AgentStartupLogger.logger.error("{} Unable to Start Offload Server with Agent : {}", (Object)logPrefix, (Object)e);
                throw new Exception(e);
            }
        }
        if (inside) return;
        try {
            if (!btmSocketServerStarted) return;
            AgentJavaSocketServer.getInstance().closeServerSocket();
            return;
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to close BTM Offload socket server {}", (Object)logPrefix, (Object)e);
            throw new Exception(e);
        }
    }

    private void suspendThread(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isOffloadTestsEnabled(ArrayList runningTests) {
        boolean testsAvailble = false;
        try {
            if (runningTests != null && runningTests.size() > 0 && (runningTests.contains("BusinessTransTest") || runningTests.contains("KBusinessTransTest"))) {
                testsAvailble = true;
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to check Java BTM offload tests {} ", (Object)logPrefix, (Object)e);
        }
        AgentStartupLogger.logger.trace("{} Is any Java BTM test(s) running ? : {}", (Object)logPrefix, (Object)testsAvailble);
        return testsAvailble;
    }

    private boolean isOffloadNodeJsTestsEnabled(ArrayList runningTests) {
        boolean testsAvailble = false;
        try {
            if (runningTests != null && runningTests.size() > 0 && (runningTests.contains("NodeTransTest") || runningTests.contains("KNodeTransTest"))) {
                testsAvailble = true;
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to check NodeJS BTM offload tests {} ", (Object)logPrefix, (Object)e);
        }
        AgentStartupLogger.logger.trace("{} Is any NodeJS BTM test(s) running ? : {}", (Object)logPrefix, (Object)testsAvailble);
        return testsAvailble;
    }

    private void checkHostType() {
        boolean isDockerHost = false;
        boolean isCrioHost = false;
        Container containerInstance = ContainerInstanceFactory.getInstance().getContainerInstance();
        if (containerInstance != null) {
            isDockerHost = containerInstance.isDockerContainer();
            if (isDockerHost) {
                this.javaSocketUtil.setIsContainerZHost(true);
                String dockerHostIp = containerInstance.getHostInternalIp();
                if (dockerHostIp.equalsIgnoreCase("127.0.0.1")) {
                    String agentIp = this.getAgentIp();
                    AgentStartupLogger.logger.trace("{} Agent IP for binding : {} ", (Object)logPrefix, (Object)agentIp);
                    this.javaSocketUtil.setContainerHostIp(agentIp, AgentStartupLogger.logger);
                    if (!agentIp.equalsIgnoreCase("127.0.0.1")) {
                        this.javaSocketUtil.setAgentIpAsBindIp(true);
                        AgentStartupLogger.logger.warn("{} INFO:- This Host found as a docker environment,but unable to find docker internal IP address. Using Agent Host IP address as a Offload Socket bind IP : {}", (Object)logPrefix, (Object)agentIp);
                    }
                } else {
                    this.javaSocketUtil.setContainerHostIp(dockerHostIp, AgentStartupLogger.logger);
                }
            } else {
                isCrioHost = containerInstance.isCrioContainer();
                if (isCrioHost) {
                    this.javaSocketUtil.setIsContainerZHost(true);
                    String agentIp = this.getAgentIp();
                    AgentStartupLogger.logger.trace("{} Agent IP for binding : {} ", (Object)logPrefix, (Object)agentIp);
                    this.javaSocketUtil.setContainerHostIp(agentIp, AgentStartupLogger.logger);
                    this.javaSocketUtil.setAgentIpAsBindIp(true);
                }
            }
        }
        AgentStartupLogger.logger.info("{} isDockerHost : {} , isCrioHost : {}, containerInstance : {}", new Object[]{logPrefix, isDockerHost, isCrioHost, containerInstance});
    }

    private String getAgentIp() {
        String localIP;
        block4: {
            localIP = "127.0.0.1";
            try {
                String localHostName = InetAddress.getLocalHost().getHostName();
                InetAddress[] inetAdd = InetAddress.getAllByName(localHostName);
                AgentStartupLogger.logger.trace("{} localHostName : {} & InetAddress : {} ", new Object[]{logPrefix, localHostName, inetAdd});
                if (inetAdd == null || inetAdd.length < 1) break block4;
                int k = 0;
                while (k < inetAdd.length) {
                    String myIp;
                    InetAddress thisAddress = inetAdd[k];
                    AgentStartupLogger.logger.trace("{} Ip Address : {} ", (Object)logPrefix, (Object)thisAddress.getHostAddress());
                    if (!(thisAddress != null && APMUtils.isLoopbackAddress(thisAddress) || (myIp = thisAddress.getHostAddress()) == null || myIp.startsWith("169.254.") || myIp.indexOf(":") > 0)) {
                        localIP = myIp;
                        break;
                    }
                    ++k;
                }
            }
            catch (UnknownHostException e) {
                AgentStartupLogger.logger.error("{} Exception occurred while getting agent Ip {}", (Object)logPrefix, (Object)e);
            }
        }
        return localIP;
    }
}

