/*
 * Decompiled with CFR 0.152.
 */
import com.eg.webservice.util.EgSOAPUtil;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BODSWebServiceBase
extends GenericTest {
    protected static String MY_DATE_PATTERN = "dd/MM/yy hh:mm:ss a";
    protected static SimpleDateFormat MY_SDF = new SimpleDateFormat(MY_DATE_PATTERN);
    private static final String LOGON_SOAP_ACTION_URL = "function=Logon";
    private static final String LOGOUT_SOAP_ACTION_URL = "function=Logout";
    protected static final String GET_BATCH_JOB_LIST_SOAP_ACTION_URL = "jobAdmin=Get_BatchJob_List";
    protected static final String GET_BATCH_JOB_EXE_DETAIL_SOAP_ACTION_URL = "jobAdmin=Get_BatchJob_ExeDetail";
    protected static final String GET_BATCH_JOB_RUN_IDS_SOAP_ACTION_URL = "jobAdmin=Get_BatchJob_RunIDs";
    protected String cmsServerName = null;
    protected String cmsUser = null;
    protected String cmsPass = null;
    protected String cmsAuthentication = null;
    protected static final String WEB_SERVICE_PORT = "8080";
    protected static final String CMS_SERVER_PORT = "6400";
    protected String urlString = "";
    boolean isSsl = false;
    private boolean ssl_enabled = false;
    String cmsServerPort = "6400";
    String targetURL = "";

    public BODSWebServiceBase(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        this.cmsServerName = this.getValueForParam("CMS_System");
        this.cmsUser = this.getValueForParam("Username");
        this.cmsPass = this.getValueForParam("Password");
        String string = this.getValueForParam("ssl");
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            this.isSsl = true;
        }
        this.urlString = this.isSsl ? "https://" + this.targetHost : "http://" + this.targetHost;
        String string2 = WEB_SERVICE_PORT;
        String string3 = this.getValueForParam("Web_Service_port");
        if (string3 != null && !string3.equalsIgnoreCase("null") && !string3.equalsIgnoreCase("none")) {
            try {
                Integer.parseInt(string3);
                string2 = string3;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.urlString = this.urlString + ":" + string2 + "/";
        this.printOut("urlString  :" + this.urlString, debug);
        String string4 = this.portNo;
        if (string4 != null && !string4.equalsIgnoreCase("null") && !string4.equalsIgnoreCase("none")) {
            try {
                Integer.parseInt(string4);
                this.cmsServerPort = string4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cmsAuthentication = "secEnterprise";
        this.targetURL = this.urlString + "/DataServices/servlet/webservices?ver=2.1";
    }

    public static void main(String[] stringArray) {
        BODSWebServiceBase bODSWebServiceBase = new BODSWebServiceBase(stringArray);
        System.out.println("Start time :" + new Date());
        long l = System.currentTimeMillis();
        bODSWebServiceBase.loginSession();
        System.out.println("End time :" + new Date());
        long l2 = System.currentTimeMillis();
        System.out.println("Total execution time :" + (l2 - l));
    }

    protected String loginSession() {
        String string = null;
        String string2 = null;
        try {
            String string3 = this.getLogonSOAPRequest(this.cmsServerName, this.cmsUser, this.cmsPass, this.cmsServerPort, this.cmsAuthentication);
            String string4 = EgSOAPUtil.invokeOperation((String)string3, (String)LOGON_SOAP_ACTION_URL, (String)this.targetURL, (String)"None", (String)"None");
            string2 = EgSOAPUtil.formatXML((String)string4);
            Document document = this.getDocumentFromFormatString(string2);
            if (document == null) {
                return null;
            }
            NodeList nodeList = document.getElementsByTagName("localtypes:session");
            if (nodeList != null) {
                Element element = (Element)nodeList.item(0);
                NodeList nodeList2 = element.getElementsByTagName("SessionID");
                Element element2 = (Element)nodeList2.item(0);
                string = this.getCharacterDataFromElement(element2);
            }
        }
        catch (Exception exception) {
            String string5 = null;
            Document document = this.getDocumentFromFormatString(string2);
            NodeList nodeList = document.getElementsByTagName("soapenv:Fault");
            if (nodeList != null) {
                Element element = (Element)nodeList.item(0);
                NodeList nodeList3 = element.getElementsByTagName("faultstring");
                Element element3 = (Element)nodeList3.item(0);
                string5 = this.getCharacterDataFromElement(element3);
            }
            this.printOut("Exception in loginSession method " + exception.getMessage() + ", Error Msg: " + string5);
            this.logToErrorFile("ERROR", this.entity + " : " + this.reportingName, "Exception in loginSession method. " + exception.getMessage() + ", Error Msg: " + string5 + ". ");
            return null;
        }
        return string;
    }

    protected void logout(String string) {
        this.printOut("Session will  expire in few seconds ", debug);
        String string2 = this.getLogoutSOAPRequest(string);
        String string3 = EgSOAPUtil.invokeOperation((String)string2, (String)LOGOUT_SOAP_ACTION_URL, (String)this.targetURL, (String)"None", (String)"None");
        String string4 = EgSOAPUtil.formatXML((String)string3);
    }

    protected String getCharacterDataFromElement(Element element) {
        try {
            if (element != null) {
                Node node = element.getFirstChild();
                NodeList nodeList = element.getChildNodes();
                if (node instanceof CharacterData) {
                    CharacterData characterData = (CharacterData)node;
                    return characterData.getData();
                }
            }
        }
        catch (Exception exception) {
            this.printOut("Exception " + this.getException(exception));
        }
        return "";
    }

    protected Document getDocumentFromFormatString(String string) {
        if (string == null) {
            return null;
        }
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(string));
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public void printOut(String string) {
        this.printOut(string, debug);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + MY_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    protected String getException(Exception exception) {
        return EgSOAPUtil.getException((Exception)exception);
    }

    protected String getCMSAuthentication(String string) {
        String string2 = "";
        return string2;
    }

    private String getLogonSOAPRequest(String string, String string2, String string3, String string4, String string5) {
        String string6 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string6 = string6 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"  xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string6 = string6 + "<soap:Body>";
        string6 = string6 + "<LogonRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string6 = string6 + "<username xmlns=\"\">" + string2 + "</username>";
        string6 = string6 + "<password xmlns=\"\">" + string3 + "</password>";
        string6 = string6 + "<cms_system xmlns=\"\">" + string + "</cms_system>";
        string6 = string6 + "<cms_authentication xmlns=\"\">" + string5 + "</cms_authentication>";
        string6 = string6 + "</LogonRequest>";
        string6 = string6 + "</soap:Body>";
        string6 = string6 + "</soap:Envelope>";
        return string6;
    }

    private String getLogoutSOAPRequest(String string) {
        String string2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string2 = string2 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string2 = string2 + "<soap:Header>";
        string2 = string2 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string2 = string2 + "<SessionID xmlns=\"\">" + string + "</SessionID>";
        string2 = string2 + " </session>";
        string2 = string2 + "</soap:Header>";
        string2 = string2 + "<soap:Body>";
        string2 = string2 + "<Logout_Input xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\" />";
        string2 = string2 + "</soap:Body>";
        string2 = string2 + "</soap:Envelope>";
        return string2;
    }

    protected String getBatchJobListSOAPRequest(String string) {
        String string2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string2 = string2 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"  xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string2 = string2 + "<soap:Header>";
        string2 = string2 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string2 = string2 + "<SessionID xmlns=\"\">" + string + "</SessionID>";
        string2 = string2 + " </session>";
        string2 = string2 + "</soap:Header>";
        string2 = string2 + "<soap:Body>";
        string2 = string2 + "<GetListOfBatchJobsRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string2 = string2 + "<repoName xmlns=\"\" />";
        string2 = string2 + "<allBatchJobs xmlns=\"\">true</allBatchJobs>";
        string2 = string2 + "</GetListOfBatchJobsRequest>";
        string2 = string2 + "</soap:Body>";
        string2 = string2 + "</soap:Envelope>";
        return string2;
    }

    protected String getDate(long l, SimpleDateFormat simpleDateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar = this.setTimeInMillis(calendar, l);
        return simpleDateFormat.format(calendar.getTime());
    }

    private Calendar setTimeInMillis(Calendar calendar, long l) {
        try {
            calendar.getClass().getMethod("setTimeInMillis", Long.TYPE).invoke((Object)calendar, new Long(l));
        }
        catch (Exception exception) {
            calendar.setTime(new Date(l));
        }
        return calendar;
    }

    protected String getBatchJobRunIDsDocSOAPRequest(String string, String string2, String string3, String string4) {
        String string5 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
        string5 = string5 + "<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">";
        string5 = string5 + "<soap:Header>";
        string5 = string5 + "<session xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<SessionID>" + string + "</SessionID>";
        string5 = string5 + "</session>";
        string5 = string5 + "</soap:Header>";
        string5 = string5 + "<soap:Body>";
        string5 = string5 + "<batchJobRunIDsRequest xmlns=\"http://www.businessobjects.com/DataServices/ServerX.xsd\">";
        string5 = string5 + "<jobName xmlns=\"\">" + string3 + "</jobName>";
        string5 = string5 + "<status xmlns=\"\">" + string4 + "</status>";
        string5 = string5 + "<repoName xmlns=\"\">" + string2 + "</repoName>";
        string5 = string5 + "</batchJobRunIDsRequest>";
        string5 = string5 + "</soap:Body>";
        string5 = string5 + "</soap:Envelope>";
        return string5;
    }
}

