/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class AzureWVDBrokerDiscovery {
    String tenant_id = "";
    String client_id = "";
    String client_pwd = "";
    String accessToken = "";
    public static Hashtable URL_percent_encoding = new Hashtable();
    public static Hashtable API_hash = new Hashtable();
    public Hashtable azrAccessTokenHash = new Hashtable();
    boolean isDebugOn = false;
    String subscriptionId = "";
    boolean isProxyEnabled = false;
    String strProxyHost = "";
    String strProxyPort = "";
    String strProxyUser = "";
    String strProxyPass = "";
    String reportingName = "";
    public static final String managementTargetIp = "management.azure.com";
    public static final int sslPort = 443;
    public static final String sslProtocol = "https";
    public static final String nonSslProtocol = "http";

    public AzureWVDBrokerDiscovery(String string, String string2, String string3, String string4, String string5) {
        this.tenant_id = string;
        this.client_id = string2;
        this.client_pwd = string3;
        this.subscriptionId = string4;
        this.reportingName = string5;
        this.isProxyEnabled = false;
    }

    public AzureWVDBrokerDiscovery(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        this.tenant_id = string;
        this.client_id = string2;
        this.client_pwd = string3;
        this.subscriptionId = string4;
        this.reportingName = string5;
        this.strProxyHost = string6;
        this.strProxyPort = string7;
        this.strProxyUser = string8;
        this.strProxyPass = string9;
        if (string6 != null && string6.trim().length() > 0 && !string6.trim().equalsIgnoreCase("none") && string7 != null && string7.trim().length() > 0 && !string7.trim().equalsIgnoreCase("none")) {
            this.isProxyEnabled = true;
        }
        URL_percent_encoding.put(" ", "%20");
        URL_percent_encoding.put("[", "%5B");
        URL_percent_encoding.put("]", "%5D");
        URL_percent_encoding.put("^", "%5E");
        URL_percent_encoding.put("<", "%3C");
        URL_percent_encoding.put(">", "%3E");
        URL_percent_encoding.put("{", "%7B");
        URL_percent_encoding.put("}", "%7D");
        URL_percent_encoding.put("`", "%80");
        URL_percent_encoding.put("|", "%7C");
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n < 5) {
            System.out.println("Please provide the valid credentials, java AzureWVDBrokerDiscovery <tenant_id> <client_id> <client_secret>");
            return;
        }
        String string = stringArray[0].trim();
        String string2 = stringArray[1].trim();
        String string3 = stringArray[2].trim();
        String string4 = stringArray[3].trim();
        String string5 = stringArray[4].trim();
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        if (n >= 9) {
            string6 = stringArray[5].trim();
            string7 = stringArray[6].trim();
            string8 = stringArray[7].trim();
            string9 = stringArray[8].trim();
        }
        AzureWVDBrokerDiscovery azureWVDBrokerDiscovery = new AzureWVDBrokerDiscovery(string, string2, string3, string4, string5, string6, string7, string8, string9);
        System.out.println(azureWVDBrokerDiscovery.getWVDBrokerDetails());
    }

    public ArrayList getWVDBrokerDetails() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.subscriptionId == null || this.subscriptionId.trim().length() == 0) {
                return new ArrayList();
            }
            String string = "subscriptions/" + this.subscriptionId + "/resources?api-version=2017-05-10";
            String string2 = this.executeHttpCmd(string, "GET");
            if (this.isDebugOn) {
                System.out.println("[AzureWVDBrokerDiscovery] outputString = " + string2);
            }
            if (string2 == null || string2.trim().length() == 0) {
                return new ArrayList();
            }
            boolean bl = this.checkWVDResourceAvailable(string2.trim());
            if (bl) {
                String string3 = "AVDBroker_" + this.reportingName;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private boolean checkWVDResourceAvailable(String string) {
        boolean bl = false;
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string);
            if (jsonObject == null) {
                return false;
            }
            JsonArray jsonArray = (JsonArray)jsonObject.get("value");
            if (jsonArray == null || jsonArray.size() == 0) {
                return false;
            }
            int n = jsonArray.size();
            String string2 = "";
            String string3 = "";
            for (int i = 0; i < n; ++i) {
                JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                if (jsonObject2 == null) continue;
                if (jsonObject2.has("name")) {
                    string2 = AzureWVDBrokerDiscovery.replace(jsonObject2.get("name").toString(), "\"", "");
                }
                if (jsonObject2.has("type")) {
                    string3 = AzureWVDBrokerDiscovery.replace(jsonObject2.get("type").toString(), "\"", "");
                }
                if (string3 == null || string3.trim().indexOf("Microsoft.DesktopVirtualization/hostpools") <= -1 && string3.trim().indexOf("Microsoft.DesktopVirtualization/workspaces") <= -1 && string3.trim().indexOf("Microsoft.DesktopVirtualization/applicationGroups") <= -1) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isDebugOn) {
            System.out.println("isAvailable --->" + bl);
        }
        return bl;
    }

    private JsonObject getJsonObject(JsonElement jsonElement) {
        JsonObject jsonObject = null;
        try {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                return null;
            }
            jsonObject = jsonElement.getAsJsonObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonObject;
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String executeHttpCmd(String string, String string2) {
        String string3 = "";
        String string4 = "";
        String string5 = "/";
        try {
            X509HostnameVerifier x509HostnameVerifier;
            SSLContext sSLContext;
            HttpClientBuilder httpClientBuilder;
            String string6;
            int n;
            string4 = (String)this.azrAccessTokenHash.get("accessToken");
            if (string4 == null || string4.length() == 0) {
                string4 = this.getAccessToken();
            }
            if (string4 != null && string4.trim().length() > 0 && (n = (string6 = string4.trim()).indexOf("#~#")) > 0) {
                string4 = string6.substring(0, n);
            }
            if (string4 == null || string4.length() == 0) {
                return null;
            }
            this.azrAccessTokenHash.put("accessToken", string4);
            string6 = string5 + string;
            string6 = this.validateURL(string6);
            CloseableHttpClient closeableHttpClient = null;
            HttpGet httpGet = null;
            if (this.isProxyEnabled) {
                httpClientBuilder = new SSLContextBuilder();
                httpClientBuilder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                        return true;
                    }
                });
                sSLContext = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                x509HostnameVerifier = new SSLConnectionSocketFactory(httpClientBuilder.build(), (X509HostnameVerifier)sSLContext);
                BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(new AuthScope(this.strProxyHost, Integer.parseInt(this.strProxyPort)), (Credentials)new UsernamePasswordCredentials(this.strProxyUser, this.strProxyPass));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)x509HostnameVerifier).build();
                HttpHost httpHost = new HttpHost(this.strProxyHost, Integer.parseInt(this.strProxyPort));
                RequestConfig requestConfig = RequestConfig.custom().setProxy(httpHost).build();
                httpGet = new HttpGet(string6);
                httpGet.setConfig(requestConfig);
            } else {
                httpClientBuilder = HttpClientBuilder.create();
                sSLContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                        return true;
                    }
                }).build();
                httpClientBuilder.setSslcontext(sSLContext);
                x509HostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, x509HostnameVerifier);
                Registry registry = RegistryBuilder.create().register(nonSslProtocol, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(sslProtocol, (Object)sSLConnectionSocketFactory).build();
                PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
                closeableHttpClient = httpClientBuilder.build();
                httpGet = new HttpGet(string6);
            }
            httpClientBuilder = new HttpHost(managementTargetIp, 443, sslProtocol);
            httpGet.setHeader("Authorization", "Bearer " + string4);
            httpGet.setHeader("Content-Type", "application/json");
            sSLContext = closeableHttpClient.execute((HttpHost)httpClientBuilder, (HttpRequest)httpGet);
            x509HostnameVerifier = sSLContext.getEntity();
            if (x509HostnameVerifier != null && (string3 = EntityUtils.toString((HttpEntity)x509HostnameVerifier)) == null) {
                string3 = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string3;
    }

    private ArrayList parseSubscriptionData(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string);
            JsonArray jsonArray = (JsonArray)jsonObject.get("value");
            if (jsonArray == null || jsonArray.size() == 0) {
                return arrayList;
            }
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                if (jsonObject2 == null) continue;
                String string2 = "";
                if (jsonObject2.has("subscriptionId")) {
                    string2 = AzureWVDBrokerDiscovery.replace(jsonObject2.get("subscriptionId").toString(), "\"", "");
                }
                if (string2 == null || string2.trim().length() == 0) continue;
                string2 = string2.trim();
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public String validateURL(String string) {
        try {
            Enumeration enumeration = URL_percent_encoding.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2 == null || string.indexOf(string2) <= -1) continue;
                String string3 = (String)URL_percent_encoding.get(string2);
                string = AzureWVDBrokerDiscovery.replace(string, string2, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getAccessToken() throws Exception {
        String string;
        block12: {
            string = "";
            try {
                String string2;
                int n;
                int n2;
                String string3 = " -cp \"" + EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar;" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-httpclient.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-httpcore.jar;" + EgInstallInfo.getInstallDir() + "/lib/commons-logging.jar;" + EgInstallInfo.getInstallDir() + "/lib/mail.jar;" + EgInstallInfo.getInstallDir() + "/lib/gson.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/adal4j.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/commons-lang.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/json-smart.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/nimbus-jose-jwt.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/oauth2-oidc-sdk.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/content-type.jar;" + EgInstallInfo.getInstallDir() + "/lib/Azure/msal4j.jar;" + EgInstallInfo.getInstallDir() + "/agent/lib/slf4j-api.jar\"";
                String string4 = System.getProperty("os.name");
                if (string4.equalsIgnoreCase("linux")) {
                    string3 = " -cp " + EgInstallInfo.getInstallDir() + "/lib/eg_agent.jar:" + EgInstallInfo.getInstallDir() + "/lib/eg_util.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-codec.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-httpclient.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-httpcore.jar:" + EgInstallInfo.getInstallDir() + "/lib/commons-logging.jar:" + EgInstallInfo.getInstallDir() + "/lib/mail.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/adal4j.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/commons-lang.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/nimbus-jose-jwt.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/content-type.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/msal4j.jar:" + EgInstallInfo.getInstallDir() + "/lib/Azure/oauth2-oidc-sdk.jar";
                }
                String string5 = System.getProperty("java.version");
                String string6 = "";
                if (string5.compareTo("10.0") > 0) {
                    string6 = "-XX:ErrorFile=/dev/null -XX:HeapDumpPath=/dev/null -XX:-CreateCoredumpOnCrash";
                    if (string4 != null && string4.toLowerCase().indexOf("win") >= 0) {
                        string6 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateCoredumpOnCrash";
                    }
                } else if (string5.compareTo("1.7") > 0) {
                    string6 = "-XX:ErrorFile=NUL -XX:HeapDumpPath=NUL -XX:-CreateMinidumpOnCrash";
                }
                String string7 = EgInstallInfo.getInstallDir() + "/jre/bin/java ";
                String string8 = "";
                string8 = this.isProxyEnabled ? string7 + string6 + string3 + " GetAccessToken  " + this.tenant_id + " " + this.client_id + " " + this.client_pwd + " " + this.strProxyHost + " " + this.strProxyPort + " " + this.strProxyUser + " " + this.strProxyPass : string7 + string6 + string3 + " GetAccessToken  " + this.tenant_id + " " + this.client_id + " " + this.client_pwd;
                EgUtilities egUtilities = EgUtilities.createInstance();
                if (this.isDebugOn) {
                    System.out.println("[getAccessToken] Get ExecOutputLine start time =>" + new Date());
                }
                ArrayList arrayList = egUtilities.getExecOutputLines(string8);
                if (this.isDebugOn) {
                    System.out.println("[getAccessToken] Get ExecOutputLine end time =>" + new Date());
                }
                if (arrayList == null || arrayList.size() < 2) break block12;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    n2 = arrayList3.size();
                    for (n = 0; n < n2; ++n) {
                        string2 = (String)arrayList3.get(n);
                        if (string2 != null && string2.trim().length() != 0 && (string2 = string2.trim()).indexOf("SLF4J:") <= -1 && string2.indexOf("Instance discovery was successful") <= -1) continue;
                    }
                }
                n2 = arrayList2.size();
                for (n = 0; n < n2; ++n) {
                    string2 = (String)arrayList2.get(n);
                    if (string2 == null || string2.length() == 0 || !(string2 = string2.trim()).startsWith("AccessToken:")) continue;
                    string = string2.substring(string2.indexOf(":") + 1);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    private void parseApiVersionJsonData(String string, String string2) {
        ArrayList<String> arrayList = null;
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(string);
            JsonArray jsonArray = (JsonArray)jsonObject.get("value");
            if (jsonArray == null || jsonArray.size() == 0) {
                System.out.println("[DTMAzureHelper] apiversion array  is null. So return empty list");
                return;
            }
            int n = jsonArray.size();
            for (int i = 0; i < n; ++i) {
                JsonArray jsonArray2;
                String string3 = "";
                String string4 = "";
                JsonObject jsonObject2 = (JsonObject)jsonArray.get(i);
                if (jsonObject2 != null && jsonObject2.has("namespace") && ((string3 = AzureARMTestBase.replace((String)jsonObject2.get("namespace").toString(), (String)"\"", (String)"")) == null || string3.trim().length() == 0) || jsonObject2 == null || !jsonObject2.has("resourceTypes") || (jsonArray2 = (JsonArray)jsonObject2.get("resourceTypes")) == null || jsonArray2.size() == 0) continue;
                int n2 = jsonArray2.size();
                for (int j = 0; j < n2; ++j) {
                    Object object;
                    JsonObject jsonObject3 = (JsonObject)jsonArray2.get(j);
                    if (jsonObject3 != null && jsonObject3.has("resourceType") && ((string4 = AzureARMTestBase.replace((String)jsonObject3.get("resourceType").toString(), (String)"\"", (String)"")) == null || string4.length() == 0)) continue;
                    if (jsonObject3 != null && jsonObject3.has("apiVersions")) {
                        object = (JsonArray)jsonObject3.get("apiVersions");
                        if (object == null || object.size() == 0) continue;
                        int n3 = object.size();
                        arrayList = new ArrayList<String>();
                        for (int k = 0; k < n3; ++k) {
                            String string5 = AzureARMTestBase.replace((String)object.get(k).toString(), (String)"\"", (String)"");
                            arrayList.add(string5);
                        }
                    }
                    object = string3 + "/" + string4;
                    API_hash.put(object, arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getAPIVersion() {
        String string = "subscriptions?api-version=2015-01-01";
        try {
            String string2 = this.executeHttpCmd(string, "GET");
            if (string2 == null || string2.trim().length() == 0) {
                System.out.println("subScripData is null or empty. So return!");
                return;
            }
            ArrayList arrayList = this.parseSubscriptionData(string2 = string2.trim());
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            String string3 = (String)arrayList.get(0);
            String string4 = "subscriptions/" + string3 + "/providers?api-version=2015-01-01";
            String string5 = this.executeHttpCmd(string4, "GET");
            if (string5 != null && string5.trim().length() > 0) {
                string5 = string5.trim();
                this.parseApiVersionJsonData(string5, string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getAPIVersion(String string) {
        String string2 = "";
        try {
            ArrayList arrayList = (ArrayList)API_hash.get(string);
            if (arrayList == null || arrayList.size() == 0) {
                return string2;
            }
            string2 = (String)arrayList.get(0);
            if (string2 == null) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string2 = "";
        }
        return string2.trim();
    }
}

