/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ApigeeEdgeValidatorRESTExecutor {
    private static final int j = 124;
    private String port = null;
    private String userName = null;
    private String password = null;
    private String reportingName = null;
    private String entity = null;
    private long collectionTimeout;
    private static final String def_IdleTimeout = "120";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    String logMessage = "";
    String className = this.getClass().getName();
    String targetHost = null;
    protected static final String TEST_NAME = "ApigeeEdgeValidator";
    protected static final String LOG_FILE_NAME = "ApigeeEdgeValidatorLog";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "ApigeeEdgeValidatorLog";
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE_JSON = "application/json";
    protected static final String REQUEST_METHOD_GET = "GET";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    double debugLogSizeLimitInMB = 5000000.0;
    double lastMeaPeriodInSec = 300.0;
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    protected boolean isSSL = false;
    protected static final String PROTOTYPE_HTTP = "http";
    protected static final String PROTOTYPE_HTTPS = "https";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 500;
    protected static final String SPACE = new String(" ");
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    protected static final String CACHE_CONTROL = "Cache-Control";
    protected static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String COLONS = ":";
    private static final String SEPERATOR_1 = "~!~";
    protected static final String DEBUG = "DEBUG";
    protected static final String INFO = "INFO";
    protected static final String WARNING = "WARNING";
    protected static final String ERROR = "ERROR";
    boolean deep_debug = false;
    private static final String APIGEE_ANALYTICS_TIME_FORMAT = "MM/dd/yyyy HH:mm";
    protected static final String APP_USER_ANALYTICS_URI = "stats/apps?select=user_count";
    private static final String APIGEE_REST_OUTPUT = "APIGEE_REST_OUTPUT:";
    private static final String COMPONENT_INFO_OUTPUT = "COMPONENT_INFO_OUTPUT:";
    private static final String APP_USER_ANALYTICS_OUTPUT = "APP_USER_ANALYTICS_OUTPUT:";
    String protoType = "";
    protected String organizations = null;
    protected String environments = "test";
    protected String uri = "";
    protected String method = "";
    String logSizeDebugMsg = "";
    String meaPeriodDebugMsg = "";
    String organizationMsg = "";
    String organizationWarnMsg = "";
    String environmentsMsg = "";
    String environmentsWarnMsg = "";
    String uriMsg = "";
    String uriWarnMsg = "";
    String methodMsg = "";
    String methodWarnMsg = "";
    String strLogSizeLimitInMB = "";

    public ApigeeEdgeValidatorRESTExecutor(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    this.targetHost = new String(stringArray[++i]);
                    if (this.targetHost != null) {
                        this.targetHost = this.targetHost.trim();
                    }
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    this.port = new String(stringArray[++i]);
                    if (this.port == null) continue;
                    this.port = this.port.trim();
                    continue;
                }
                if (stringArray[i].equals("-username") && i + 1 < stringArray.length) {
                    this.userName = new String(stringArray[++i]);
                    if (this.userName == null) continue;
                    this.userName = this.userName.trim();
                    continue;
                }
                if (stringArray[i].equals("-password") && i + 1 < stringArray.length) {
                    this.password = new String(stringArray[++i]);
                    if (this.password != null) {
                        this.password = this.password.trim();
                    }
                    this.password = this.decrypt(this.password);
                    continue;
                }
                if (stringArray[i].equals("-timeout") && i + 1 < stringArray.length) {
                    string = new String(stringArray[++i]);
                    try {
                        this.collectionTimeout = Long.parseLong(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            this.collectionTimeout = Long.parseLong(def_IdleTimeout);
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                    continue;
                }
                if (stringArray[i].equals("-reportingName") && i + 1 < stringArray.length) {
                    this.reportingName = new String(stringArray[++i]);
                    if (this.reportingName == null) continue;
                    this.reportingName = this.reportingName.trim();
                    continue;
                }
                if (stringArray[i].equals("-entity") && i + 1 < stringArray.length) {
                    this.entity = new String(stringArray[++i]);
                    if (this.entity == null) continue;
                    this.entity = this.entity.trim();
                    continue;
                }
                if (stringArray[i].equals("-log_size") && i + 1 < stringArray.length) {
                    this.strLogSizeLimitInMB = new String(stringArray[++i]);
                    if (this.strLogSizeLimitInMB == null || this.strLogSizeLimitInMB.length() <= 0) continue;
                    this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                    }
                    catch (Exception exception) {
                        this.logSizeDebugMsg = "strLogSizeLimitInMB : " + this.strLogSizeLimitInMB + " ,exception :" + exception.toString();
                        this.debugLogSizeLimitInMB = 5000000.0;
                    }
                    continue;
                }
                if (stringArray[i].equals("-mea_period_in_sec") && i + 1 < stringArray.length) {
                    if ((string = new String(stringArray[++i])) == null || string.length() <= 0) continue;
                    string = string.trim();
                    try {
                        this.lastMeaPeriodInSec = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        this.meaPeriodDebugMsg = "strLastMeaPeriodInSeconds : " + string + " ,exception :" + exception.toString();
                        this.lastMeaPeriodInSec = 300.0;
                    }
                    continue;
                }
                if (stringArray[i].equals("-ssl") && i + 1 < stringArray.length) {
                    if ((string = new String(stringArray[++i])) != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y"))) {
                        this.isSSL = true;
                        this.protoType = PROTOTYPE_HTTPS;
                        continue;
                    }
                    this.isSSL = false;
                    this.protoType = PROTOTYPE_HTTP;
                    continue;
                }
                if (stringArray[i].equals("-organizations") && i + 1 < stringArray.length) {
                    this.organizations = new String(stringArray[++i]);
                    if (this.organizations == null || this.organizations.trim().length() == 0 || this.organizations.equalsIgnoreCase(NULL) || this.organizations.equalsIgnoreCase(NONE)) {
                        this.organizationWarnMsg = "Organizations is null or empty ";
                        continue;
                    }
                    this.organizationMsg = "Organizations :" + this.organizations;
                    continue;
                }
                if (stringArray[i].equals("-environments") && i + 1 < stringArray.length) {
                    this.environments = new String(stringArray[++i]);
                    if (this.environments == null || this.environments.trim().length() == 0 || this.environments.equalsIgnoreCase(NULL) || this.environments.equalsIgnoreCase(NONE)) {
                        this.environments = "uat";
                        this.environmentsWarnMsg = "Environments is null or empty ,so assinging default value as \"uat\" ";
                        continue;
                    }
                    this.environmentsMsg = "Environments :" + this.environments;
                    continue;
                }
                if (stringArray[i].equals("-uri") && i + 1 < stringArray.length) {
                    this.uri = new String(stringArray[++i]);
                    if (this.uri == null || this.uri.trim().length() == 0 || this.uri.equalsIgnoreCase(NULL) || this.uri.equalsIgnoreCase(NONE)) {
                        this.uriWarnMsg = "URI is null or empty";
                        continue;
                    }
                    this.uriMsg = "URI :" + this.uri;
                    continue;
                }
                if (!stringArray[i].equals("-method") || i + 1 >= stringArray.length) continue;
                this.method = new String(stringArray[++i]);
                if (this.method == null || this.method.trim().length() == 0 || this.method.equalsIgnoreCase(NULL) || this.method.equalsIgnoreCase(NONE)) {
                    this.methodWarnMsg = "Method is null or empty";
                    continue;
                }
                this.methodMsg = "Method :" + this.method;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        if (this.logSizeDebugMsg != null && this.logSizeDebugMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.logSizeDebugMsg);
        }
        if (this.meaPeriodDebugMsg != null && this.meaPeriodDebugMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.meaPeriodDebugMsg);
        }
        this.printOut("[" + this.className + "]: [Constructor ]: lastMeaPeriodInSec : " + this.lastMeaPeriodInSec);
        if (this.organizationWarnMsg != null && this.organizationWarnMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.organizationWarnMsg);
        }
        if (this.organizationMsg != null && this.organizationMsg.trim().length() > 0) {
            this.printOut("[" + this.className + "]: [Constructor ]: " + this.organizationMsg);
        }
        if (this.environmentsWarnMsg != null && this.environmentsWarnMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.environmentsWarnMsg);
        }
        if (this.environmentsMsg != null && this.environmentsMsg.trim().length() > 0) {
            this.printOut("[" + this.className + "]: [Constructor ]: " + this.environmentsMsg);
        }
        if (this.uriWarnMsg != null && this.uriWarnMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.uriWarnMsg);
        }
        if (this.uriMsg != null && this.uriMsg.trim().length() > 0) {
            this.printOut("[" + this.className + "]: [Constructor ]: " + this.uriMsg);
        }
        if (this.methodWarnMsg != null && this.methodWarnMsg.trim().length() > 0) {
            this.putWarningMessageToLogfile("[" + this.className + "]: [Constructor ]: " + this.methodWarnMsg);
        }
        if (this.methodMsg != null && this.methodMsg.trim().length() > 0) {
            this.printOut("[" + this.className + "]: [Constructor ]: " + this.methodMsg);
        }
        this.printOut("[" + this.className + "]: [Constructor ]: debugLogSizeLimitInMB : " + this.debugLogSizeLimitInMB);
        this.printOut("[" + this.className + "]: [Constructor ]: Transport type is " + this.protoType);
    }

    public static void main(String[] stringArray) {
        ApigeeEdgeValidatorRESTExecutor apigeeEdgeValidatorRESTExecutor = new ApigeeEdgeValidatorRESTExecutor(stringArray);
        if (apigeeEdgeValidatorRESTExecutor.method.equalsIgnoreCase("getJSONDataFromURL")) {
            apigeeEdgeValidatorRESTExecutor.getJSONDataFromURL();
        } else if (apigeeEdgeValidatorRESTExecutor.method.equalsIgnoreCase("getJSONDataFromURLForComponentInfo")) {
            apigeeEdgeValidatorRESTExecutor.getJSONDataFromURLForComponentInfo();
        }
    }

    public void getJSONDataFromURLForComponentInfo() {
        Object object;
        String string = "getJSONDataFromURLForComponentInfo";
        string = this.methodNameTemplate(string);
        String string2 = null;
        long l = System.currentTimeMillis();
        String string3 = "COMPONENT_INFO_OUTPUT:none";
        String string4 = this.uri;
        if (string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase(NULL) || string4.equalsIgnoreCase(NONE)) {
            string4 = "/v1/servers/self";
        }
        String string5 = this.protoType + "://" + this.targetHost + COLONS + this.port + string4;
        this.enableSSLForApigeeEdge();
        try {
            long l2 = System.currentTimeMillis();
            string2 = string5;
            this.printOut(string + "URL before call data collection thread =========> " + string2);
            object = new DataCollectionThread(string2);
            this.runThread((MonitoredThread)object, "DataCollection", 20L);
            this.printOut(string + "Data Collected for  " + this.targetHost + " for metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string3 = ((DataCollectionThread)object).getResponseString();
            string3 = COMPONENT_INFO_OUTPUT + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + "Data URL =========> " + string2 + " ,Exception raised ", exception);
        }
        object = "APIGEE_REST_OUTPUT:~!~" + string3;
        this.printOut(string + " All of the data collection process is completed , please check data collected properly ");
        this.printOut(string + "Data collected for Validation process :" + (String)object);
        this.printOut(string + "Data collection for all process for   " + this.targetHost + " took  " + (System.currentTimeMillis() - l) + "ms.");
    }

    public void getJSONDataFromURL() {
        Object object;
        String string = "getJSONDataFromURL";
        string = this.methodNameTemplate(string);
        String string2 = null;
        String string3 = "APP_USER_ANALYTICS_OUTPUT:none";
        long l = System.currentTimeMillis();
        this.enableSSLForApigeeEdge();
        if (this.organizations == null || this.organizations.trim().length() == 0 || this.organizations.equalsIgnoreCase(NULL) || this.organizations.equalsIgnoreCase(NONE)) {
            this.logMessage = string + "Organizations is null or empty ,so returning with null";
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
        }
        String string4 = this.getApigeeTimeRange(this.lastMeaPeriodInSec);
        String string5 = this.protoType + "://" + this.targetHost + COLONS + this.port + "/v1/organizations/" + this.organizations + "/environments/" + this.environments + "/";
        String string6 = "&timeRange=" + string4;
        String string7 = "&timeUnit=minute";
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        try {
            long l2 = System.currentTimeMillis();
            string2 = string5 + APP_USER_ANALYTICS_URI + string6 + string7;
            this.printOut(string + " data URL before call App user analytics data collection thread  =========> " + string2);
            object = new DataCollectionThread(string2);
            this.runThread((MonitoredThread)object, "DataCollection", 20L);
            this.printOut(string + "Data Collected for  " + this.targetHost + " for App user analytics metrics " + (System.currentTimeMillis() - l2) + "ms.");
            string3 = ((DataCollectionThread)object).getResponseString();
            string3 = APP_USER_ANALYTICS_OUTPUT + string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + "App user analytics data URL =========> " + string2 + " ,Exception raised ", exception);
        }
        object = "APIGEE_REST_OUTPUT:~!~" + string3;
        this.printOut(string + " All of the data collection process is completed , please check data collected properly ");
        this.printOut(string + "Data collected for Validation process :" + (String)object);
        this.printOut(string + "Data collection for all process for   " + this.targetHost + " took  " + (System.currentTimeMillis() - l) + "ms.");
    }

    protected String getApigeeTimeRange(double d) {
        String string = "getApigeeTimeRange";
        string = this.methodNameTemplate(string);
        if (d < 0.0) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(APIGEE_ANALYTICS_TIME_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.printOut(string + "Current time in UTC : " + simpleDateFormat.format(new Date()));
        String string4 = simpleDateFormat.format(new Date());
        Date date = null;
        try {
            date = simpleDateFormat.parse(string4);
        }
        catch (ParseException parseException) {
            this.logMessage = string + "Exception happened while  parsing the time string  ";
            this.printOutStackTrace(this.logMessage, parseException);
            this.logMessage = "";
        }
        long l = date.getTime();
        this.printOut(string + "Current time in millis for UTC :" + l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        string3 = simpleDateFormat.format(calendar.getTime());
        string3 = this.replaceAll(string3, " ", "%20");
        calendar = null;
        calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l - (long)d * 1000L);
        string2 = simpleDateFormat.format(calendar.getTime());
        string2 = this.replaceAll(string2, " ", "%20");
        this.logMessage = string + "Back time in UTC for test input :" + string2 + ", Current time in UTC for test input :" + string3 + ", time since last test(seconds) :" + d;
        this.printOut(this.logMessage);
        this.logMessage = "";
        String string5 = string2 + "~" + string3;
        this.logMessage = string + "Time range  String :" + string5;
        this.printOut(this.logMessage);
        this.logMessage = "";
        return string5;
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        String string2 = "runThread";
        string2 = this.methodNameTemplate(string2);
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.printOutStackTrace(string2, interruptedException);
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.collectionTimeout) {
            this.printOut(string2 + "Thread " + string + " still alive");
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string3 = "";
        this.printOut(string2 + "mt.status   :" + monitoredThread.status);
        this.printOut(string2 + "mt.isAlive  :" + monitoredThread.isAlive());
        if (monitoredThread.isAlive()) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " timed out with exception.";
            } else {
                bl = true;
                string3 = " timed out.";
            }
        } else if (monitoredThread.status != 1) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " got done with exception.";
            } else {
                bl = true;
                string3 = " aborted without exception";
            }
        }
        this.printOut(string2 + "interruptThread   :" + bl);
        if (bl) {
            monitoredThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            this.printOut(string2 + "Error: Thread " + string + " " + string3);
            this.putErrorMessageToLogfile("Thread " + string + string3);
            throw new Exception("Thread " + string + " " + string3);
        }
    }

    void enableSSLForApigeeEdge() {
        String string = null;
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var4_4 = null;
        MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
        KeyManager[] keyManagerArray = null;
        TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
        SSLContext sSLContext = null;
        try {
            sSLContext = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string = "[enableSSLForApigeeEdge]";
            this.printOutStackTrace(string, noSuchAlgorithmException);
        }
        try {
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        }
        catch (KeyManagementException keyManagementException) {
            string = "[enableSSLForApigeeEdge]";
            this.printOutStackTrace(string, keyManagementException);
        }
        SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
        HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(COLONS) == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, COLONS);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        ApigeeEdgeValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        ApigeeEdgeValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        ApigeeEdgeValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        ApigeeEdgeValidatorRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            ApigeeEdgeValidatorRESTExecutor.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    static /* synthetic */ String access$000(ApigeeEdgeValidatorRESTExecutor apigeeEdgeValidatorRESTExecutor) {
        return apigeeEdgeValidatorRESTExecutor.userName;
    }

    static /* synthetic */ String access$100(ApigeeEdgeValidatorRESTExecutor apigeeEdgeValidatorRESTExecutor) {
        return apigeeEdgeValidatorRESTExecutor.password;
    }

    class DataCollectionThread
    extends MonitoredThread {
        URL url = null;
        String urlString = null;
        String responseString = null;
        String authStr = ApigeeEdgeValidatorRESTExecutor.access$000(ApigeeEdgeValidatorRESTExecutor.this) + ":" + ApigeeEdgeValidatorRESTExecutor.access$100(ApigeeEdgeValidatorRESTExecutor.this);
        String authEncoded = Base64Coder.encodeString(this.authStr);

        DataCollectionThread(String string) {
            String string2 = "DataCollectionThread::Constructor";
            string2 = ApigeeEdgeValidatorRESTExecutor.this.methodNameTemplate(string2);
            try {
                this.setName("DataCollection_" + ApigeeEdgeValidatorRESTExecutor.this.reportingName);
                this.url = new URL(string);
                this.urlString = string;
                ApigeeEdgeValidatorRESTExecutor.this.printOut(string2 + "urlStr  : " + string);
            }
            catch (Exception exception) {
                ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace("Exception while construct the URL", exception);
                exception.printStackTrace();
            }
        }

        public void run() {
            String string = "DataCollectionThread::run";
            string = ApigeeEdgeValidatorRESTExecutor.this.methodNameTemplate(string);
            Object var2_2 = null;
            try {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection = (HttpURLConnection)this.url.openConnection();
                httpURLConnection.setRequestMethod(ApigeeEdgeValidatorRESTExecutor.REQUEST_METHOD_GET);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(500);
                httpURLConnection.addRequestProperty("Content-Type", "application/json");
                httpURLConnection.addRequestProperty(ApigeeEdgeValidatorRESTExecutor.AUTHORIZATION, BASIC + this.authEncoded);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    System.out.println("Response Code :" + n);
                    ApigeeEdgeValidatorRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + this.urlString;
                    ApigeeEdgeValidatorRESTExecutor.this.printOut(ApigeeEdgeValidatorRESTExecutor.this.logMessage);
                    if (n > 300) {
                        ApigeeEdgeValidatorRESTExecutor.this.putInfoMessageToLogfile(ApigeeEdgeValidatorRESTExecutor.this.logMessage);
                    }
                    ApigeeEdgeValidatorRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                }
                catch (Exception exception) {
                    ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (ApigeeEdgeValidatorRESTExecutor.this.deep_debug) {
                    ApigeeEdgeValidatorRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    ApigeeEdgeValidatorRESTExecutor.this.printOut(ApigeeEdgeValidatorRESTExecutor.this.logMessage);
                    ApigeeEdgeValidatorRESTExecutor.this.logMessage = "";
                }
                this.status = this.responseString == null || this.responseString.trim().length() == 0 ? -1 : 1;
            }
            catch (Exception exception) {
                this.status = -1;
                exception.printStackTrace();
                ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace(string + "Exception inside the thread run method", exception);
            }
        }

        protected String decodeResponse(InputStream inputStream) {
            try {
                Scanner scanner = new Scanner(inputStream);
                scanner.useDelimiter("\\A");
                return scanner.hasNext() ? scanner.next() : "";
            }
            catch (Exception exception) {
                ApigeeEdgeValidatorRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
                return null;
            }
        }

        public String getResponseString() {
            String string = "getResponseString";
            string = ApigeeEdgeValidatorRESTExecutor.this.methodNameTemplate(string);
            this.responseString = ApigeeEdgeValidatorRESTExecutor.this.replaceAll(this.responseString, System.lineSeparator(), "");
            ApigeeEdgeValidatorRESTExecutor.this.printOut(string + "After decode for the method  " + string + "  ====> Response  : " + this.responseString);
            return this.responseString;
        }
    }

    abstract class MonitoredThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;

        MonitoredThread() {
        }

        public abstract void run();
    }
}

