/*
 * Decompiled with CFR 0.152.
 */
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobList;
import com.ibm.as400.access.QSYSObjectPathName;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class AS400JobContTest
extends GenericTest {
    private String userID = null;
    private String password = null;
    private String system = null;
    public Hashtable ddHash = null;
    private String sort_value = "";
    private boolean sort_order = false;
    private int job_limit = 0;
    private static final String[] jobTypes = new String[]{"A", "B", "I", "M", "R", "S", "W", "X", "Warning", "Clear", "Critical"};

    public AS400JobContTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.system = this.getValueForParam("ServerName");
        this.userID = this.getValueForParam("UserID");
        this.password = this.getValueForParam("Password");
        String string = this.getValueForParam("Sort_value");
        this.sort_value = string != null && string.length() > 0 && !string.equalsIgnoreCase("none") ? string : "none";
        String string2 = this.getValueForParam("Sort_order");
        this.sort_order = string2 != null && string2.length() > 0 && string2.equalsIgnoreCase("ASC");
        String string3 = this.getValueForParam("Job_limit");
        this.job_limit = string3 != null && string3.length() > 0 && !string3.equalsIgnoreCase("none") ? Integer.parseInt(string3) : 100;
        this.setMeasureCount(this.measureCount);
    }

    public void freeTest() {
        this.ddHash = new Hashtable();
    }

    public static void main(String[] stringArray) {
        AS400JobContTest aS400JobContTest = new AS400JobContTest(stringArray);
        aS400JobContTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        block24: {
            AS400 aS400 = null;
            this.ddHash = new Hashtable();
            try {
                double d;
                double d2;
                aS400 = AS400Helper.getAS400Instance(this.system, this.userID, this.password, this);
                if (aS400 == null) {
                    return;
                }
                JobList jobList = new JobList(aS400);
                jobList.addJobSelectionCriteria(5, (Object)Boolean.TRUE);
                jobList.addJobSelectionCriteria(6, (Object)Boolean.FALSE);
                jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
                Enumeration enumeration = jobList.getJobs();
                while (enumeration.hasMoreElements()) {
                    String string = "";
                    String string2 = "";
                    double d3 = 0.0;
                    String string3 = "";
                    String string4 = "";
                    double d4 = 0.0;
                    String string5 = "";
                    d2 = 0.0;
                    d = 0.0;
                    try {
                        ArrayList<String> arrayList;
                        Job job = (Job)enumeration.nextElement();
                        try {
                            string = job.getName();
                            string2 = job.getStatus();
                            string3 = job.getJobDescription();
                            string4 = job.getUser();
                            string5 = job.getType();
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        string5 = string5.trim();
                        if (debug) {
                            System.out.println("[AS400JobContTest]Jobname=" + string + " Status=" + string2 + " jobtype =" + string5 + " strUser =" + string4);
                        }
                        String string6 = string + "~!~" + string2 + "~!~" + string5;
                        if (this.ddHash != null && this.ddHash.containsKey(string5)) {
                            arrayList = (ArrayList<String>)this.ddHash.get(string5);
                            if (arrayList == null || arrayList.size() == 0) {
                                arrayList = new ArrayList<String>();
                            }
                            arrayList.add(string6);
                            this.ddHash.put(string5, arrayList);
                            continue;
                        }
                        arrayList = new ArrayList<String>();
                        arrayList.add(string6);
                        this.ddHash.put(string5, arrayList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.getJobStatus(aS400);
                if (debug) {
                    System.out.println("[AS400JobContTest]ddHash=" + this.ddHash);
                    System.out.println("ADDED3 Size of hash = " + this.ddHash.size());
                }
                int n = jobTypes.length;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                d2 = 0.0;
                d = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                for (int i = 0; i < n; ++i) {
                    ArrayList arrayList;
                    String string = jobTypes[i];
                    if (string == null || string.length() == 0 || this.ddHash == null || !this.ddHash.containsKey(string) || (arrayList = (ArrayList)this.ddHash.get(string)) == null || arrayList.size() == 0) continue;
                    int n2 = arrayList.size();
                    if (string.equalsIgnoreCase("A")) {
                        d5 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("B")) {
                        d6 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("I")) {
                        d7 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("M")) {
                        d8 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("R")) {
                        d2 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("S")) {
                        d = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("W")) {
                        d9 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("X")) {
                        d10 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("Warning")) {
                        d11 = n2;
                        continue;
                    }
                    if (string.equalsIgnoreCase("Clear")) {
                        d12 = n2;
                        continue;
                    }
                    if (!string.equalsIgnoreCase("Critical")) continue;
                    d13 = n2;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d8));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d));
                arrayList.add(new Double(d9));
                arrayList.add(new Double(d10));
                arrayList.add(new Double(d11));
                arrayList.add(new Double(d12));
                arrayList.add(new Double(d13));
                if (debug) {
                    System.out.println("[AS400JobContTest]measureList=" + arrayList);
                }
                this.addNewMeasure(arrayList);
                aS400.disconnectAllServices();
                aS400 = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (aS400 == null) break block24;
                aS400.disconnectAllServices();
                aS400 = null;
            }
        }
    }

    public void getJobStatus(AS400 aS400) {
        try {
            int n;
            int n2;
            JobList jobList = new JobList(aS400);
            jobList.clearJobSelectionCriteria();
            jobList.clearJobAttributesToRetrieve();
            jobList.clearJobAttributesToSortOn();
            jobList.addJobSelectionCriteria(5, (Object)Boolean.TRUE);
            jobList.addJobSelectionCriteria(6, (Object)Boolean.FALSE);
            jobList.addJobSelectionCriteria(7, (Object)Boolean.FALSE);
            int[] nArray = new int[]{1906, 304, 401, 1004, 101, 2008, 1802, 1907, 601, 1307};
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                jobList.addJobAttributeToRetrieve(n);
            }
            jobList.addJobAttributeToSortOn(1307, Boolean.FALSE.booleanValue());
            if (this.sort_value != null && this.sort_value.trim().length() > 0 && !this.sort_value.equalsIgnoreCase("none")) {
                n2 = this.getSortValue(aS400, this.sort_value);
                jobList.addJobAttributeToSortOn(n2, this.sort_order);
            }
            Job[] jobArray = jobList.getJobs(0, this.job_limit);
            n = 0;
            boolean bl = false;
            boolean bl2 = false;
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            int n3 = 0;
            long l = 0L;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < jobArray.length; ++i) {
                ArrayList<String> arrayList;
                Job job = jobArray[i];
                if (debug) {
                    System.out.println("Job name ->" + job.getName() + "   and user ->" + job.getUser());
                }
                if (job == null) continue;
                string5 = job.getStatus();
                string10 = "";
                if (!string5.equals("*ACTIVE")) continue;
                string = job.getName();
                string2 = job.getUser();
                string3 = job.getNumber();
                string4 = job.getType();
                string4 = this.getJobType(string4);
                n5 = job.getPoolIdentifier();
                string5 = (String)job.getValue(101);
                string6 = job.getFunctionName();
                n4 = job.getRunPriority();
                Integer n7 = (Integer)job.getValue(2008);
                n3 = n7;
                string7 = job.getQueue();
                string7 = this.getAbsoluteName(string7);
                string8 = job.getSubsystem();
                string8 = this.getAbsoluteName(string8);
                n6 = job.getCPUUsed();
                Date date = job.getJobActiveDate();
                l = this.getUptimeValue(date);
                String string11 = string + "~!~" + string2 + "~!~" + string3 + "~!~" + string4 + "~!~" + string5 + "~!~" + n5 + "~!~" + string6 + "~!~" + n4 + "~!~" + n3 + "~!~" + string7 + "~!~" + string8 + "~!~" + n6 + "~!~" + l;
                string5 = (String)job.getValue(101);
                if ((string5 = string5.trim()).equals("") || string5.length() < 1) {
                    string5 = "NONE";
                }
                if (string5.equalsIgnoreCase("DSC") || string5.equalsIgnoreCase("DSPA") || string5.equalsIgnoreCase("DSPW") || string5.equalsIgnoreCase("HLD") || string5.equalsIgnoreCase("HLFT") || string5.equalsIgnoreCase("SIGW") || string5.equalsIgnoreCase("NONE")) {
                    string10 = "Warning";
                } else if (string5.equalsIgnoreCase("BSCA") || string5.equalsIgnoreCase("CMNA") || string5.equalsIgnoreCase("CMNW") || string5.equalsIgnoreCase("CMTW") || string5.equalsIgnoreCase("CNDW") || string5.equalsIgnoreCase("CPCW") || string5.equalsIgnoreCase("DEQA") || string5.equalsIgnoreCase("DEQW") || string5.equalsIgnoreCase("DKTA") || string5.equalsIgnoreCase("DKTW") || string5.equalsIgnoreCase("DLYW") || string5.equalsIgnoreCase("EOFA") || string5.equalsIgnoreCase("EOFW") || string5.equalsIgnoreCase("EOJ") || string5.equalsIgnoreCase("EVTW") || string5.equalsIgnoreCase("GRP") || string5.equalsIgnoreCase("ICFA") || string5.equalsIgnoreCase("ICFW") || string5.equalsIgnoreCase("INEL") || string5.equalsIgnoreCase("JVAA") || string5.equalsIgnoreCase("JVAW") || string5.equalsIgnoreCase("LSPA") || string5.equalsIgnoreCase("LSPW") || string5.equalsIgnoreCase("MLTA") || string5.equalsIgnoreCase("MLTW") || string5.equalsIgnoreCase("MTXW") || string5.equalsIgnoreCase("MXDW") || string5.equalsIgnoreCase("OPTA") || string5.equalsIgnoreCase("OPTW") || string5.equalsIgnoreCase("OSIW") || string5.equalsIgnoreCase("PRTA") || string5.equalsIgnoreCase("PRTW") || string5.equalsIgnoreCase("PSRW") || string5.equalsIgnoreCase("RUN") || string5.equalsIgnoreCase("SELW") || string5.equalsIgnoreCase("SEMW") || string5.equalsIgnoreCase("SIGS") || string5.equalsIgnoreCase("SRQ") || string5.equalsIgnoreCase("SVFA") || string5.equalsIgnoreCase("SVFW") || string5.equalsIgnoreCase("TAPA") || string5.equalsIgnoreCase("TAPW") || string5.equalsIgnoreCase("THDW") || string5.equalsIgnoreCase("TIMA") || string5.equalsIgnoreCase("TIMW")) {
                    string10 = "Clear";
                } else if (string5.equalsIgnoreCase("END") || string5.equalsIgnoreCase("LCKW") || string5.equalsIgnoreCase("MSGW")) {
                    string10 = "Critical";
                }
                if (this.ddHash != null && this.ddHash.containsKey(string10)) {
                    arrayList = (ArrayList<String>)this.ddHash.get(string10);
                    if (arrayList == null || arrayList.size() == 0) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string11);
                    this.ddHash.put(string10, arrayList);
                    continue;
                }
                arrayList = new ArrayList<String>();
                arrayList.add(string11);
                this.ddHash.put(string10, arrayList);
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string);
        }
    }

    public long getUptimeValue(Date date) {
        long l = 0L;
        Calendar calendar = null;
        try {
            calendar = Calendar.getInstance();
            calendar.setTime(date);
            Date date2 = calendar.getTime();
            long l2 = date2.getTime();
            long l3 = System.currentTimeMillis();
            l = (l3 - l2) / 60000L;
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string);
        }
        return l;
    }

    public int getSortValue(AS400 aS400, String string) {
        Job job = null;
        int n = 0;
        try {
            job = new Job(aS400);
            if (string.equalsIgnoreCase("CPU_TIME_USED")) {
                n = 304;
            } else if (string.equalsIgnoreCase("JOB_NUMBER")) {
                n = 11002;
            } else if (string.equalsIgnoreCase("JOB_NAME")) {
                n = 11001;
            } else if (string.equalsIgnoreCase("USER_NAME")) {
                n = 11006;
            } else if (string.equalsIgnoreCase("JOB_TYPE")) {
                n = 11005;
            }
        }
        catch (Exception exception) {
            String string2 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string2);
        }
        return n;
    }

    public String getAbsoluteName(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = "";
        try {
            if (string.indexOf(".JOBQ") > -1) {
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
                string2 = qSYSObjectPathName.getObjectName();
            } else if (string.indexOf(".SBSD") > -1) {
                QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
                string2 = qSYSObjectPathName.getObjectName() + "-" + qSYSObjectPathName.getLibraryName();
            }
        }
        catch (Exception exception) {
            String string3 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string3);
        }
        if (debug) {
            System.out.println("[AS400JobContTest] absoluteData-->" + string2);
        }
        return string2;
    }

    public String getJobType(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = "";
        try {
            if (string.equalsIgnoreCase("A")) {
                string2 = "Autostart";
            } else if (string.equalsIgnoreCase("B")) {
                string2 = "Batch";
            } else if (string.equalsIgnoreCase("I")) {
                string2 = "Interactive";
            } else if (string.equalsIgnoreCase("M")) {
                string2 = "Subsystem";
            } else if (string.equalsIgnoreCase("R")) {
                string2 = "Spooled Reader";
            } else if (string.equalsIgnoreCase("S")) {
                string2 = "System job";
            } else if (string.equalsIgnoreCase("W")) {
                string2 = "Spooled Writer";
            } else if (string.equalsIgnoreCase("X")) {
                string2 = "SCPF";
            }
        }
        catch (Exception exception) {
            String string3 = EgInstallInfo.getStackTraceAsString(exception);
            this.logToErrorFile(this.entity, "Error", string3);
        }
        return string2;
    }
}

