/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.ibm.jtopenlite.command.CommandConnection;
import com.ibm.jtopenlite.components.DiskStatus;
import com.ibm.jtopenlite.components.ListDiskStatuses;
import com.ibm.jtopenlite.ddm.DDMConnection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;

public class AS400DskStatTest
extends GenericTest {
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String TEST_NAME = "AS400DskStatTest";
    protected static final String LOG_FILE_NAME = "AS400DskStatTestLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "AS400DskStatTestLogSizeLimitInMB";
    protected static final String DEBUG_LOG_ABSOLUTE_PATH = EgInstallInfo.getInstallDir() + "/agent/logs/" + "AS400DskStatTestLog";
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 5.0;
    protected double debugLogSizeLimitInMB;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String BYTES = "BYTES";
    protected static final String DEBUG_COMPUTE_MEASURE_METHOD_NAME = "[debugComputeMeasures] :";
    protected static final String OUTPUT_NULL_OR_EMPTY_INFO_MESSAGE = "command output null or size is zero or empty for ";
    protected static final String RETURNING_INFO_MESSAGE = ",So returning";
    private static final String JSON_OBJECT_PARSING_EXCEPTION_MESSAGE = "JSONException while parsing JSONObjects :";
    private static String logMessage = "";
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    private static final String def_IdleTimeout = "120";
    protected long collectionTimeout;
    protected String serverName;
    protected String userName;
    protected String userPwd;

    public static void main(String[] stringArray) {
        AS400DskStatTest aS400DskStatTest = new AS400DskStatTest(stringArray);
        try {
            aS400DskStatTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            aS400DskStatTest.printOutStackTrace("[main()] Occure error while collect data in Executor class :", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AS400DskStatTest(String[] stringArray) {
        block23: {
            super(stringArray);
            this.debugLogSizeLimitInMB = 5242880.0;
            this.collectionTimeout = 120L;
            this.serverName = "";
            this.userName = "";
            this.userPwd = "";
            String string = this.methodNameTemplate(TEST_NAME);
            this.printOut(string + "Constructor method called. Start get arguments");
            try {
                String string2;
                this.serverName = this.getValueForParam("servername");
                if (this.serverName == null || this.serverName.trim().length() == 0 || this.serverName.equalsIgnoreCase("NULL") || this.serverName.equalsIgnoreCase("NONE")) {
                    logMessage = string + "serverName is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    logMessage = string + "serverName : " + this.serverName;
                    this.printOut(logMessage);
                }
                this.userName = this.getValueForParam("username");
                if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("NONE")) {
                    logMessage = string + "userName is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    logMessage = string + "userName : " + this.userName;
                    this.printOut(logMessage);
                }
                this.userPwd = this.getValueForParam("password");
                if (this.userPwd == null || this.userPwd.trim().length() == 0 || this.userPwd.equalsIgnoreCase("NULL") || this.userPwd.equalsIgnoreCase("NONE")) {
                    logMessage = string + "userPwd is null or empty.  ";
                    this.printOut(logMessage);
                } else {
                    this.userPwd = EgCrypt.decrypt(this.userPwd);
                    logMessage = string + "userPwd : ***********";
                    this.printOut(logMessage);
                }
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                String string3 = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
                if (string3 != null && string3.length() > 0) {
                    string3 = string3.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(string3);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                        this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                    }
                    catch (Exception exception) {
                        this.printOutStackTrace(string + "Conversion error for strLogSizeLimitInMB value to bytes", exception);
                        this.debugLogSizeLimitInMB = 5242880.0;
                    }
                } else {
                    this.debugLogSizeLimitInMB = 5242880.0;
                }
                if ((string2 = this.getValueForParam("timeout_seconds")) != null && string2.trim().length() > 0) {
                    logMessage = string + "Timeout string value in constructor : " + string2;
                    this.printOut(logMessage);
                    logMessage = "";
                    try {
                        this.collectionTimeout = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            this.collectionTimeout = Long.parseLong(def_IdleTimeout);
                        }
                        catch (NumberFormatException numberFormatException2) {}
                    }
                } else {
                    logMessage = string + "Timeout value not provided by parameter ,so assigning default value : " + this.collectionTimeout;
                    this.printOut(logMessage);
                    logMessage = "";
                }
                if (fieldSep.length() != 0) break block23;
                String string4 = sync0;
                synchronized (string4) {
                    if (fieldSep.length() == 0) {
                        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                        fieldSep = egTesterInfo.getDDSeparator1();
                    }
                }
            }
            catch (Exception exception) {
                this.printOutStackTrace(string + "Occurred Exception while get arguments ", exception);
            }
        }
        this.setMeasureCount(10);
        this.setConfigInfoTestFlag(true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = this.methodNameTemplate("debugComputeMeasures");
        try {
            Hashtable hashtable2 = this.collectDataFromIBM();
            Set set = hashtable2.keySet();
            for (String string2 : set) {
                ArrayList arrayList = (ArrayList)hashtable2.get(string2);
                this.printOut(string + " descriptor : " + string2 + " , measureArr : " + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while getting measures from IBM { collectDataFromIBM() } ", exception);
        }
    }

    protected CommandConnection getCmdConnection() {
        String string = this.methodNameTemplate("getCmdConnection");
        CommandConnection commandConnection = null;
        try {
            commandConnection = CommandConnection.getConnection((String)this.serverName, (String)this.userName, (String)this.userPwd);
            this.printOut(string + " command connection successful.");
            return commandConnection;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get Connection for command execute ", exception);
            return null;
        }
    }

    protected DDMConnection getDDMConnection() {
        String string = this.methodNameTemplate("getDDMConnection");
        DDMConnection dDMConnection = null;
        try {
            dDMConnection = DDMConnection.getConnection((String)this.serverName, (String)this.userName, (String)this.userPwd);
            this.printOut(string + " DDM connection successful.");
            return dDMConnection;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get DDM(Distributed Data Management) Connection ", exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable collectDataFromIBM() {
        String string = this.methodNameTemplate("collectDataFromIBM");
        CommandConnection commandConnection = this.getCmdConnection();
        DDMConnection dDMConnection = this.getDDMConnection();
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = this.getWRKDSKSTSdata(commandConnection, dDMConnection);
            dDMConnection.close();
            commandConnection.close();
            dDMConnection = null;
            commandConnection = null;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while collect Data From IBM ", exception);
        }
        finally {
            try {
                if (dDMConnection != null) {
                    dDMConnection.close();
                    dDMConnection = null;
                    this.printOut(string + " [ collectDataFromIBM() ] : finally { ddmConnection() } closed.");
                }
                if (commandConnection != null) {
                    commandConnection.close();
                    commandConnection = null;
                    this.printOut(string + " collectDataFromIBM() ] : finally { commandConnection() } closed.");
                }
            }
            catch (IOException iOException) {
                this.printOutStackTrace(string + "Occurred Exception while close ddmConnection and commandConnection ", iOException);
            }
        }
        return hashtable;
    }

    protected Hashtable getWRKDSKSTSdata(CommandConnection commandConnection, DDMConnection dDMConnection) {
        String string = this.methodNameTemplate("getWRKDSKSTSdata");
        Hashtable hashtable = new Hashtable();
        String string2 = "QBSECOFR";
        try {
            ListDiskStatuses listDiskStatuses = new ListDiskStatuses();
            DiskStatus[] diskStatusArray = listDiskStatuses.getDiskStatuses(commandConnection, dDMConnection, string2, false);
            if (diskStatusArray.length <= 0) {
                this.printOut(string + " DiskStatus[] data is null..... please check parameters like userName, userPwd, serverName.");
                this.printOut(string + " Data parsing for loop will pass.");
            }
            for (int i = 0; i < diskStatusArray.length; ++i) {
                DiskStatus diskStatus = diskStatusArray[i];
                this.printOut(string + " DiskStatus [ " + i + " ] : " + diskStatus.toString());
                if (diskStatus.toString().contains("Work  with  Disk Status") || diskStatus.toString().contains("KST") || diskStatus.toString().contains("--Protection--") || diskStatus.toString().contains("(K) (K)  Busy   ASP")) continue;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                String string3 = diskStatus.getUnit().trim();
                String[] stringArray = new String[]{diskStatus.getType().trim(), diskStatus.getSize().trim(), diskStatus.getPercentUsed().trim(), diskStatus.getIORequests().trim(), diskStatus.getRequestSize().trim(), diskStatus.getReadRequests().trim(), diskStatus.getWriteRequests().trim(), diskStatus.getReadKB().trim(), diskStatus.getWriteKB().trim(), diskStatus.getPercentBusy().trim()};
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!stringArray[j].equalsIgnoreCase("") || stringArray[j] != "" || stringArray[j] != null) {
                        if (stringArray[j].equalsIgnoreCase(".0")) {
                            stringArray[j] = stringArray[j].replace(".", "");
                        }
                        double d = this.convertStrToDouble(stringArray[j]);
                        arrayList.add(new Double(d));
                        continue;
                    }
                    arrayList.add(new Double(0.0));
                }
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Occurred Exception while get DDM(Distributed Data Management) Connection ", exception);
            return null;
        }
        this.printOut(string + " ============== [Common metric data] ==============");
        this.printOut(string + " [Common Metric] measureData HT : " + hashtable);
        return hashtable;
    }

    protected double convertStrToDouble(String string) {
        String string2 = this.methodNameTemplate("convertStrToDouble");
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            logMessage = string2 + " Occurred error while parsing String to Double using Double.parseDouble(). set 0.0 as default";
            this.printOutStackTrace(logMessage, exception);
            logMessage = "";
            d = 0.0;
        }
        return d;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400DskStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400DskStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400DskStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            AS400DskStatTest.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_ABSOLUTE_PATH;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            AS400DskStatTest.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase("NULL") || string.equalsIgnoreCase("NONE");
    }
}

