/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net.ssl;

import com.eg.ch.qos.logback.core.net.ssl.SSLConfigurableServerSocket;
import com.eg.ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class ConfigurableSSLServerSocketFactory
extends ServerSocketFactory {
    private final SSLParametersConfiguration parameters;
    private final SSLServerSocketFactory delegate;

    public ConfigurableSSLServerSocketFactory(SSLParametersConfiguration sSLParametersConfiguration, SSLServerSocketFactory sSLServerSocketFactory) {
        this.parameters = sSLParametersConfiguration;
        this.delegate = sSLServerSocketFactory;
    }

    public ServerSocket createServerSocket(int n2, int n3, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.delegate.createServerSocket(n2, n3, inetAddress);
        this.parameters.configure(new SSLConfigurableServerSocket(sSLServerSocket));
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n2, int n3) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.delegate.createServerSocket(n2, n3);
        this.parameters.configure(new SSLConfigurableServerSocket(sSLServerSocket));
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n2) throws IOException {
        SSLServerSocket sSLServerSocket = (SSLServerSocket)this.delegate.createServerSocket(n2);
        this.parameters.configure(new SSLConfigurableServerSocket(sSLServerSocket));
        return sSLServerSocket;
    }
}

