/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3;

import com.eg.org.apache.commons.lang3.RandomUtils;
import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int n2) {
        return RandomStringUtils.random(n2, false, false);
    }

    public static String randomAscii(int n2) {
        return RandomStringUtils.random(n2, 32, 127, false, false);
    }

    public static String randomAscii(int n2, int n3) {
        return RandomStringUtils.randomAscii(RandomUtils.nextInt(n2, n3));
    }

    public static String randomAlphabetic(int n2) {
        return RandomStringUtils.random(n2, true, false);
    }

    public static String randomAlphabetic(int n2, int n3) {
        return RandomStringUtils.randomAlphabetic(RandomUtils.nextInt(n2, n3));
    }

    public static String randomAlphanumeric(int n2) {
        return RandomStringUtils.random(n2, true, true);
    }

    public static String randomAlphanumeric(int n2, int n3) {
        return RandomStringUtils.randomAlphanumeric(RandomUtils.nextInt(n2, n3));
    }

    public static String randomGraph(int n2) {
        return RandomStringUtils.random(n2, 33, 126, false, false);
    }

    public static String randomGraph(int n2, int n3) {
        return RandomStringUtils.randomGraph(RandomUtils.nextInt(n2, n3));
    }

    public static String randomNumeric(int n2) {
        return RandomStringUtils.random(n2, false, true);
    }

    public static String randomNumeric(int n2, int n3) {
        return RandomStringUtils.randomNumeric(RandomUtils.nextInt(n2, n3));
    }

    public static String randomPrint(int n2) {
        return RandomStringUtils.random(n2, 32, 126, false, false);
    }

    public static String randomPrint(int n2, int n3) {
        return RandomStringUtils.randomPrint(RandomUtils.nextInt(n2, n3));
    }

    public static String random(int n2, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, 0, 0, bl2, bl3);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, null, RANDOM);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char ... cArray) {
        return RandomStringUtils.random(n2, n3, n4, bl2, bl3, cArray, RANDOM);
    }

    public static String random(int n2, int n3, int n4, boolean bl2, boolean bl3, char[] cArray, Random random) {
        if (n2 == 0) {
            return "";
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + n2 + " is less than 0.");
        }
        if (cArray != null && cArray.length == 0) {
            throw new IllegalArgumentException("The chars array must not be empty");
        }
        if (n3 == 0 && n4 == 0) {
            if (cArray != null) {
                n4 = cArray.length;
            } else if (!bl2 && !bl3) {
                n4 = 0x10FFFF;
            } else {
                n4 = 123;
                n3 = 32;
            }
        } else if (n4 <= n3) {
            throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater than start (" + n3 + ")");
        }
        if (cArray == null && (bl3 && n4 <= 48 || bl2 && n4 <= 65)) {
            throw new IllegalArgumentException("Parameter end (" + n4 + ") must be greater then (" + 48 + ") for generating digits " + "or greater then (" + 65 + ") for generating letters.");
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        int n5 = n4 - n3;
        block3: while (n2-- != 0) {
            int n6;
            if (cArray == null) {
                n6 = random.nextInt(n5) + n3;
                switch (Character.getType(n6)) {
                    case 0: 
                    case 18: 
                    case 19: {
                        ++n2;
                        continue block3;
                    }
                }
            } else {
                n6 = cArray[random.nextInt(n5) + n3];
            }
            int n7 = Character.charCount(n6);
            if (n2 == 0 && n7 > 1) {
                ++n2;
                continue;
            }
            if (bl2 && Character.isLetter(n6) || bl3 && Character.isDigit(n6) || !bl2 && !bl3) {
                stringBuilder.appendCodePoint(n6);
                if (n7 != 2) continue;
                --n2;
                continue;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String random(int n2, String string) {
        if (string == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, string.toCharArray());
    }

    public static String random(int n2, char ... cArray) {
        if (cArray == null) {
            return RandomStringUtils.random(n2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(n2, 0, cArray.length, false, false, cArray, RANDOM);
    }
}

