/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.file;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.SignonConnection;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.file.FileHandle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConnection
extends HostServerConnection {
    public static final int DEFAULT_FILE_SERVER_PORT = 8473;
    public static final int DEFAULT_SSL_FILE_SERVER_PORT = 9473;
    private int ccsid_;
    private int datastreamLevel_;
    private int maxDataBlockSize_;
    private int correlationID_ = 1;

    private int newCorrelationID() {
        if (this.correlationID_ == Integer.MAX_VALUE) {
            this.correlationID_ = 0;
        }
        return ++this.correlationID_;
    }

    private FileConnection(SystemInfo systemInfo, Socket socket, HostServerConnection.HostInputStream hostInputStream, HostServerConnection.HostOutputStream hostOutputStream, int n, int n2, int n3, String string, String string2) {
        super(systemInfo, string, string2, socket, hostInputStream, hostOutputStream);
        this.ccsid_ = n;
        this.datastreamLevel_ = n2;
        this.maxDataBlockSize_ = n3;
    }

    @Override
    protected void sendEndJobRequest() throws IOException {
    }

    public static FileConnection getConnection(String string, String string2, String string3) throws IOException {
        return FileConnection.getConnection(false, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileConnection getConnection(boolean bl, String string, String string2, String string3) throws IOException {
        SignonConnection signonConnection = SignonConnection.getConnection(bl, string, string2, string3);
        try {
            FileConnection fileConnection = FileConnection.getConnection(bl, signonConnection.getInfo(), string2, string3);
            return fileConnection;
        }
        finally {
            signonConnection.close();
        }
    }

    public static FileConnection getConnection(SystemInfo systemInfo, String string, String string2) throws IOException {
        return FileConnection.getConnection(false, systemInfo, string, string2);
    }

    public static FileConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2) throws IOException {
        return FileConnection.getConnection(bl, systemInfo, string, string2, bl ? 9473 : 8473);
    }

    public static FileConnection getConnection(SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        return FileConnection.getConnection(false, systemInfo, string, string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2, int n) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException("Bad file port: " + n);
        }
        FileConnection fileConnection = null;
        Socket socket = bl ? SSLSocketFactory.getDefault().createSocket(systemInfo.getSystem(), n) : new Socket(systemInfo.getSystem(), n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            HostServerConnection.HostOutputStream hostOutputStream = new HostServerConnection.HostOutputStream(new BufferedOutputStream(outputStream));
            HostServerConnection.HostInputStream hostInputStream = new HostServerConnection.HostInputStream(new BufferedInputStream(inputStream));
            String string3 = FileConnection.connect(systemInfo, hostOutputStream, hostInputStream, 57346, string, string2);
            FileConnection.sendExchangeAttributesRequest(hostOutputStream);
            hostOutputStream.flush();
            int n2 = hostInputStream.readInt();
            if (n2 < 22) {
                throw DataStreamException.badLength("fileExchangeAttributes", n2);
            }
            hostInputStream.skipBytes(16);
            int n3 = hostInputStream.readShort();
            if (n3 != 0) {
                throw DataStreamException.badReturnCode("fileExchangeAttributes", n3);
            }
            int n4 = hostInputStream.readShort();
            hostInputStream.skipBytes(2);
            int n5 = hostInputStream.readInt();
            hostInputStream.skipBytes(6);
            int n6 = hostInputStream.readShort();
            int n7 = n2 - 38;
            hostInputStream.skipBytes(n7);
            FileConnection fileConnection2 = fileConnection = new FileConnection(systemInfo, socket, hostInputStream, hostOutputStream, n6, n4, n5, string, string3);
            return fileConnection2;
        }
        finally {
            if (fileConnection == null) {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
        }
    }

    public List<FileHandle> listFiles(String string) throws IOException {
        String string2;
        int n;
        if (string.indexOf("*") < 0) {
            string = !string.endsWith("/") ? string + "/*" : string + "*";
        }
        if ((n = (string2 = string).lastIndexOf("/")) < 0) {
            string2 = "";
        } else if (n > 0) {
            string2 = string2.substring(0, n + 1);
        }
        this.sendListFilesRequest(Conv.stringToUnicodeByteArray(string));
        this.out_.flush();
        ArrayList<FileHandle> arrayList = new ArrayList<FileHandle>();
        int n2 = 1;
        while (n2 != 0) {
            int n3;
            int n4 = this.in_.readInt();
            if (n4 < 24) {
                throw DataStreamException.badLength("listFiles", n4);
            }
            int n5 = this.in_.readShort();
            int n6 = this.in_.readShort();
            int n7 = this.in_.readInt();
            int n8 = this.in_.readInt();
            int n9 = this.in_.readShort();
            int n10 = this.in_.readShort();
            n2 = this.in_.readShort();
            if (n10 == 32769) {
                n3 = this.in_.readShort();
                int n11 = n4 - 24;
                this.in_.skipBytes(n11);
                if (n3 == 18) continue;
                throw DataStreamException.badReturnCode("listFiles", n3);
            }
            if (n10 == 32773) {
                n3 = 22;
                long l = FileConnection.convertDate(this.in_);
                long l2 = FileConnection.convertDate(this.in_);
                long l3 = FileConnection.convertDate(this.in_);
                int n12 = this.in_.readInt();
                int n13 = this.in_.readInt();
                int n14 = this.in_.readShort();
                int n15 = this.in_.readShort();
                int n16 = this.in_.readInt();
                int n17 = this.in_.readInt();
                int n18 = this.in_.readInt();
                int n19 = this.in_.readShort();
                int n20 = this.in_.readByte();
                int n21 = this.in_.readShort();
                int n22 = this.in_.readShort();
                int n23 = this.in_.readInt();
                long l4 = this.in_.readLong();
                this.in_.skipBytes(2);
                int n24 = this.in_.readByte();
                n3 = 92;
                int n25 = 20 + n9;
                int n26 = n25 - n3;
                this.in_.skipBytes(n26);
                n3 += n26;
                int n27 = this.in_.readInt() - 6;
                this.in_.skipBytes(2);
                n3 += 6;
                byte[] byArray = new byte[n27];
                this.in_.readFully(byArray);
                n3 += n27;
                String string3 = Conv.unicodeByteArrayToString(byArray, 0, byArray.length);
                if (!string3.equals(".") && !string3.equals("..")) {
                    FileHandle fileHandle = FileHandle.createEmptyHandle();
                    fileHandle.setName(string3);
                    fileHandle.setPath(string2 + string3);
                    fileHandle.setDataCCSID(n21);
                    fileHandle.setCreateDate(l);
                    fileHandle.setModifyDate(l2);
                    fileHandle.setAccessDate(l3);
                    fileHandle.setSize(l4);
                    fileHandle.setVersion(n18);
                    fileHandle.setSymlink(n24 == 1);
                    fileHandle.setDirectory(n14 == 2);
                    arrayList.add(fileHandle);
                }
                int n28 = n4 - n3;
                this.in_.skipBytes(n28);
                continue;
            }
            n3 = n4 - 22;
            this.in_.skipBytes(n3);
            throw DataStreamException.badReply("listFiles", n10);
        }
        return arrayList;
    }

    public List<String> list(String string) throws IOException {
        if (string.indexOf("*") < 0) {
            string = !string.endsWith("/") ? string + "/*" : string + "*";
        }
        this.sendListFilesRequest(Conv.stringToUnicodeByteArray(string));
        this.out_.flush();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while (n != 0) {
            int n2;
            int n3;
            int n4 = this.in_.readInt();
            if (n4 < 24) {
                throw DataStreamException.badLength("listFiles", n4);
            }
            int n5 = this.in_.readShort();
            int n6 = this.in_.readShort();
            int n7 = this.in_.readInt();
            int n8 = this.in_.readInt();
            int n9 = this.in_.readShort();
            int n10 = this.in_.readShort();
            n = this.in_.readShort();
            if (n10 == 32769) {
                n3 = this.in_.readShort();
                n2 = n4 - 24;
                this.in_.skipBytes(n2);
                if (n3 == 18) continue;
                throw DataStreamException.badReturnCode("listFiles", n3);
            }
            if (n10 == 32773) {
                n3 = 22;
                this.in_.skipBytes(70);
                n3 = 92;
                n2 = 20 + n9;
                int n11 = n2 - n3;
                this.in_.skipBytes(n11);
                n3 += n11;
                int n12 = this.in_.readInt() - 6;
                this.in_.skipBytes(2);
                n3 += 6;
                byte[] byArray = new byte[n12];
                this.in_.readFully(byArray);
                n3 += n12;
                String string2 = Conv.unicodeByteArrayToString(byArray, 0, byArray.length);
                if (!string2.equals(".") && !string2.equals("..")) {
                    arrayList.add(string2);
                }
                int n13 = n4 - n3;
                this.in_.skipBytes(n13);
                continue;
            }
            n3 = n4 - 22;
            this.in_.skipBytes(n3);
            throw DataStreamException.badReply("listFiles", n10);
        }
        return arrayList;
    }

    private void sendListFilesRequest(byte[] byArray) throws IOException {
        this.out_.writeInt(46 + byArray.length);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(20);
        this.out_.writeShort(10);
        this.out_.writeShort(0);
        this.out_.writeInt(0);
        this.out_.writeShort(1200);
        this.out_.writeInt(1);
        this.out_.writeShort(0);
        this.out_.writeShort(65535);
        this.out_.writeShort(257);
        this.out_.writeShort(1);
        this.out_.writeInt(byArray.length + 6);
        this.out_.writeShort(2);
        this.out_.write(byArray);
    }

    public int deleteFile(String string) throws IOException {
        this.sendDeleteFileRequest(this.out_, Conv.stringToUnicodeByteArray(string));
        this.out_.flush();
        int n = this.in_.readInt();
        if (n < 24) {
            throw DataStreamException.badLength("deleteFile", n);
        }
        int n2 = this.in_.readShort();
        int n3 = this.in_.readShort();
        int n4 = this.in_.readInt();
        int n5 = this.in_.readInt();
        int n6 = this.in_.readShort();
        int n7 = this.in_.readShort();
        this.in_.skipBytes(2);
        if (n7 == 32769) {
            int n8 = this.in_.readShort();
            int n9 = n - 24;
            this.in_.skipBytes(n9);
            return n8;
        }
        int n10 = n - 22;
        this.in_.skipBytes(n10);
        throw DataStreamException.badReply("deleteFile", n7);
    }

    public int openFile(String string, FileHandle fileHandle) throws IOException {
        return this.openFile(string, fileHandle, 3, 0, true, 1208);
    }

    public int openFile(String string, FileHandle fileHandle, int n, int n2, boolean bl, int n3) throws IOException {
        if (fileHandle.isOpen()) {
            // empty if block
        }
        this.sendOpenFileRequest(Conv.stringToUnicodeByteArray(string), n, n2, bl, n3);
        this.out_.flush();
        int n4 = this.in_.readInt();
        if (n4 < 24) {
            throw DataStreamException.badLength("openFile", n4);
        }
        int n5 = this.in_.readShort();
        int n6 = this.in_.readShort();
        int n7 = this.in_.readInt();
        int n8 = this.in_.readInt();
        int n9 = this.in_.readShort();
        int n10 = this.in_.readShort();
        this.in_.skipBytes(2);
        int n11 = n4 - 22;
        int n12 = 0;
        if (n10 == 32769) {
            n12 = this.in_.readShort();
            n11 -= 2;
        } else if (n10 == 32770) {
            int n13 = this.in_.readInt();
            long l = this.in_.readLong();
            n3 = this.in_.readShort();
            int n14 = this.in_.readShort();
            long l2 = FileConnection.convertDate(this.in_);
            long l3 = FileConnection.convertDate(this.in_);
            long l4 = FileConnection.convertDate(this.in_);
            int n15 = this.in_.readInt();
            long l5 = n15;
            int n16 = this.in_.readInt();
            int n17 = this.in_.readShort();
            int n18 = this.in_.readShort();
            int n19 = this.in_.readInt();
            int n20 = this.in_.readInt();
            int n21 = this.in_.readInt();
            int n22 = this.in_.readShort();
            int n23 = this.in_.readByte();
            n11 -= 67;
            if (n4 >= 97) {
                long l6 = this.in_.readLong();
                n11 -= 8;
                l5 = l6;
            }
            fileHandle.setOpen(true);
            fileHandle.setOpenType(n);
            fileHandle.setName(string);
            fileHandle.setHandle(n13);
            fileHandle.setID(l);
            fileHandle.setDataCCSID(n3);
            fileHandle.setCreateDate(l2);
            fileHandle.setModifyDate(l3);
            fileHandle.setAccessDate(l4);
            fileHandle.setSize(l5);
            fileHandle.setVersion(n21);
        } else {
            this.in_.skipBytes(n11);
            throw DataStreamException.badReply("openFile", n10);
        }
        this.in_.skipBytes(n11 - 2);
        return n12;
    }

    public int closeFile(FileHandle fileHandle) throws IOException {
        if (!fileHandle.isOpen()) {
            return -1;
        }
        this.sendCloseFileRequest(fileHandle.getHandle());
        this.out_.flush();
        int n = this.in_.readInt();
        if (n < 24) {
            throw DataStreamException.badLength("closeFile", n);
        }
        int n2 = this.in_.readShort();
        int n3 = this.in_.readShort();
        int n4 = this.in_.readInt();
        int n5 = this.in_.readInt();
        int n6 = this.in_.readShort();
        int n7 = this.in_.readShort();
        this.in_.skipBytes(2);
        int n8 = n - 22;
        if (n7 == 32769 || n7 == 32772) {
            int n9 = this.in_.readShort();
            this.in_.skipBytes(n8 - 2);
            return n9;
        }
        this.in_.skipBytes(n8);
        throw DataStreamException.badReply("closeFile", n7);
    }

    public int readFile(FileHandle fileHandle, byte[] byArray, int n, int n2) throws IOException {
        long l = fileHandle.getOffset();
        this.sendReadRequest(fileHandle.getHandle(), l, n2);
        this.out_.flush();
        int n3 = this.in_.readInt();
        if (n3 < 24) {
            throw DataStreamException.badLength("readFile", n3);
        }
        int n4 = this.in_.readShort();
        int n5 = this.in_.readShort();
        int n6 = this.in_.readInt();
        int n7 = this.in_.readInt();
        int n8 = this.in_.readShort();
        int n9 = this.in_.readShort();
        int n10 = this.in_.readShort();
        int n11 = 22;
        int n12 = n3 - 22;
        int n13 = 0;
        int n14 = -1;
        if (n9 == 32769) {
            n13 = this.in_.readShort();
            n12 -= 2;
            n11 += 2;
        } else if (n9 == 32771) {
            int n15 = this.in_.readShort();
            int n16 = this.in_.readInt();
            this.in_.skipBytes(2);
            n12 -= 8;
            int n17 = n16 - 6;
            n14 = n17 > n3 ? n3 : n17;
            int n18 = n14 >= n17 ? 0 : n17 - n3;
            this.in_.readFully(byArray, n, n14);
            this.in_.skipBytes(n18);
            fileHandle.setOffset(l + (long)n14);
            n12 -= n17;
            n11 += 6;
            n11 += n14;
            n11 += n18;
        } else {
            this.in_.skipBytes(n12);
            n11 += n12;
            throw DataStreamException.badReply("readFile", n9);
        }
        this.in_.skipBytes(n12 - 2);
        fileHandle.setLastStatus(n13);
        return n14;
    }

    public void writeFile(FileHandle fileHandle, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        long l = fileHandle.getOffset();
        this.sendWriteRequest(fileHandle.getHandle(), l, byArray, n, n2, fileHandle.getDataCCSID(), bl);
        this.out_.flush();
        int n3 = this.in_.readInt();
        if (n3 < 24) {
            throw DataStreamException.badLength("writeFile", n3);
        }
        int n4 = this.in_.readShort();
        int n5 = this.in_.readShort();
        int n6 = this.in_.readInt();
        int n7 = this.in_.readInt();
        int n8 = this.in_.readShort();
        int n9 = this.in_.readShort();
        int n10 = this.in_.readShort();
        int n11 = 22;
        int n12 = 0;
        if (n9 == 32769) {
            n12 = this.in_.readShort();
            n11 += 2;
        } else if (n9 == 32779) {
            n12 = this.in_.readShort();
            int n13 = this.in_.readInt();
            int n14 = this.in_.readInt();
            n11 += 10;
            fileHandle.setOffset(l + (long)(n2 - n14));
            fileHandle.setSize(fileHandle.getSize() + (long)(n2 - n14));
        } else {
            this.in_.skipBytes(n3 - n11);
            n11 = n3;
            throw DataStreamException.badReply("writeFile", n9);
        }
        this.in_.skipBytes(n3 - n11);
        fileHandle.setLastStatus(n12);
    }

    private void sendWriteRequest(int n, long l, byte[] byArray, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.datastreamLevel_ < 16 && l > Integer.MAX_VALUE) {
            throw new IOException("File offset too large: " + l);
        }
        int n5 = this.datastreamLevel_ < 16 ? 18 : 34;
        this.out_.writeInt(26 + n5 + n3);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(n5);
        this.out_.writeShort(4);
        this.out_.writeShort(0);
        this.out_.writeInt(n);
        if (this.datastreamLevel_ < 16) {
            this.out_.writeInt(0);
            this.out_.writeInt((int)l);
        } else {
            this.out_.writeInt(0);
            this.out_.writeInt(0);
        }
        this.out_.writeShort(bl ? 3 : 2);
        this.out_.writeShort(n4);
        if (this.datastreamLevel_ >= 16) {
            this.out_.writeLong(0L);
            this.out_.writeLong(l);
        }
        this.out_.writeInt(n3 + 6);
        this.out_.writeShort(32);
        this.out_.write(byArray, n2, n3);
    }

    private void sendReadRequest(int n, long l, int n2) throws IOException {
        if (this.datastreamLevel_ < 16 && l > Integer.MAX_VALUE) {
            throw new IOException("File offset too large: " + l);
        }
        int n3 = this.datastreamLevel_ < 16 ? 22 : 38;
        this.out_.writeInt(20 + n3);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(n3);
        this.out_.writeShort(3);
        this.out_.writeShort(0);
        this.out_.writeInt(n);
        if (this.datastreamLevel_ < 16) {
            this.out_.writeInt(0);
            this.out_.writeInt((int)l);
        } else {
            this.out_.writeInt(0);
            this.out_.writeInt(0);
        }
        this.out_.writeInt(n2);
        this.out_.writeInt(0);
        if (this.datastreamLevel_ >= 16) {
            this.out_.writeLong(0L);
            this.out_.writeLong(l);
        }
    }

    private void sendListAttributesOA1Request(int n, int n2, int n3) throws IOException {
        this.out_.writeInt(54);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(20);
        this.out_.writeShort(10);
        this.out_.writeShort(0);
        this.out_.writeInt(n);
        this.out_.writeShort(0);
        this.out_.writeInt(1);
        this.out_.writeShort(0);
        this.out_.writeShort(65535);
        this.out_.writeShort(66);
        this.out_.writeShort(0);
        this.out_.writeInt(14);
        this.out_.writeShort(16);
        this.out_.writeInt(n2);
        this.out_.writeInt(n3);
    }

    private void sendCloseFileRequest(int n) throws IOException {
        this.out_.writeInt(41);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(21);
        this.out_.writeShort(9);
        this.out_.writeShort(0);
        this.out_.writeInt(n);
        this.out_.writeShort(2);
        this.out_.writeShort(65535);
        this.out_.writeShort(100);
        this.out_.writeByte(0);
        this.out_.writeLong(0L);
    }

    private void sendOpenFileRequest(byte[] byArray, int n, int n2, boolean bl, int n3) throws IOException {
        int n4 = this.datastreamLevel_ < 16 ? 36 : 44;
        this.out_.writeInt(26 + n4 + byArray.length);
        this.out_.writeShort(0);
        this.out_.writeShort(57346);
        this.out_.writeInt(0);
        this.out_.writeInt(this.newCorrelationID());
        this.out_.writeShort(n4);
        this.out_.writeShort(2);
        this.out_.writeShort(0);
        this.out_.writeShort(1200);
        this.out_.writeInt(1);
        this.out_.writeShort(n3);
        this.out_.writeShort(n);
        this.out_.writeShort(n2);
        this.out_.writeShort(0);
        this.out_.writeShort(bl ? 1 : 8);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeShort(1);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        if (this.datastreamLevel_ >= 16) {
            this.out_.writeLong(0L);
        }
        this.out_.writeInt(byArray.length + 6);
        this.out_.writeShort(2);
        this.out_.write(byArray);
    }

    private void sendDeleteFileRequest(HostServerConnection.HostOutputStream hostOutputStream, byte[] byArray) throws IOException {
        hostOutputStream.writeInt(34 + byArray.length);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57346);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(this.newCorrelationID());
        hostOutputStream.writeShort(8);
        hostOutputStream.writeShort(12);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(1200);
        hostOutputStream.writeInt(1);
        hostOutputStream.writeInt(byArray.length + 6);
        hostOutputStream.writeShort(2);
        hostOutputStream.write(byArray);
    }

    private static void sendExchangeAttributesRequest(HostServerConnection.HostOutputStream hostOutputStream) throws IOException {
        hostOutputStream.writeInt(42);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57346);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(10);
        hostOutputStream.writeShort(22);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(8);
        hostOutputStream.writeShort(6);
        hostOutputStream.writeInt(-1);
        hostOutputStream.writeInt(12);
        hostOutputStream.writeShort(10);
        hostOutputStream.writeShort(1200);
        hostOutputStream.writeShort(13488);
        hostOutputStream.writeShort(61952);
    }

    private static long convertDate(HostServerConnection.HostInputStream hostInputStream) throws IOException {
        int n = hostInputStream.readInt();
        int n2 = hostInputStream.readInt();
        long l = (long)n * 1000L + (long)(n2 / 1000);
        return l;
    }
}

