/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.database.DatabaseDescribeCallback;
import com.ibm.jtopenlite.database.jdbc.Column;
import com.ibm.jtopenlite.database.jdbc.JDBCColumnMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;

public class JDBCResultSetMetaData
implements ResultSetMetaData,
DatabaseDescribeCallback {
    private Column[] columns_;
    private int offset_;
    private String catalog_;
    final int serverCCSID_;
    private final Calendar calendar_;

    public JDBCResultSetMetaData(int n, Calendar calendar, String string) {
        this.serverCCSID_ = n;
        this.calendar_ = calendar;
        this.catalog_ = string;
    }

    public void resultSetDescription(int n, int n2, int n3, int n4, int n5, int n6) {
        this.columns_ = new Column[n];
        for (int i = 0; i < n; ++i) {
            this.columns_[i] = new Column(this.calendar_, i + 1, false);
            this.columns_[i].setDateFormat(n2);
            this.columns_[i].setTimeFormat(n3);
            this.columns_[i].setDateSeparator(n4);
            this.columns_[i].setTimeSeparator(n5);
        }
        this.offset_ = 0;
    }

    public void fieldDescription(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.columns_[n].setType(n2);
        this.columns_[n].setLength(n3);
        this.columns_[n].setScale(n4);
        this.columns_[n].setPrecision(n5);
        this.columns_[n].setCCSID(n6);
        this.columns_[n].setOffset(this.offset_);
        this.columns_[n].setLobMaxSize(n9);
        this.offset_ += n3;
    }

    public void fieldName(int n, String string) {
        this.columns_[n].setName(string);
    }

    public void udtName(int n, String string) {
        this.columns_[n].setUdtName(string);
    }

    public void baseColumnName(int n, String string) {
    }

    public void baseTableName(int n, String string) {
        this.columns_[n].setTable(string);
    }

    public void columnLabel(int n, String string) {
        this.columns_[n].setLabel(string);
    }

    public void baseSchemaName(int n, String string) {
        this.columns_[n].setSchema(string);
    }

    public void sqlFromTable(int n, String string) {
    }

    public void sqlFromSchema(int n, String string) {
    }

    public void columnAttributes(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10) {
        if (this.columns_ != null) {
            this.columns_[n].setAutoIncrement(bl);
            this.columns_[n].setDefinitelyWritable(n2 == 241);
            this.columns_[n].setReadOnly(n2 == 240);
            this.columns_[n].setSearchable(n3 != 240);
            this.columns_[n].setWritable(n2 != 240);
        }
    }

    public void setUseDateCache(int n, boolean bl) {
        Column column = this.getColumn(n - 1);
        column.setUseDateCache(bl);
    }

    public void setUseDateCache(String string, boolean bl) {
        Column column = this.getColumn(string);
        column.setUseDateCache(bl);
    }

    public void setUseTimeCache(int n, boolean bl) {
        Column column = this.getColumn(n - 1);
        column.setUseTimeCache(bl);
    }

    public void setUseTimeCache(String string, boolean bl) {
        Column column = this.getColumn(string);
        column.setUseTimeCache(bl);
    }

    public void setUseStringCache(int n, boolean bl) {
        Column column = this.getColumn(n - 1);
        column.setUseStringCache(bl);
    }

    public void setUseStringCache(String string, boolean bl) {
        Column column = this.getColumn(string);
        column.setUseStringCache(bl);
    }

    public void setCacheLastOnly(int n, boolean bl) {
        Column column = this.getColumn(n - 1);
        column.setCacheLastOnly(bl);
    }

    public void setCacheLastOnly(String string, boolean bl) {
        Column column = this.getColumn(string);
        column.setCacheLastOnly(bl);
    }

    Column getColumn(int n) {
        return this.columns_[n];
    }

    Column getColumn(String string) {
        for (int i = 0; i < this.columns_.length; ++i) {
            if (!this.columns_[i].getName().equals(string)) continue;
            return this.columns_[i];
        }
        return null;
    }

    int getColumnIndex(String string) {
        for (int i = 0; i < this.columns_.length; ++i) {
            if (!this.columns_[i].getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumn(n);
        return this.catalog_;
    }

    public String getColumnClassName(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 6: {
                return "java.lang.Double";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 8: {
                return "java.lang.Double";
            }
            case 2: 
            case 3: 
            case 1111: {
                return "java.math.BigDecimal";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -3: 
            case -2: {
                return "[B";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case 2004: {
                return "com.ibm.db2.jdbc.app.DB2Blob";
            }
            case 2005: {
                return "com.ibm.db2.jdbc.app.DB2Clob";
            }
            case 70: {
                return "java.net.URL";
            }
            case 2009: {
                return "java.sql.SQLXML";
            }
        }
        return "UNKNOWN";
    }

    public int getColumnCount() throws SQLException {
        return this.columns_.length;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 5: {
                return 6;
            }
            case 4: {
                return 11;
            }
            case -5: {
                return 20;
            }
            case 7: {
                return 13;
            }
            case 6: 
            case 8: {
                return 22;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 26;
            }
            case 2005: {
                return this.getPrecision(n);
            }
            case 2: 
            case 3: {
                return this.getPrecision(n) + 2;
            }
            case 1111: {
                int n2 = this.getPrecision(n);
                switch (n2) {
                    case 16: {
                        n2 = 23;
                        break;
                    }
                    case 34: {
                        n2 = 42;
                        break;
                    }
                    default: {
                        n2 += 2;
                    }
                }
                return n2;
            }
        }
        return this.getPrecision(n);
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColumn(n);
        String string = this.columns_[n - 1].getLabel();
        if (string == null) {
            string = this.columns_[n - 1].getName();
        }
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].getName();
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].getSQLTypeName();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColumn(n);
        return JDBCColumnMetaData.getPrecision(this.columns_[n - 1]);
    }

    public int getScale(int n) throws SQLException {
        this.checkColumn(n);
        return JDBCColumnMetaData.getScale(this.columns_[n - 1]);
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].getSchema();
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].getTable();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isAutoIncrement();
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: {
                return false;
            }
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColumn(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isDefinitelyWritable();
    }

    public int isNullable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isNullable();
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isReadOnly();
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isSearchable();
    }

    public boolean isSigned(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 1111: {
                return true;
            }
        }
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumn(n);
        return this.columns_[n - 1].isWritable();
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.columns_.length) {
            JDBCError.throwSQLException("07009");
        }
    }
}

