/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class JDBCBlob
implements Blob {
    private final byte[] data_;
    private final int offset_;
    private int length_;

    public JDBCBlob(byte[] byArray, int n, int n2) {
        this.data_ = byArray;
        this.offset_ = n;
        this.length_ = n2;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.data_, this.offset_, this.length_);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n2 = (int)(l & Integer.MAX_VALUE);
        int n3 = this.length_ - n2 + 1;
        if (n3 > n) {
            n3 = n;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.data_, this.offset_ + n2 - 1, byArray, 0, n3);
        return byArray;
    }

    public long length() throws SQLException {
        return this.length_;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        byte[] byArray = blob.getBytes(0L, (int)(blob.length() & Integer.MAX_VALUE));
        return this.position(byArray, l);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad start: " + l);
        }
        for (int i = (int)(l & Integer.MAX_VALUE) + this.offset_ - 1; i < this.offset_ + this.length_; ++i) {
            boolean bl = true;
            for (int j = 0; bl && j < byArray.length; ++j) {
                if (this.data_[i] == byArray[j]) continue;
                bl = false;
            }
            if (!bl) continue;
            return i - this.offset_;
        }
        return -1L;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n = (int)(l & Integer.MAX_VALUE);
        return new JDBCBlobOutputStream(this, n - 1);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (l <= 0L) {
            throw new SQLException("Bad position: " + l);
        }
        int n3 = (int)(l & Integer.MAX_VALUE);
        int n4 = this.length_ - n3 + 1;
        if (n4 > n2) {
            n4 = n2;
        }
        System.arraycopy(byArray, n, this.data_, this.offset_ + n3 - 1, n4);
        return n4;
    }

    public void truncate(long l) throws SQLException {
        this.length_ = l < 0L ? 0 : (int)(l & Integer.MAX_VALUE);
    }

    private static final class JDBCBlobOutputStream
    extends OutputStream {
        private final JDBCBlob blob_;
        private int next_;

        JDBCBlobOutputStream(JDBCBlob jDBCBlob, int n) {
            this.blob_ = jDBCBlob;
            this.next_ = n + this.blob_.offset_;
        }

        public void write(int n) throws IOException {
            if (this.next_ < this.blob_.offset_ + this.blob_.length_) {
                ((JDBCBlob)this.blob_).data_[this.next_++] = (byte)n;
            }
        }
    }
}

