/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.google.common.base.Preconditions;
import com.mongodb.client.MongoCursor;
import com.mongodb.jdbc.MongoColumnInfo;
import com.mongodb.jdbc.MongoJsonSchema;
import com.mongodb.jdbc.MongoResultSet;
import com.mongodb.jdbc.MongoSQLBsonValue;
import com.mongodb.jdbc.MongoSQLResultSetMetaData;
import com.mongodb.jdbc.MongoStatement;
import com.mongodb.jdbc.logging.AutoLoggable;
import com.mongodb.jdbc.logging.LoggingAspect;
import com.mongodb.jdbc.logging.LoggingAspect$ajcMightHaveAspect;
import com.mongodb.jdbc.logging.MongoLogger;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.Decimal128;

@AutoLoggable
public class MongoSQLResultSet
extends MongoResultSet<BsonDocument>
implements ResultSet,
LoggingAspect$ajcMightHaveAspect {
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_14;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_15;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_16;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_17;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_18;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_19;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_20;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_21;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_22;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_23;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_24;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_25;
    private transient /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;

    public MongoSQLResultSet(MongoLogger parentLogger, MongoCursor<BsonDocument> cursor, MongoJsonSchema schema) throws SQLException {
        super(parentLogger);
        LoggingAspect.ajc$perObjectBind(this);
        this.setUpResultset(cursor, schema);
        this.rsMetaData = new MongoSQLResultSetMetaData(schema, false, parentLogger, null);
    }

    public MongoSQLResultSet(MongoStatement statement, MongoCursor<BsonDocument> cursor, MongoJsonSchema schema) throws SQLException {
        super(statement);
        LoggingAspect.ajc$perObjectBind(this);
        this.setUpResultset(cursor, schema);
        this.rsMetaData = new MongoSQLResultSetMetaData(schema, true, statement.getParentLogger(), statement.getStatementId());
    }

    private void setUpResultset(MongoCursor<BsonDocument> cursor, MongoJsonSchema schema) throws SQLException {
        try {
            Preconditions.checkNotNull(cursor);
            this.cursor = cursor;
            return;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_0);
            }
            throw exception;
        }
    }

    @Override
    BsonDocument getCurrent() {
        try {
            return (BsonDocument)this.current;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_1);
            }
            throw exception;
        }
    }

    @Override
    protected boolean checkNull(BsonValue o) {
        try {
            this.wasNull = false;
            if (o == null) {
                this.wasNull = true;
                return true;
            }
            BsonType ty = o.getBsonType();
            switch (ty) {
                case UNDEFINED: 
                case NULL: {
                    this.wasNull = true;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_2);
            }
            throw exception;
        }
    }

    @Override
    protected BsonValue getBsonValue(int columnIndex) throws SQLException {
        try {
            this.checkBounds(columnIndex);
            MongoColumnInfo columnInfo = this.rsMetaData.getColumnInfo(columnIndex);
            BsonDocument datasource = ((BsonDocument)this.current).get(columnInfo.getTableName()).asDocument();
            return datasource.get(columnInfo.getColumnName());
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_3);
            }
            throw exception;
        }
    }

    @Override
    protected BsonValue getBsonValue(String columnLabel) throws SQLException {
        try {
            if (!this.rsMetaData.hasColumnWithLabel(columnLabel)) {
                throw new SQLException(String.format("column label '%s' not found", columnLabel));
            }
            int columnIndex = this.rsMetaData.getColumnPositionFromLabel(columnLabel);
            return this.getBsonValue(columnIndex + 1);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_4);
            }
            throw exception;
        }
    }

    @Override
    protected Object getObject(BsonValue o, int columnType) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (columnType) {
                case -5: {
                    return this.getLong(o);
                }
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt(o);
                }
                case -4: 
                case -3: 
                case -2: {
                    return o.asBinary().getData();
                }
                case -7: 
                case 16: {
                    return this.getBoolean(o);
                }
                case 6: 
                case 8: {
                    return this.getDouble(o);
                }
                case 2: 
                case 3: {
                    return o.asDecimal128().decimal128Value().bigDecimalValue();
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return this.getString(o);
                }
                case 7: {
                    return Float.valueOf(this.getFloat(o));
                }
                case 93: {
                    return new Timestamp(o.asDateTime().getValue());
                }
                case 0: {
                    return null;
                }
                case 1111: {
                    if (o.getBsonType() == BsonType.NULL) {
                        return null;
                    }
                    return new MongoSQLBsonValue(o);
                }
            }
            throw new SQLException("getObject not supported for column type " + columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_5);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int n = columnIndex;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_6, (Object)this, (Object)this, Conversions.intObject(n)));
            }
            BsonValue out = this.getBsonValue(columnIndex);
            int columnType = this.rsMetaData.getColumnType(columnIndex);
            return this.getObject(out, columnType);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_6);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        String string = columnLabel;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_7, (Object)this, (Object)this, string));
            }
            int columnIndex = this.findColumn(columnLabel);
            return this.getObject(columnIndex);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_7);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        int n = columnIndex;
        Map<String, Class<?>> map2 = map;
        try {
            BsonValue out;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_8, this, this, Conversions.intObject(n), map2));
            }
            if (this.checkNull(out = this.getBsonValue(columnIndex))) {
                return null;
            }
            String columnTypeName = this.rsMetaData.getColumnTypeName(columnIndex);
            Class<?> type = map.get(columnTypeName);
            if (type == null) {
                return null;
            }
            return type.cast(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_8);
            }
            throw exception;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        String string = columnLabel;
        Map<String, Class<?>> map2 = map;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_9, this, this, string, map2));
            }
            return this.getObject(this.findColumn(columnLabel), map);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_9);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        int n = columnIndex;
        Class<T> clazz = type;
        try {
            BsonValue out;
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_10, this, this, Conversions.intObject(n), clazz));
            }
            if (this.checkNull(out = this.getBsonValue(columnIndex))) {
                return null;
            }
            return type.cast(out);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_10);
            }
            throw exception;
        }
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        String string = columnLabel;
        Class<T> clazz = type;
        try {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$before$com_mongodb_jdbc_logging_LoggingAspect$2$abcb75fe(Factory.makeJP(ajc$tjp_11, this, this, string, clazz));
            }
            return this.getObject(this.findColumn(columnLabel), type);
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_11);
            }
            throw exception;
        }
    }

    @Override
    protected byte[] handleBytesConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to blob.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_12);
            }
            throw exception;
        }
    }

    @Override
    protected byte[] getBytes(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBytesConversionFailure("array");
                }
                case BINARY: {
                    return o.asBinary().getData();
                }
                case BOOLEAN: {
                    return this.handleBytesConversionFailure("boolean");
                }
                case DATE_TIME: {
                    return this.handleBytesConversionFailure("date");
                }
                case DB_POINTER: {
                    return this.handleBytesConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return this.handleBytesConversionFailure("decimal128");
                }
                case DOCUMENT: {
                    return this.handleBytesConversionFailure("document");
                }
                case DOUBLE: {
                    return this.handleBytesConversionFailure("double");
                }
                case END_OF_DOCUMENT: {
                    return this.handleBytesConversionFailure("end_of_document");
                }
                case INT32: {
                    return this.handleBytesConversionFailure("int32");
                }
                case INT64: {
                    return this.handleBytesConversionFailure("int64");
                }
                case JAVASCRIPT: {
                    return this.handleBytesConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBytesConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBytesConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBytesConversionFailure("min_key");
                }
                case NULL: {
                    return null;
                }
                case OBJECT_ID: {
                    return this.handleBytesConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBytesConversionFailure("regex");
                }
                case STRING: {
                    return this.handleBytesConversionFailure("string");
                }
                case SYMBOL: {
                    return this.handleBytesConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBytesConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return null;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_13);
            }
            throw exception;
        }
    }

    @Override
    protected String handleStringConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to string.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_14);
            }
            throw exception;
        }
    }

    @Override
    protected String getString(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            return new MongoSQLBsonValue(o).toString();
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_15);
            }
            throw exception;
        }
    }

    @Override
    protected boolean handleBooleanConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to boolean.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_16);
            }
            throw exception;
        }
    }

    @Override
    protected boolean getBoolean(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return false;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBooleanConversionFailure("array");
                }
                case BINARY: {
                    return this.handleBooleanConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue();
                }
                case DATE_TIME: {
                    return this.handleBooleanConversionFailure("date");
                }
                case DB_POINTER: {
                    return this.handleBooleanConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    Decimal128 v = o.asDecimal128().getValue();
                    return v != Decimal128.POSITIVE_ZERO && v != Decimal128.NEGATIVE_ZERO;
                }
                case DOCUMENT: {
                    return this.handleBooleanConversionFailure("document");
                }
                case DOUBLE: {
                    return o.asDouble().getValue() != 0.0;
                }
                case END_OF_DOCUMENT: {
                    return this.handleBooleanConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue() != 0;
                }
                case INT64: {
                    return o.asInt64().getValue() != 0L;
                }
                case JAVASCRIPT: {
                    return this.handleBooleanConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBooleanConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBooleanConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBooleanConversionFailure("min_key");
                }
                case NULL: {
                    return false;
                }
                case OBJECT_ID: {
                    return this.handleBooleanConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBooleanConversionFailure("regex");
                }
                case STRING: {
                    return true;
                }
                case SYMBOL: {
                    return this.handleBooleanConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBooleanConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return false;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_17);
            }
            throw exception;
        }
    }

    @Override
    protected long handleLongConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to integral type.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_18);
            }
            throw exception;
        }
    }

    @Override
    protected long getLong(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0L;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleLongConversionFailure("array");
                }
                case BINARY: {
                    return this.handleLongConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1 : 0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DB_POINTER: {
                    return this.handleLongConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().longValue();
                }
                case DOCUMENT: {
                    return this.handleLongConversionFailure("document");
                }
                case DOUBLE: {
                    return (long)o.asDouble().getValue();
                }
                case END_OF_DOCUMENT: {
                    return this.handleLongConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case JAVASCRIPT: {
                    return this.handleLongConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleLongConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleLongConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleLongConversionFailure("min_key");
                }
                case NULL: {
                    return 0L;
                }
                case OBJECT_ID: {
                    return this.handleLongConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleLongConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return Long.parseLong(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleLongConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleLongConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return 0L;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_19);
            }
            throw exception;
        }
    }

    @Override
    protected double handleDoubleConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to double.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_20);
            }
            throw exception;
        }
    }

    @Override
    protected double getDouble(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return 0.0;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleDoubleConversionFailure("array");
                }
                case BINARY: {
                    return this.handleDoubleConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? 1.0 : 0.0;
                }
                case DATE_TIME: {
                    return o.asDateTime().getValue();
                }
                case DB_POINTER: {
                    return this.handleDoubleConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().doubleValue();
                }
                case DOCUMENT: {
                    return this.handleDoubleConversionFailure("document");
                }
                case DOUBLE: {
                    return o.asDouble().getValue();
                }
                case END_OF_DOCUMENT: {
                    return this.handleDoubleConversionFailure("end_of_document");
                }
                case INT32: {
                    return o.asInt32().getValue();
                }
                case INT64: {
                    return o.asInt64().getValue();
                }
                case JAVASCRIPT: {
                    return this.handleDoubleConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleDoubleConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleDoubleConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleDoubleConversionFailure("min_key");
                }
                case NULL: {
                    return 0.0;
                }
                case OBJECT_ID: {
                    return this.handleDoubleConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleDoubleConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return Double.parseDouble(o.asString().getValue());
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleDoubleConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleDoubleConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return 0.0;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_21);
            }
            throw exception;
        }
    }

    @Override
    protected BigDecimal handleBigDecimalConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to BigDecimal.");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_22);
            }
            throw exception;
        }
    }

    @Override
    protected BigDecimal getBigDecimal(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return BigDecimal.ZERO;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleBigDecimalConversionFailure("array");
                }
                case BINARY: {
                    return this.handleBigDecimalConversionFailure("binary");
                }
                case BOOLEAN: {
                    return o.asBoolean().getValue() ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                case DATE_TIME: {
                    return new BigDecimal(o.asDateTime().getValue());
                }
                case DB_POINTER: {
                    return this.handleBigDecimalConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return o.asDecimal128().decimal128Value().bigDecimalValue();
                }
                case DOCUMENT: {
                    return this.handleBigDecimalConversionFailure("document");
                }
                case DOUBLE: {
                    return new BigDecimal(o.asDouble().getValue());
                }
                case END_OF_DOCUMENT: {
                    return this.handleBigDecimalConversionFailure("end_of_document");
                }
                case INT32: {
                    return new BigDecimal(o.asInt32().getValue());
                }
                case INT64: {
                    return new BigDecimal(o.asInt64().getValue());
                }
                case JAVASCRIPT: {
                    return this.handleBigDecimalConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleBigDecimalConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleBigDecimalConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleBigDecimalConversionFailure("min_key");
                }
                case NULL: {
                    return BigDecimal.ZERO;
                }
                case OBJECT_ID: {
                    return this.handleBigDecimalConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleBigDecimalConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return new BigDecimal(o.asString().getValue());
                    }
                    catch (ArithmeticException | NumberFormatException e) {
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleBigDecimalConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleBigDecimalConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return BigDecimal.ZERO;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_23);
            }
            throw exception;
        }
    }

    @Override
    protected java.util.Date handleUtilDateConversionFailure(String from) throws SQLException {
        try {
            throw new SQLException("The " + from + " type cannot be converted to java.util.Date");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_24);
            }
            throw exception;
        }
    }

    @Override
    protected java.util.Date getUtilDate(BsonValue o) throws SQLException {
        try {
            if (this.checkNull(o)) {
                return null;
            }
            switch (o.getBsonType()) {
                case ARRAY: {
                    return this.handleUtilDateConversionFailure("array");
                }
                case BINARY: {
                    return this.handleUtilDateConversionFailure("binary");
                }
                case BOOLEAN: {
                    return this.handleUtilDateConversionFailure("boolean");
                }
                case DATE_TIME: {
                    return new java.util.Date(o.asDateTime().getValue());
                }
                case DB_POINTER: {
                    return this.handleUtilDateConversionFailure("db_pointer");
                }
                case DECIMAL128: {
                    return new Date(o.asDecimal128().longValue());
                }
                case DOCUMENT: {
                    return this.handleUtilDateConversionFailure("document");
                }
                case DOUBLE: {
                    return new Date((long)o.asDouble().getValue());
                }
                case END_OF_DOCUMENT: {
                    return this.handleUtilDateConversionFailure("end_of_document");
                }
                case INT32: {
                    return new Date(o.asInt32().getValue());
                }
                case INT64: {
                    return new Date(o.asInt64().getValue());
                }
                case JAVASCRIPT: {
                    return this.handleUtilDateConversionFailure("javascript");
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    return this.handleUtilDateConversionFailure("javascript_with_code");
                }
                case MAX_KEY: {
                    return this.handleUtilDateConversionFailure("max_key");
                }
                case MIN_KEY: {
                    return this.handleUtilDateConversionFailure("min_key");
                }
                case NULL: {
                    return null;
                }
                case OBJECT_ID: {
                    return this.handleUtilDateConversionFailure("objectId");
                }
                case REGULAR_EXPRESSION: {
                    return this.handleUtilDateConversionFailure("regex");
                }
                case STRING: {
                    try {
                        return this.dateFormat.parse(o.asString().getValue());
                    }
                    catch (ParseException e) {
                        throw new SQLException(e);
                    }
                }
                case SYMBOL: {
                    return this.handleUtilDateConversionFailure("symbol");
                }
                case TIMESTAMP: {
                    return this.handleUtilDateConversionFailure("timestamp");
                }
                case UNDEFINED: {
                    return null;
                }
            }
            throw new SQLException("Unknown BSON type: " + (Object)((Object)o.getBsonType()) + ".");
        }
        catch (Exception exception) {
            if (LoggingAspect.hasAspect(this)) {
                LoggingAspect.aspectOf(this).ajc$afterThrowing$com_mongodb_jdbc_logging_LoggingAspect$3$9756aa6b(exception, ajc$tjp_25);
            }
            throw exception;
        }
    }

    static {
        MongoSQLResultSet.ajc$preClinit();
    }

    @Override
    public /* synthetic */ LoggingAspect ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectGet() {
        return this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField;
    }

    @Override
    public /* synthetic */ void ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectSet(LoggingAspect loggingAspect) {
        this.ajc$com_mongodb_jdbc_logging_LoggingAspect$perObjectField = loggingAspect;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MongoSQLResultSet.java", MongoSQLResultSet.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setUpResultset", "com.mongodb.jdbc.MongoSQLResultSet", "com.mongodb.client.MongoCursor:com.mongodb.jdbc.MongoJsonSchema", "cursor:schema", "java.sql.SQLException", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getCurrent", "com.mongodb.jdbc.MongoSQLResultSet", "", "", "", "org.bson.BsonDocument"), 84);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "int:java.lang.Class", "columnIndex:type", "java.sql.SQLException", "java.lang.Object"), 232);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String:java.lang.Class", "columnLabel:type", "java.sql.SQLException", "java.lang.Object"), 241);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBytesConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "[B"), 246);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBytes", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "[B"), 251);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleStringConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.lang.String"), 309);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getString", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.lang.String"), 314);
        ajc$tjp_16 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBooleanConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "boolean"), 322);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBoolean", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "boolean"), 327);
        ajc$tjp_18 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleLongConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "long"), 389);
        ajc$tjp_19 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getLong", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "long"), 394);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "checkNull", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "", "boolean"), 89);
        ajc$tjp_20 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleDoubleConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "double"), 455);
        ajc$tjp_21 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getDouble", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "double"), 460);
        ajc$tjp_22 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleBigDecimalConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.math.BigDecimal"), 521);
        ajc$tjp_23 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBigDecimal", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.math.BigDecimal"), 526);
        ajc$tjp_24 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "handleUtilDateConversionFailure", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "from", "java.sql.SQLException", "java.util.Date"), 587);
        ajc$tjp_25 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getUtilDate", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue", "o", "java.sql.SQLException", "java.util.Date"), 592);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBsonValue", "com.mongodb.jdbc.MongoSQLResultSet", "int", "columnIndex", "java.sql.SQLException", "org.bson.BsonValue"), 107);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getBsonValue", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "org.bson.BsonValue"), 115);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "org.bson.BsonValue:int", "o:columnType", "java.sql.SQLException", "java.lang.Object"), 127);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "int", "columnIndex", "java.sql.SQLException", "java.lang.Object"), 198);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String", "columnLabel", "java.sql.SQLException", "java.lang.Object"), 205);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "int:java.util.Map", "columnIndex:map", "java.sql.SQLException", "java.lang.Object"), 211);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.mongodb.jdbc.MongoSQLResultSet", "java.lang.String:java.util.Map", "columnLabel:map", "java.sql.SQLException", "java.lang.Object"), 226);
    }
}

