/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostGresDatabaseInfo
extends BaseDatabaseInfo {
    private static final String SPL_URL_PREFIX = "jdbc:postgresql:";
    private static final String URL_PREFIX = "jdbc:postgresql://";
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:postgresql://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:postgresql://";
    private static final String DEFAULT_PORT = "5432";

    public PostGresDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> postgresDataBaseDetails = new Hashtable<String, String>();
        postgresDataBaseDetails.put("SERVERTYPE", this.dbType);
        if (this.isParsingFailure) {
            postgresDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            postgresDataBaseDetails.put("DATABASENAME", "-");
            postgresDataBaseDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            postgresDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            postgresDataBaseDetails.put("DATABASENAME", "-");
            postgresDataBaseDetails.put("PORTNUMBER", "-");
        } else {
            postgresDataBaseDetails.put("SERVERTYPE", this.dbType);
            postgresDataBaseDetails.put("SERVERNAME", this.hostName);
            postgresDataBaseDetails.put("DATABASENAME", this.databaseName);
            postgresDataBaseDetails.put("PORTNUMBER", this.portNo);
        }
        return postgresDataBaseDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(URL_PREFIX)) {
                String hostPortDbString = maker.after(URL_PREFIX).before("?").value().trim();
                this.parseUrl(hostPortDbString);
            } else if (normalizedUrl.startsWith(WEBLOGIC_URL_PREFIX)) {
                maker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(SPL_URL_PREFIX)) {
                String databaseString = maker.after(SPL_URL_PREFIX).before("?").value().trim();
                this.databaseName = databaseString != null && databaseString.length() > 0 ? (databaseString.equals("/") ? "-" : databaseString) : "-";
                this.hostName = "localhost";
                this.portNo = DEFAULT_PORT;
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
        this.logger.debug("[" + this.dbType + " -parseUrl] hostName :" + this.hostName + " portNo :" + this.portNo + " databaseName :" + this.databaseName);
    }

    private void parseUrl(String hostPortDbString) {
        this.logger.debug("[" + this.dbType + "  - parseUrl] hostPortDbString :" + hostPortDbString);
        int slash_index = hostPortDbString.indexOf("/");
        if (slash_index > 0) {
            String databaseString = hostPortDbString.substring(slash_index + 1);
            hostPortDbString = hostPortDbString.substring(0, slash_index);
            this.logger.debug("[" + this.dbType + "  - parseUrl] databaseString :" + databaseString);
            this.databaseName = databaseString != null && databaseString.length() > 0 ? databaseString : "-";
        }
        if (hostPortDbString != null) {
            int comma_index = hostPortDbString.indexOf(",");
            if (comma_index > 0) {
                this.logger.debug("[" + this.dbType + "  - parseUrl]. It is cluster JDBC Url");
                this.isParsingFailure = true;
            } else {
                this.assignHostNameAndPort(hostPortDbString, DEFAULT_PORT);
            }
        }
        if (this.portNo == null) {
            this.portNo = DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:postgresql:database";
        jdbcUrl = "jdbc:postgresql:database?user=fred&password=secret&ssl=true";
        jdbcUrl = "jdbc:postgresql://myhost/pSqlDb";
        jdbcUrl = "jdbc:postgresql://myhost/";
        jdbcUrl = "jdbc:postgresql://myhost:2244/pSqlDb";
        jdbcUrl = "jdbc:postgresql://myhost:2244/?user=fred&password=secret&ssl=true";
        jdbcUrl = "jdbc:datadirect:postgresql://server1:5433;DatabaseName=TEST;User=test;Password=secret;AlternateServers=(server2:5432;DatabaseName=TEST2,server3:5432;DatabaseName=TEST3)";
        PostGresDatabaseInfo dbInfo = new PostGresDatabaseInfo(jdbcUrl, "PostGres", null);
        Hashtable<String, String> result = dbInfo.getDBInfo();
        System.out.println(" result :" + result);
    }
}

