/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.JDBCStringParsingException;
import com.eg.jtm.OracleDriverType;
import com.eg.jtm.OracleKeyValue;
import com.eg.jtm.OracleNetConnectionDescriptorTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.jtm.Token;

public class OracleNetConnectionDescriptorParser {
    private static final String THIN = "jdbc:oracle:thin";
    private static final String OCI = "jdbc:oracle:oci";
    private String jdbcUrl;
    private String lowerCaseUrl;
    private OracleDriverType driverType;
    private OracleNetConnectionDescriptorTokenizer descriptorTokenizer;

    public OracleNetConnectionDescriptorParser(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        this.lowerCaseUrl = jdbcUrl.toLowerCase();
        this.descriptorTokenizer = new OracleNetConnectionDescriptorTokenizer(this.lowerCaseUrl);
    }

    public OracleKeyValue parse() {
        int position;
        if (this.lowerCaseUrl.startsWith(THIN)) {
            position = this.nextPosition(THIN);
            this.driverType = OracleDriverType.THIN;
        } else if (this.lowerCaseUrl.startsWith(OCI)) {
            position = this.nextPosition(OCI);
            this.driverType = OracleDriverType.OCI;
        } else {
            throw new IllegalArgumentException("invalid oracle jdbc url. expected token:(jdbc:oracle:thin or jdbc:oracle:oci) url:" + this.jdbcUrl);
        }
        this.descriptorTokenizer.setPosition(position);
        this.descriptorTokenizer.parse();
        OracleKeyValue keyValue = this.parseKeyValue();
        this.checkEof();
        return keyValue;
    }

    private void checkEof() {
        Token eof = this.descriptorTokenizer.nextToken();
        if (eof == null) {
            throw new JDBCStringParsingException("parsing error. expected token:'EOF' token:null");
        }
        if (eof != OracleNetConnectionDescriptorTokenizer.TOKEN_EOF_OBJECT) {
            throw new JDBCStringParsingException("parsing error. expected token:'EOF' token:" + eof);
        }
    }

    public OracleDriverType getDriverType() {
        return this.driverType;
    }

    private int nextPosition(String driverUrl) {
        int thinLength = driverUrl.length();
        if (this.lowerCaseUrl.startsWith(":@", thinLength)) {
            return thinLength + 2;
        }
        if (this.lowerCaseUrl.startsWith("@", thinLength)) {
            return thinLength + 1;
        }
        try {
            String afterthin = this.lowerCaseUrl.substring(thinLength);
            StringMaker maker = new StringMaker(afterthin);
            String beforeAt = maker.before('@').value().trim();
            if (beforeAt != null) {
                int len = beforeAt.length();
                return thinLength + len + 1;
            }
            throw new JDBCStringParsingException("Unable to parse the oracle jdbc url:" + driverUrl);
        }
        catch (Exception e) {
            throw new JDBCStringParsingException("Unable to parse the oracle jdbc url:" + driverUrl);
        }
    }

    private OracleKeyValue parseKeyValue() {
        Token token;
        boolean nonTerminalValue;
        OracleKeyValue keyValue;
        block5: {
            Token endCheck;
            this.descriptorTokenizer.checkStartToken();
            keyValue = new OracleKeyValue();
            Token literalToken = this.descriptorTokenizer.getLiteralToken();
            keyValue.setKeyString(literalToken.getToken());
            this.descriptorTokenizer.checkEqualToken();
            nonTerminalValue = false;
            do {
                if ((token = this.descriptorTokenizer.lookAheadToken()) == null) {
                    throw new JDBCStringParsingException("Syntax error. lookAheadToken is null");
                }
                if (token.getType() != 0) break block5;
                nonTerminalValue = true;
                OracleKeyValue child = this.parseKeyValue();
                keyValue.addKeyValueList(child);
            } while ((endCheck = this.descriptorTokenizer.lookAheadToken()) != OracleNetConnectionDescriptorTokenizer.TOKEN_KEY_END_OBJECT);
            this.descriptorTokenizer.nextPosition();
            return keyValue;
        }
        if (token.getType() == 3) {
            if (nonTerminalValue) {
                throw new JDBCStringParsingException("Syntax error. expected token:'(' or ')' :" + token.getToken());
            }
            this.descriptorTokenizer.nextPosition();
            keyValue.setValueString(token.getToken());
            this.descriptorTokenizer.checkEndToken();
            return keyValue;
        }
        if (token.getType() == 1) {
            this.descriptorTokenizer.nextPosition();
            return keyValue;
        }
        throw new JDBCStringParsingException("Syntax error. " + token.getToken());
    }
}

