/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.DataRepository;
import com.eg.apm.JavaBTMLogger;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class JVMDataRepository
implements DataRepository {
    private final Hashtable dataTable = new Hashtable();
    public static Logger logger = JavaBTMLogger.btmLogger;
    private static final String loggerDispStr = "[JVMDataRepository]";
    private static JVMDataRepository dataRepository = new JVMDataRepository();

    private JVMDataRepository() {
    }

    public static JVMDataRepository getDataRepository() {
        return dataRepository;
    }

    public Hashtable getDataTable(String nodeId) {
        return (Hashtable)this.dataTable.get(nodeId);
    }

    public void setData(String nodeId, Hashtable htable) {
        Set keys = htable.keySet();
        for (String key : keys) {
            ArrayList al = (ArrayList)htable.get(key);
            if (this.dataTable.containsKey(nodeId)) {
                Hashtable innerTable = (Hashtable)this.dataTable.get(nodeId);
                innerTable.put(key, al);
                continue;
            }
            Hashtable<String, ArrayList> h = new Hashtable<String, ArrayList>();
            h.put(key, al);
            this.dataTable.put(nodeId, h);
        }
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            logger.trace("{} {} JVM data added into repository : {}", new Object[]{loggerDispStr, nodeId, htable});
        }
    }

    public void clearData(String jvmGuid) {
        try {
            if (jvmGuid != null) {
                this.dataTable.remove(jvmGuid);
            }
        }
        catch (Exception e) {
            logger.warn("{} {} Unable to clear data for JVM data repository : {}", (Object)loggerDispStr, (Object)jvmGuid);
        }
    }

    public ArrayList getData(String nodeId, String entity) {
        ArrayList al = null;
        boolean res = APMComponentIDRepository.getRepository().isOffloadComponentID(nodeId);
        if (!res) {
            logger.info("{}  This Component {} data not available in JAR mode repository . Ensure JAR mode running or Please enable JMX mode for this component. Entity : {} ", new Object[]{loggerDispStr, nodeId, entity});
            return al;
        }
        if (this.dataTable.containsKey(nodeId)) {
            Hashtable innerTable = (Hashtable)this.dataTable.get(nodeId);
            al = (ArrayList)innerTable.remove(entity);
        }
        if (al != null) {
            logger.trace("{} {} JVM data retrived from repository : {}", new Object[]{loggerDispStr, nodeId, al.size()});
        }
        return al;
    }
}

