/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLogbackManager;
import com.eg.apm.EgLogbackProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class EgLogbackWatcher
extends Thread {
    private static EgLogbackWatcher instance;
    private static final long sleepPeriod = 60000L;
    private long lastModLogProps = -1L;
    private File logPropsFile = null;

    private EgLogbackWatcher() {
        this.setDaemon(true);
        this.setName("EgLogbackWatcher");
        this.start();
        System.out.println("EgLogbackWatcher Started !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized EgLogbackWatcher getInstance() {
        if (instance != null) return instance;
        Class<EgLogbackWatcher> clazz = EgLogbackWatcher.class;
        synchronized (EgLogbackWatcher.class) {
            if (instance != null) return instance;
            instance = new EgLogbackWatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void run() {
        String string = EgLogbackProperties.getLogbackPropertiesPath();
        if (string == null) {
            System.out.println("[EgLogbackWatcher] - Unable to find the file :eg_logback.properties");
            return;
        }
        while (true) {
            try {
                this.logPropsFile = new File(string);
                if (this.logPropsFile.exists()) {
                    long l = this.logPropsFile.lastModified();
                    if (this.lastModLogProps < 0L) {
                        this.lastModLogProps = l;
                    } else if (l != this.lastModLogProps) {
                        System.out.println("[EgLogbackWatcher] - eg_logback.properties file is modified");
                        Properties properties = new Properties();
                        properties.load(new BufferedInputStream(new FileInputStream(this.logPropsFile)));
                        EgLogbackManager.getInstance().updateConfig(properties);
                        this.lastModLogProps = l;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.sleepForSomeTime(60000L);
        }
    }

    private void sleepForSomeTime(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

