/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.IPV6Helper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ContainerCategory;
import com.eg.apm.ContainerImpl;
import com.eg.apm.DockerContainersThread;
import com.eg.apm.EgApmMainAgentInfo;
import com.eg.apm.KubernetesAPI;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DockerContainers
extends ContainerImpl {
    private static DockerContainers docContServer = null;
    private static String sync = new String("sync");
    private static final String loggerDispStr = "[DockerContainers]";

    private DockerContainers(ContainerCategory containerCategory) {
        super(containerCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DockerContainers getDockerContainerInstance(ContainerCategory containerCategory) {
        if (docContServer == null) {
            String string = sync;
            synchronized (string) {
                if (docContServer == null) {
                    docContServer = new DockerContainers(containerCategory);
                }
            }
        }
        return docContServer;
    }

    public Hashtable getContainerPortDetails() {
        return this.ht_containerIdAndPort;
    }

    public void updateRepo() {
        this.updateRepo(false);
    }

    public void updateRepo(boolean bl) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime >= 600000L || bl && l - this.lastUpdatedTime > 10000L) {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
        }
    }

    public String getPodNameSpaceName(String string) {
        this.updateRepo();
        String string2 = "";
        if (this.ht_containerIdAndNameSpace != null && this.ht_containerIdAndNameSpace.containsKey(string)) {
            string2 = (String)this.ht_containerIdAndNameSpace.get(string);
        } else {
            this.updateRepo(true);
            if (this.ht_containerIdAndNameSpace != null && this.ht_containerIdAndNameSpace.containsKey(string)) {
                string2 = (String)this.ht_containerIdAndNameSpace.get(string);
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} strContainerId : {}, strPodNameSpaceName : {}, ht_containerIdAndNameSpace : {}", new Object[]{loggerDispStr, string, string2, this.ht_containerIdAndNameSpace});
        return string2;
    }

    public Hashtable getRunningContainerIpDetails() {
        Hashtable hashtable;
        String string;
        String string2;
        int n;
        Hashtable hashtable2 = this.geRunningContainerDetails();
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
        if (hashtable2 != null && hashtable2.size() > 0) {
            int n3 = hashtable2.size();
            int n4 = 10;
            n = 1;
            int n5 = 0;
            Enumeration enumeration = hashtable2.keys();
            string2 = "";
            while (enumeration.hasMoreElements()) {
                String string3;
                string = (String)enumeration.nextElement();
                ++n5;
                APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails processing for containerId : {}", (Object)loggerDispStr, (Object)string);
                if (string == null) {
                    if (n == n4) {
                        arrayList.add(string2);
                        string2 = "";
                        n = 1;
                    }
                    if (n5 == n3 && n != n4) {
                        arrayList.add(string2);
                    }
                    APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails al_ContainerNames  : {}, cont_name : {}", new Object[]{loggerDispStr, arrayList, string2});
                    continue;
                }
                Hashtable hashtable4 = (Hashtable)hashtable2.get(string);
                if (hashtable4 == null) {
                    if (n == n4) {
                        arrayList.add(string2);
                        string2 = "";
                        n = 1;
                    }
                    if (n5 == n3 && n != n4) {
                        arrayList.add(string2);
                    }
                    APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails al_ContainerNames  : {}, cont_name : {}", new Object[]{loggerDispStr, arrayList, string2});
                    continue;
                }
                if (hashtable4.containsKey("Command")) {
                    string3 = (String)hashtable4.get("Command");
                    if (string3 != null && (string3 = string3.trim()).startsWith("\"") && string3.endsWith("\"")) {
                        string3.substring(1, string3.length() - 1);
                    }
                    if (string3 != null && string3.trim().equalsIgnoreCase("\"/pause\"")) {
                        if (n == n4) {
                            arrayList.add(string2);
                            string2 = "";
                            n = 1;
                        }
                        if (n5 == n3 && n != n4) {
                            arrayList.add(string2);
                        }
                        APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails al_ContainerNames  : {}, cont_name : {}", new Object[]{loggerDispStr, arrayList, string2});
                        continue;
                    }
                }
                APMDiscoveryLogger.discoveryLogger.trace("{} getRunningContainerIpDetails containerId : {}, i : {}, j : {}, maxSize : {}, cont_name : {}, count :{}", new Object[]{loggerDispStr, string, n, n5, n4, string2, n3});
                if (n <= n4) {
                    string2 = n == 1 ? string : string2 + " " + string;
                    ++n;
                }
                if (n == n4) {
                    arrayList.add(string2);
                    string2 = "";
                    n = 1;
                }
                if (n5 == n3 && n != n4) {
                    arrayList.add(string2);
                }
                APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails al_ContainerNames  : {}, cont_name : {}", new Object[]{loggerDispStr, arrayList, string2});
                string3 = null;
                if (!hashtable4.containsKey("Names") || (string3 = (String)hashtable4.get("Names")) == null) continue;
                hashtable3.put(string3, string);
                if (string3.toLowerCase().startsWith("k8s_")) {
                    arrayList2.add(string);
                    continue;
                }
                hashtable3.put(string3, string);
            }
        }
        APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIpDetails() al_ContainerNames  : {}", (Object)loggerDispStr, arrayList);
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null && arrayList.size() > 0) {
            ArrayList<DockerContainersThread> arrayList4 = new ArrayList<DockerContainersThread>();
            n = arrayList.size();
            String string4 = "docker inspect --format=\"{{.Name}}#@#{{.NetworkSettings.Ports}}#@#{{.Config.Labels}}#@#{{.NetworkSettings.IPAddress}}#@#{{range.NetworkSettings.Networks}}{{.IPAddress}}{{end}}\" ";
            for (int i = 0; i < n; ++i) {
                string2 = (String)arrayList.get(i);
                if (string2 == null) continue;
                string = string4 + string2;
                long l = System.currentTimeMillis();
                long l2 = 360000L;
                long l3 = l - l2;
                while (arrayList4.size() >= n2) {
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList4.get(j);
                        if (dockerContainersThread.isDone()) {
                            ArrayList arrayList5 = dockerContainersThread.getOutput();
                            if (arrayList5 != null && arrayList5.size() > 0) {
                                arrayList3.addAll(arrayList5);
                            }
                            arrayList4.remove(j--);
                            continue;
                        }
                        l = System.currentTimeMillis();
                        l3 = l - l2;
                        if (dockerContainersThread.startTime >= l3) continue;
                        try {
                            dockerContainersThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList4.remove(j);
                        --j;
                    }
                    if (arrayList4.size() < n2) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                DockerContainersThread dockerContainersThread = new DockerContainersThread(this, string);
                arrayList4.add(dockerContainersThread);
            }
            long l = 360000L;
            while (arrayList4.size() > 0) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList4.get(i);
                    if (dockerContainersThread.isDone()) {
                        ArrayList arrayList6 = dockerContainersThread.getOutput();
                        if (arrayList6 != null && arrayList6.size() > 0) {
                            arrayList3.addAll(arrayList6);
                        }
                        arrayList4.remove(i);
                        --i;
                        continue;
                    }
                    if (dockerContainersThread.startTime >= l5) continue;
                    try {
                        dockerContainersThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList4.remove(i);
                    --i;
                }
                if (arrayList4 == null || arrayList4.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        Hashtable hashtable5 = this.getKubePodIpDetails(arrayList2);
        if (APMDiscoveryLogger.discoveryLogger.isDebugEnabled()) {
            APMDiscoveryLogger.discoveryLogger.debug("{} ht_ContainerNameIdMapping  : {}", (Object)loggerDispStr, hashtable3);
            APMDiscoveryLogger.discoveryLogger.debug("{} al_runningContainersData  : {}", (Object)loggerDispStr, arrayList3);
            APMDiscoveryLogger.discoveryLogger.debug("{} docker exec hostname cmd results ht_kubernetPodIpDet : {}", (Object)loggerDispStr, (Object)hashtable5);
        }
        if ((hashtable = this.getRunningContainerIp(arrayList3, hashtable3, hashtable5)) == null) {
            hashtable = new Hashtable();
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} getRunningContainerIpDetails() ht_data : {}", (Object)loggerDispStr, hashtable);
        return hashtable;
    }

    public Hashtable getRunningContainerIp(ArrayList arrayList, Hashtable hashtable, Hashtable hashtable2) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        Hashtable<Object, String> hashtable3 = new Hashtable<Object, String>();
        for (int i = 0; i < n; ++i) {
            String string;
            Object object;
            String string2;
            int n2;
            Object object2;
            int n3;
            ArrayList arrayList2;
            String string3 = (String)arrayList.get(i);
            APMDiscoveryLogger.discoveryLogger.debug("{} getRunningContainerIp() docker inspect data line  : {}", (Object)loggerDispStr, (Object)string3);
            if (string3 == null || (arrayList2 = this.egTokenizer(string3, "#@#")) == null || arrayList2.size() < 5) continue;
            String string4 = (String)arrayList2.get(0);
            string4 = string4.trim();
            if ((string4 = string4.substring(1)).startsWith("/")) {
                string4 = string4.substring(1);
            }
            String string5 = (String)arrayList2.get(1);
            String string6 = (String)arrayList2.get(2);
            String string7 = (String)arrayList2.get(3);
            String string8 = (String)arrayList2.get(4);
            if (string7 != null) {
                if ((string7 = string7.trim()).equals("\"")) {
                    string7 = "";
                }
                if (string7.startsWith("\"") && string7.length() > 0) {
                    string7 = string7.substring(1);
                }
                if (string7.endsWith("\"") && string7.length() > 0) {
                    string7 = string7.substring(0, string7.length() - 1);
                }
            } else if (string8 != null) {
                if ((string8 = string8.trim()).startsWith("\"")) {
                    string8 = string8.substring(1);
                }
                if (string8.endsWith("\"")) {
                    string8 = string8.substring(0, string8.length() - 1);
                }
                string7 = string8;
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (string5 != null && string5.length() > 0 && string5.trim().startsWith("map[") && string5.length() > 4 && (n3 = ((StringTokenizer)(object2 = new StringTokenizer(string5 = string5.substring(4, string5.length() - 1), ":"))).countTokens()) > 1) {
                for (n2 = 0; n2 < n3; ++n2) {
                    string2 = ((StringTokenizer)object2).nextToken();
                    if (string2 == null || string2.indexOf("/") <= 0) continue;
                    object = new StringTokenizer(string2 = string2.substring(0, string2.indexOf("/")));
                    int n4 = ((StringTokenizer)object).countTokens();
                    if (n4 > 1) {
                        for (int j = 0; j < n4; ++j) {
                            string = ((StringTokenizer)object).nextToken();
                            if (j != n4 - 1) continue;
                            arrayList3.add(string);
                        }
                        continue;
                    }
                    arrayList3.add(string2);
                }
            }
            object2 = null;
            if (hashtable != null && string4 != null && hashtable.containsKey(string4)) {
                object2 = (String)hashtable.get(string4);
            }
            String string9 = "";
            n2 = 0;
            if (string7 != null && string7.length() > 0 && object2 != null) {
                hashtable3.put(object2, string7);
                n2 = 1;
                string9 = string7;
            } else if ((string7 == null || string7.length() <= 0) && object2 != null && hashtable2 != null && (string9 = (String)hashtable2.get(object2)) != null && string9.length() > 0) {
                hashtable3.put(object2, string9);
                n2 = 1;
            }
            string2 = "";
            object = "";
            String string10 = "";
            if (string4.toLowerCase().startsWith("k8s_") && string6 != null && (string6 = string6.trim()).startsWith("map[") && string6.endsWith("]")) {
                string6 = string6.substring(4, string6.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string6);
                while (stringTokenizer.hasMoreTokens()) {
                    int n5;
                    String string11;
                    String string12;
                    string = stringTokenizer.nextToken();
                    if (string == null || string.indexOf(":") <= 0) continue;
                    int n6 = string.indexOf(":");
                    String string13 = string.substring(0, n6);
                    String string14 = string.substring(n6 + 1);
                    if (string13.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string2 = string14;
                    }
                    if (string13.equalsIgnoreCase("annotation.io.kubernetes.pod.namespace")) {
                        object = string14;
                    }
                    if ((object == null || ((String)object).length() <= 0) && string13.equalsIgnoreCase("io.kubernetes.pod.namespace")) {
                        object = string14;
                    }
                    if (!string13.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string12 = string14) == null || string12.indexOf("\"containerPort\":") < 0 || (string11 = string12.substring((n5 = string12.indexOf("\"containerPort\":")) + 16)) == null || string11.indexOf(",") <= 0) continue;
                    string10 = string11.substring(0, string11.indexOf(","));
                }
            }
            try {
                KubernetesAPI kubernetesAPI;
                if (n2 == 0 && string2 != null && object2 != null && object != null && ((String)object).length() > 0 && (string9 = (kubernetesAPI = KubernetesAPI.createInstance()).getPodIp((String)object, string2)) != null && string9.length() > 0) {
                    hashtable3.put(object2, string9);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception : {}", (Object)loggerDispStr, (Object)exception);
            }
            if (string10 != null && string10.length() > 0 && (arrayList3 == null || arrayList3.size() == 0)) {
                arrayList3 = new ArrayList();
                arrayList3.add(string10);
            }
            if (string2 != null && object2 != null) {
                this.ht_containerIdAndPodName.put(object2, string2);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    this.ht_containerIdAndPort.put(object2, this.getHighPriorityPort(arrayList3));
                }
            }
            if (object != null && ((String)object).length() > 0) {
                this.ht_containerIdAndNameSpace.put(object2, object);
            }
            APMDiscoveryLogger.discoveryLogger.trace("{} podName : {}, containerID : {}, ports: {}, nameSpaceName : {}, podIp : {}", new Object[]{loggerDispStr, string2, object2, arrayList3, object, string9});
        }
        if (APMDiscoveryLogger.discoveryLogger.isTraceEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_containerIdAndPodName : {}", (Object)loggerDispStr, (Object)this.ht_containerIdAndPodName);
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_PodContainerMap : {}", (Object)loggerDispStr, (Object)this.ht_containerIdAndPort);
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_runningContainerIpMap : {}", (Object)loggerDispStr, (Object)this.ht_runningContainerIpMap);
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_NotRunningContainers : {}", (Object)loggerDispStr, (Object)this.ht_NotRunningContainers);
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_containerIdAndNameSpace : {}", (Object)loggerDispStr, (Object)this.ht_containerIdAndNameSpace);
        }
        return hashtable3;
    }

    private Hashtable getKubePodIpDetails(ArrayList arrayList) {
        Object object;
        Object object2;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        int n = arrayList.size();
        int n2 = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            String string2 = "docker exec " + string + " hostname -i";
            long l = System.currentTimeMillis();
            long l2 = 360000L;
            long l3 = l - l2;
            while (arrayList2.size() >= n2) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    object2 = (DockerContainersThread)arrayList2.get(j);
                    if (((DockerContainersThread)object2).isDone()) {
                        String string3;
                        ArrayList arrayList3 = ((DockerContainersThread)object2).getOutput();
                        String string4 = ((DockerContainersThread)object2).getContainerId();
                        if (arrayList3 != null && arrayList3.size() > 0 && string4 != null && (string3 = (String)arrayList3.get(0)) != null && IPV6Helper.validateIPV4(string3.trim())) {
                            hashtable.put(string4, string3);
                        }
                        arrayList2.remove(j);
                        --j;
                        continue;
                    }
                    l = System.currentTimeMillis();
                    l3 = l - l2;
                    if (((DockerContainersThread)object2).startTime >= l3) continue;
                    try {
                        ((Thread)object2).interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(j);
                    --j;
                }
                if (arrayList2.size() < n2) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            object = new DockerContainersThread(this, string2, string);
            arrayList2.add(object);
        }
        long l = 360000L;
        while (arrayList2.size() > 0) {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            for (int i = 0; i < arrayList2.size(); ++i) {
                DockerContainersThread dockerContainersThread = (DockerContainersThread)arrayList2.get(i);
                if (dockerContainersThread.isDone()) {
                    ArrayList arrayList4 = dockerContainersThread.getOutput();
                    object = dockerContainersThread.getContainerId();
                    if (arrayList4 != null && arrayList4.size() > 0 && object != null && (object2 = (String)arrayList4.get(0)) != null && IPV6Helper.validateIPV4(((String)object2).trim())) {
                        hashtable.put(object, object2);
                    }
                    arrayList2.remove(i);
                    --i;
                    continue;
                }
                if (dockerContainersThread.startTime >= l5) continue;
                try {
                    dockerContainersThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList2.remove(i);
                --i;
            }
            if (arrayList2 == null || arrayList2.size() == 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return hashtable;
    }

    public Hashtable geRunningContainerDetails() {
        try {
            Hashtable hashtable = new Hashtable();
            String string = "docker ps -a -s";
            ArrayList arrayList = this.executeCommand(string);
            if (arrayList == null || arrayList.size() == 0) {
                System.out.println(" [DockerContainers] " + string + "\toutput is null so return  ");
                return null;
            }
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string11 = (String)arrayList.get(i);
                APMDiscoveryLogger.discoveryLogger.trace("{} geRunningtContainerDetails() docker ps data line : {}", (Object)loggerDispStr, (Object)string11);
                if (string11 == null) continue;
                if (string11.indexOf("CONTAINER ID") >= 0) {
                    n2 = string11.indexOf("CONTAINER ID");
                    n3 = string11.indexOf("IMAGE");
                    n4 = string11.indexOf("COMMAND");
                    n5 = string11.indexOf("CREATED");
                    n6 = string11.indexOf("STATUS");
                    n7 = string11.indexOf("PORTS");
                    n8 = string11.indexOf("NAMES");
                    n9 = string11.indexOf("SIZE");
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                string2 = string11.substring(n2, n3 - 1).trim();
                string3 = string11.substring(n3, n4 - 1).trim();
                string4 = string11.substring(n4, n5 - 1).trim();
                string5 = string11.substring(n5, n6 - 1).trim();
                string7 = string11.substring(n6, n7 - 1).trim();
                string8 = string11.substring(n7, n8 - 1).trim();
                string9 = string11.substring(n8, n9 - 1).trim();
                string10 = string11.substring(n9).trim();
                hashtable2.put("Image", string3);
                hashtable2.put("Command", string4);
                hashtable2.put("Created", string5);
                hashtable2.put("Status", string7);
                hashtable2.put("Port", string8);
                hashtable2.put("Names", string9);
                hashtable2.put("Size", string10);
                if (string7 == null) continue;
                if (string7.toLowerCase().indexOf("up") >= 0) {
                    hashtable.put(string2, hashtable2);
                    continue;
                }
                this.ht_NotRunningContainers.put(string2, new Boolean(true));
            }
            APMDiscoveryLogger.discoveryLogger.trace("{} geRunningtContainerDetails() ht_runningContainers : {}", (Object)loggerDispStr, hashtable);
            return hashtable;
        }
        catch (Exception exception) {
            System.err.println(" [DockerContainers] Exception occured while getting containerDetails");
            exception.printStackTrace();
            return null;
        }
    }

    public String getHostInternalIp() {
        Object object = "127.0.0.1";
        String string = "ip -4 addr show docker0 | grep -Po 'inet \\K[\\d.]+'";
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getCommandOutputLines(string, true, true);
            if (arrayList != null && arrayList.size() > 0) {
                Object object2;
                ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                if (arrayList2 != null && arrayList2.size() > 0 && (object2 = (String)arrayList2.get(0)) != null && ((String)object2).length() > 0 && IPV6Helper.validateIPV4(((String)object2).trim())) {
                    object = object2;
                    System.out.println("Discovered DOCKER Internal IP Address : " + (String)object);
                }
                if (((String)object).equalsIgnoreCase("127.0.0.1")) {
                    object2 = (ArrayList)arrayList.get(1);
                    System.out.println("Unable to get DOCKER Internal IP Address, Std error is : " + object2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured while finding DOCKER Internal IP Address by using the command " + string);
            exception.printStackTrace();
        }
        return object;
    }

    public int getDockerPort(String string) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            StringTokenizer stringTokenizer;
            int n2;
            String string2 = "docker inspect --format=\"{{.NetworkSettings.Ports}}\" " + string;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList2 = egUtilities.getExecOutputLines(string2);
            ArrayList arrayList3 = null;
            if (arrayList2 != null && arrayList2.size() > 0) {
                arrayList3 = (ArrayList)arrayList2.get(0);
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return n;
            }
            String string3 = (String)arrayList3.get(0);
            if (string3 != null && string3.length() > 0) {
                string3 = string3.substring(1, string3.length() - 1);
            }
            if (string3 != null && string3.length() > 0 && string3.trim().startsWith("map[") && string3.length() > 4 && (n2 = (stringTokenizer = new StringTokenizer(string3 = string3.substring(4, string3.length() - 1), ":")).countTokens()) > 1) {
                for (int i = 0; i < n2; ++i) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4 == null || string4.indexOf("/") <= 0) continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4 = string4.substring(0, string4.indexOf("/")));
                    int n3 = stringTokenizer2.countTokens();
                    if (n3 > 1) {
                        for (int j = 0; j < n3; ++j) {
                            String string5 = stringTokenizer2.nextToken();
                            if (j != n3 - 1) continue;
                            arrayList.add(string5);
                        }
                    } else {
                        arrayList.add(string4);
                    }
                    n = Integer.parseInt(string4);
                    return n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        if (arrayList.size() > 0) {
            n = Integer.parseInt(this.getHighPriorityPort(arrayList));
        }
        return n;
    }

    public int getPodPort(String string) {
        int n = 0;
        try {
            String string2;
            String string3 = "docker inspect --format=\"{{.Config.Labels}}\" " + string;
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string3);
            ArrayList arrayList2 = null;
            if (arrayList != null && arrayList.size() > 0) {
                arrayList2 = (ArrayList)arrayList.get(0);
            }
            if ((string2 = (String)arrayList2.get(0)) != null && string2.length() > 0) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (string2 != null && (string2 = string2.trim()).startsWith("map[") && string2.endsWith("]")) {
                string2 = string2.substring(4, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                while (stringTokenizer.hasMoreTokens()) {
                    int n2;
                    String string4;
                    String string5;
                    String string6 = stringTokenizer.nextToken();
                    if (string6 == null || string6.indexOf(":") <= 0) continue;
                    int n3 = string6.indexOf(":");
                    String string7 = string6.substring(0, n3);
                    String string8 = string6.substring(n3 + 1);
                    if (string7.equalsIgnoreCase("io.kubernetes.pod.name")) {
                        string5 = string8;
                    }
                    if (!string7.equalsIgnoreCase("annotation.io.kubernetes.container.ports") || (string5 = string8) == null || string5.indexOf("\"containerPort\":") < 0 || (string4 = string5.substring((n2 = string5.indexOf("\"containerPort\":")) + 16)) == null || string4.indexOf(",") <= 0) continue;
                    String string9 = string4.substring(0, string4.indexOf(","));
                    n = Integer.parseInt(string9);
                    return n;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    private String getHighPriorityPort(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.contains("443")) {
                return "443";
            }
            if (arrayList.contains("8080")) {
                return "8080";
            }
            return (String)arrayList.get(0);
        }
        return "0000";
    }

    public boolean isContainerZ() {
        return this.isDockerContainer() || this.isCrioContainer() || this.isPodmanContainer();
    }

    public static void main(String[] stringArray) {
    }
}

