/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.ClientSocketHandler;
import com.eg.apm.MessageHandler;

public class DiscoverMessageHandler
implements MessageHandler {
    @Override
    public boolean handleMessage(String messageString, Object outputStream, ClientSocketHandler clientSocketHandler) {
        this.validateDiscoveredGuid(messageString, outputStream, clientSocketHandler);
        return false;
    }

    boolean validateDiscoveredGuid(String tempComponentGuid, Object outputStream, ClientSocketHandler clientSocketHandler) {
        APMComponentIDRepository componentIDRepository = APMComponentIDRepository.getRepository();
        if (componentIDRepository.isThisManaged(tempComponentGuid)) {
            String managedComponentGuid = componentIDRepository.getComponentGuidFromTemp(tempComponentGuid);
            if (managedComponentGuid != null && managedComponentGuid.length() > 0) {
                clientSocketHandler.sendResponseToProfiler("COMPONENT_DISCOVERD_" + managedComponentGuid, outputStream, tempComponentGuid);
            }
            clientSocketHandler.sleep(100L);
            return true;
        }
        APMComponent component = componentIDRepository.getAPMComponent(tempComponentGuid);
        if (component != null && component.isNewlyDiscoverd()) {
            if (component.isDiscoveredDetailsFinalaized()) {
                clientSocketHandler.sendResponseToProfiler("DISCOVERY_DETAILS_FINALIZED", outputStream, tempComponentGuid);
            } else if (component.isDiscoveredDetailsStored()) {
                clientSocketHandler.sendResponseToProfiler("DISCOVERY_DETAILS_RECEIVED", outputStream, tempComponentGuid);
            } else {
                clientSocketHandler.sendResponseToProfiler("OK", outputStream, tempComponentGuid);
            }
            return true;
        }
        clientSocketHandler.sendResponseToProfiler("OK", outputStream, tempComponentGuid);
        return true;
    }
}

