/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.PortDiscovery;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.Container;
import com.eg.apm.ContainerInstanceFactory;
import com.eg.apm.K8sSpecHandler;
import com.eg.apm.KubernetesAPI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;

public class ContainerzDiscovery {
    private String timeOut;
    private int lngRunCon = 7;
    private static final String loggerDispStr = "[ContainerzDiscovery]";
    private String time_limit = "";
    public static Hashtable<String, Hashtable> uploadedContainerData = new Hashtable();
    public static Hashtable<String, Integer> uploadCounter = new Hashtable();

    public Hashtable getContainerDetails() {
        try {
            Container container = ContainerInstanceFactory.getInstance().getContainerInstance();
            if (container == null) {
                APMDiscoveryLogger.discoveryLogger.debug("{} Unable to get CRIOContainers Object : {} ", (Object)loggerDispStr, (Object)container);
                return null;
            }
            APMDiscoveryLogger.discoveryLogger.debug("{} getContainerDetails()  isCRIOServer  : {} ", (Object)loggerDispStr, (Object)container.isCrioContainer());
            if (!container.isContainerZ()) {
                APMDiscoveryLogger.discoveryLogger.debug("{} CRIO server not found, Skiping port discovery process : {} ", (Object)loggerDispStr);
                return null;
            }
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = this.getSelectedCompTypes();
            hashtable = container.getRunningContainerIpDetails();
            hashtable2 = container.getContainerPortDetails();
            APMDiscoveryLogger.discoveryLogger.debug("{} getContainerDetails() - discovery selected components : {},  container ipMap : {}, container portMap : {}  ", new Object[]{loggerDispStr, hashtable3, hashtable, hashtable2});
            if (hashtable != null && hashtable2 != null) {
                try {
                    Iterator iterator = hashtable.entrySet().iterator();
                    while (iterator.hasNext()) {
                        try {
                            Map.Entry entry = iterator.next();
                            String string = (String)entry.getKey();
                            if (this.isAlreadyDiscoveredUploaded(string)) continue;
                            String string2 = (String)entry.getValue();
                            String string3 = (String)hashtable2.get(string);
                            String string4 = "";
                            String string5 = "";
                            String string6 = "";
                            APMDiscoveryLogger.discoveryLogger.trace("{} getContainerDetails() - conId : {}, conIp : {}, conport : {}  ", new Object[]{loggerDispStr, string, string2, string3});
                            if (hashtable3 != null && hashtable3.size() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && !string3.trim().equalsIgnoreCase("null")) {
                                string2 = string2.trim();
                                string3 = string3.trim();
                                string4 = this.discoverComponent(hashtable3, string2, string3);
                            }
                            string5 = container.getPodName(string);
                            string6 = container.getPodNameSpaceName(string);
                            APMDiscoveryLogger.discoveryLogger.trace("{} getContainerDetails() - podName : {}, compType : {}, podNameSpace :{} ", new Object[]{loggerDispStr, string5, string4, string6});
                            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                            if (string6 != null && string6.length() > 0) {
                                hashtable4.put("nameSpace", string6);
                            }
                            if (string5 == null || string5.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                            hashtable4.put("compType", string4);
                            hashtable4.put("compIp", string2);
                            hashtable4.put("compId", string);
                            hashtable4.put("compPort", string3);
                            hashtable4.put("podName", string5);
                            concurrentHashMap.put(string, hashtable4);
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to preapare contaiener data .. {}", (Object)loggerDispStr, (Object)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred  {}", (Object)loggerDispStr, (Object)exception);
                }
            }
            if (concurrentHashMap.size() > 0) {
                APMDiscoveryLogger.discoveryLogger.trace("{} before discovering/filtering spec info  : {} ", (Object)loggerDispStr, concurrentHashMap);
                KubernetesAPI.createInstance().discoverSpecInfo(concurrentHashMap, "nameSpace", "podName");
                K8sSpecHandler.getInstance().filterOutWithSpecInfo(concurrentHashMap);
                this.updateServiceName(concurrentHashMap);
                APMDiscoveryLogger.discoveryLogger.debug("{} Discovered CRIO host container details : {} ", (Object)loggerDispStr, concurrentHashMap);
                return new Hashtable(concurrentHashMap);
            }
            APMDiscoveryLogger.discoveryLogger.info("{} Discovered CRIO host container details :  No data found to report", (Object)loggerDispStr);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
        return null;
    }

    private void updateServiceName(ConcurrentHashMap concurrentHashMap) {
        if (concurrentHashMap == null) {
            return;
        }
        if (!ApmConfigManager.getInstance().isK8ServiceNameDiscoveryEnabled()) {
            APMDiscoveryLogger.discoveryLogger.trace("{}  Kubernetes service name discovery disabled, Skipping updateServiceName() process", (Object)loggerDispStr);
            return;
        }
        KubernetesAPI kubernetesAPI = KubernetesAPI.createInstance();
        Iterator iterator = concurrentHashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Hashtable hashtable = (Hashtable)entry.getValue();
                String string2 = (String)hashtable.get("nameSpace");
                String string3 = (String)hashtable.get("podName");
                String string4 = (String)hashtable.get("compId");
                if (string3 == null || string2 == null) {
                    APMDiscoveryLogger.discoveryLogger.debug("{}  Not enough data found to do Kubernetes Service Name Discovery : Namespace - {}, Pod - {}, Container ID : {}", new Object[]{loggerDispStr, string2, string3, string4});
                    continue;
                }
                ArrayList arrayList = kubernetesAPI.getLabelNameFromPod(string2, string3);
                APMDiscoveryLogger.discoveryLogger.debug("{}  Doing Kubernetes Service Name Discovery for Namespace - {}, Pod - {}, Container ID : {}, labelList : {}", new Object[]{loggerDispStr, string2, string3, string4, arrayList});
                if (arrayList == null || arrayList.size() <= 0) continue;
                String string5 = "";
                try {
                    string5 = kubernetesAPI.getServiceName(string2, arrayList, (String)hashtable.get("compPort"));
                    APMDiscoveryLogger.discoveryLogger.trace("{}  serviceName : {}, Pod - {}, Container ID : {}", new Object[]{loggerDispStr, string5, string3, string4});
                    if (string5 == null || string5.length() <= 0) continue;
                    hashtable.put("serviceName", string5);
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do port finding : ", (Object)loggerDispStr, (Object)exception);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            }
        }
    }

    public String discoverComponent(Hashtable hashtable, String string, String string2) {
        String string3;
        block7: {
            string3 = null;
            try {
                if (!hashtable.containsKey(string2)) break block7;
                Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
                APMDiscoveryLogger.discoveryLogger.debug("{} discoverComponent() - discoverCompPort : {}, discoverCompIp : {}, compoents : {}  ", new Object[]{loggerDispStr, string2, string, hashtable2});
                PortDiscovery portDiscovery = new PortDiscovery();
                if (hashtable2 == null) break block7;
                int n = hashtable2.size();
                Enumeration enumeration = hashtable2.keys();
                block2: while (enumeration.hasMoreElements()) {
                    String string4;
                    String[] stringArray;
                    String string5 = (String)enumeration.nextElement();
                    APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - discoverCompPort : {}, discoverCompIp : {}, compType : {}  ", new Object[]{loggerDispStr, string2, string, string5});
                    String[] stringArray2 = new String[]{""};
                    if (string5 == null) continue;
                    ArrayList arrayList = (ArrayList)hashtable2.get(string5);
                    APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - discoverCompPort : {}, discoverCompIp : {}, compType : {} al_discDetails : {}, compSize : {} ", new Object[]{loggerDispStr, string2, string, string5, arrayList, n});
                    if (arrayList == null || arrayList.size() < 2) continue;
                    String string6 = (String)arrayList.get(0);
                    String string7 = (String)arrayList.get(1);
                    if (n == 1) {
                        string3 = string5;
                        break;
                    }
                    APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - discoverCompPort : {}, discoverCompIp : {}, compType : {} strcompPorts : {}, discoveryMethod : {} ", new Object[]{loggerDispStr, string2, string, string5, string7, string6});
                    if (string6.equalsIgnoreCase("PortDiscovery")) {
                        stringArray = new String[]{string5, "-timeout " + this.timeOut + " -server " + string5 + " -hostIp " + string + " -hostName " + string + " -port " + string7 + " -fromAgentDiscovery true -isPortBased true -isNonPortBased true -isDependencyBased false"};
                        stringArray2 = portDiscovery.startTest(stringArray[1]);
                        APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - portdiscovery portdiscovery: {} ", (Object)loggerDispStr, (Object)string2);
                    } else {
                        stringArray = "com.eg." + string6;
                        string4 = "-timeout " + this.timeOut + " -server " + string5 + " -hostIp " + string + " -hostName " + string + " -port " + string7;
                        string4 = string4 + "  -fromAgentDiscovery true -isPortBased true -isNonPortBased true -isDependencyBased false";
                        String[] stringArray3 = new String[]{stringArray, string4};
                        APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - arg1 : {} - arg2: {} ", new Object[]{loggerDispStr, stringArray, string4});
                        stringArray2 = this.loadDiscoverClass(stringArray3);
                        APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - arg1 {} - finaldiscoverOutput: {} ", new Object[]{loggerDispStr, stringArray, stringArray2});
                    }
                    if (stringArray2 == null || stringArray2.length < 2) continue;
                    for (int i = 1; i < stringArray2.length; ++i) {
                        string4 = stringArray2[i];
                        APMDiscoveryLogger.discoveryLogger.trace("{} discoverComponent() - discoverOutput line: {} ", (Object)loggerDispStr, (Object)string4);
                        if (string4 == null) continue;
                        if (string4.indexOf(":") <= 0) continue block2;
                        string3 = string4.substring(0, string4.indexOf(":"));
                        continue block2;
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        return string3;
    }

    public String[] loadDiscoverClass(String[] stringArray) {
        String[] stringArray2 = new String[]{""};
        try {
            Class<?> clazz = Class.forName(stringArray[0]);
            Object obj = clazz.newInstance();
            Method method = this.findDiscoverMethod(clazz);
            Object[] objectArray = new String[]{stringArray[1]};
            Object object = method.invoke(obj, objectArray);
            stringArray2 = (String[])object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            APMDiscoveryLogger.discoveryLogger.debug("{} loadDiscoverClass() Exception occurred.. {}", (Object)loggerDispStr, (Object)classNotFoundException.getMessage());
        }
        catch (Throwable throwable) {
            APMDiscoveryLogger.discoveryLogger.warn("{} loadDiscoverClass() Exception occurred.. {}", (Object)loggerDispStr, (Object)throwable);
        }
        return stringArray2;
    }

    public Method findDiscoverMethod(Class clazz) {
        try {
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals("startTest")) continue;
                return methodArray[i];
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
        return null;
    }

    public Hashtable getSelectedCompTypes() {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String[] stringArray = iniFile.getLinesUnderSubject("CONTAINER-ENV_AUTODISCOVERY_COMPONENT_TYPES");
        IniFile iniFile2 = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_agentTests.ini");
        this.timeOut = iniFile2.getValue("AGENT_SETTINGS", "DiscTimeout");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        Hashtable hashtable = this.getComponentWithPort(arrayList);
        return hashtable;
    }

    private Hashtable getComponentWithPort(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            Hashtable hashtable2;
            String string = (String)arrayList.get(i);
            if (string == null || string.length() == 0 || string.toLowerCase().startsWith("format") || string.startsWith("#") || string == null || string.indexOf("=") <= 0) continue;
            String string2 = "-port";
            int n = string.indexOf("=");
            ArrayList arrayList2 = new ArrayList();
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 1, string.indexOf(","));
            String string5 = string.substring(string.toLowerCase().indexOf("-port") + string2.length());
            if (string4 == null || string4.equalsIgnoreCase("NoDiscovery") || string5 == null || string5.equalsIgnoreCase("null")) continue;
            if ((string5 = string5.trim()).indexOf(":") > 0) {
                hashtable2 = new StringTokenizer(string5, ":");
                while (((StringTokenizer)((Object)hashtable2)).hasMoreTokens()) {
                    ArrayList<String> arrayList3;
                    Hashtable<String, ArrayList<String>> hashtable3;
                    object = ((StringTokenizer)((Object)hashtable2)).nextToken();
                    if (object == null) continue;
                    if (hashtable.containsKey(object)) {
                        hashtable3 = (Hashtable<String, ArrayList<String>>)hashtable.get(object);
                        if (hashtable3 == null) {
                            hashtable3 = new Hashtable<String, ArrayList<String>>();
                        }
                        arrayList3 = new ArrayList(2);
                        arrayList3.add(string4);
                        arrayList3.add(string5);
                        hashtable3.put(string3, arrayList3);
                        hashtable.put(object, hashtable3);
                        continue;
                    }
                    hashtable3 = new Hashtable<String, ArrayList<String>>();
                    arrayList3 = new ArrayList<String>(2);
                    arrayList3.add(string4);
                    arrayList3.add(string5);
                    hashtable3.put(string3, arrayList3);
                    hashtable.put(object, hashtable3);
                }
                continue;
            }
            if (hashtable.containsKey(string5)) {
                hashtable2 = (Hashtable)hashtable.get(string5);
                if (hashtable2 == null) {
                    hashtable2 = new Hashtable();
                }
                object = new ArrayList<String>(2);
                ((ArrayList)object).add(string4);
                ((ArrayList)object).add(string5);
                hashtable2.put(string3, object);
                hashtable.put(string5, hashtable2);
                continue;
            }
            hashtable2 = new Hashtable();
            object = new ArrayList(2);
            ((ArrayList)object).add(string4);
            ((ArrayList)object).add(string5);
            hashtable2.put(string3, object);
            hashtable.put(string5, hashtable2);
        }
        return hashtable;
    }

    public void addToDiscoveredData(Hashtable hashtable) {
        try {
            if (uploadedContainerData != null && hashtable != null) {
                System.out.println(uploadedContainerData.size());
                System.out.println(uploadCounter.size());
                if (uploadedContainerData.size() > 200 || uploadCounter.size() > 200) {
                    uploadedContainerData.clear();
                    uploadCounter.clear();
                    APMDiscoveryLogger.discoveryLogger.trace("{} Counter cleared.... {}", (Object)loggerDispStr);
                }
                uploadedContainerData.putAll(hashtable);
                this.addToUploadCounter(hashtable);
                APMDiscoveryLogger.discoveryLogger.trace("{} uploadedContainerData : {}, uploadCounter : {}", new Object[]{loggerDispStr, uploadedContainerData, uploadCounter});
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void addToUploadCounter(Hashtable hashtable) {
        try {
            if (uploadCounter != null && hashtable != null) {
                for (Map.Entry entry : hashtable.entrySet()) {
                    String string = (String)entry.getKey();
                    Integer n = uploadCounter.get(string);
                    if (n == null) {
                        uploadCounter.put(string, 1);
                        continue;
                    }
                    int n2 = n;
                    if (n2 <= 0) continue;
                    uploadCounter.put(string, n2 + 1);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private boolean isAlreadyDiscoveredUploaded(String string) {
        try {
            int n;
            Integer n2;
            if (uploadCounter != null && (n2 = uploadCounter.get(string)) != null && (n = n2.intValue()) >= 3) {
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception occurred.. {}", (Object)loggerDispStr, (Object)exception);
        }
        return false;
    }
}

