/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.AgentStartupLogger;
import com.eg.jtm.BTMConstants;
import java.io.File;

public final class BTMOffloadAPMSocketConfiguration {
    private static final String NODEJS_AGENT_SERVER_SOCKET_PORTNO = "NodeJSAgentServerSocketPortNo";
    public static final String NODEJS_AGENT_SERVER_SOCKET_PORT_ORDER = "NodeJSAgentServerSocketPortOrder";
    private static final int DEFAULT_AGENT_NODEJS_SERVER_SOCKET_PORT = 23700;
    private static final String[] DEFAULT_AGENT_NODEJS_SERVER_SOCKET_PORT_ORDER = new String[]{"21700", "22700", "23700", "24700", "25700", "26700", "27700", "28700", "29700", "30700"};
    private static String[] NODEJS_SERVER_SOCKET_PORT_ORDER = new String[]{"21700", "22700", "23700", "24700", "25700", "26700", "27700", "28700", "29700", "30700"};
    private static final int DEFAULT_AGENT_JAVA_SERVER_SOCKET_PORT = 13700;
    private static final String[] DEFAULT_AGENT_JAVA_SERVER_SOCKET_PORT_ORDER = new String[]{"11700", "12700", "13700", "14700", "15700", "16700", "17700", "18700", "19700", "20700"};
    private static String[] JAVA_SERVER_SOCKET_PORT_ORDER = new String[]{"11700", "12700", "13700", "14700", "15700", "16700", "17700", "18700", "19700", "20700"};
    static final String AGENT_SOCKET_SETTINGS_SECTION = "AGENT_SOCKET_SETTINGS";
    private static final String AGENT_SERVER_SOCKET_PORTNO = "AgentServerSocketPortNo";
    private static final String AGENT_SERVER_SOCKET_IP = "AgentServerSocketIP";
    static final String AGENT_SOCKET_PORT_ORDER = "AgentServerSocketPortOrder";
    private static final String AGENT_OFFLOAD_QUEUE_SIZE_KEY = "AgentOffloadQueueSize";
    private static final String AGENT_OFFLOAD_WORKERS_KEY = "AgentOffloadWorkers";
    private static final String OpenBTMOffloadPortInAgent = "OpenBTMOffloadPortInAgent";
    private static final String CheckUpdatesForOpenBTMOffloadPortInAgent = "CheckUpdatesForOpenBTMOffloadPortInAgent";
    private static final String BindBTMOffloadPortToLocalhostOnly = "BindBTMOffloadPortToLocalhostOnly";
    private static final String AGENT_SERVER_SOCKET_TIMEOUT = "AgentServerSocketTimeout";
    private static final String CreateBTMJarZipFileOnAgent = "CreateBTMJarZipFileOnAgent";
    private static final int DEFAULT_CHECK_INTERVAL = 15;
    private static final int DEFAULT_AGENT_OFFLOAD_WORKERS = 5;
    private static final int DEFAULT_AGENT_OFFLOAD_QUEUE_SIZE = 100000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private String iniFileName;
    private boolean OpenOffloadPort = false;
    private int configuredCheckInterval = 15;
    private int queuesize = 100000;
    private int workers = 5;
    private int configuredPort = -1;
    private String configuredIP = "127.0.0.1";
    private String customConfiguredIP = "127.0.0.1";
    private boolean isCustomIPAvailable = false;
    private boolean isCustomPortAvailable = false;
    private boolean isLocalHostIP = false;
    private boolean bindLocalHostOnly = false;
    private String portDecidedFrom = "default";
    private String ipDecidedFrom = "default";
    private int socketTimeOut = 1000;
    private int configuredNodePort = -1;
    private String logPrefix = " [" + this.getClass().getName() + "] ";
    private static BTMOffloadAPMSocketConfiguration btmConfig = null;
    private static long lastModifiedTime = -1L;

    private BTMOffloadAPMSocketConfiguration(String iniFileName) {
        this.iniFileName = iniFileName;
        this.updateConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTMOffloadAPMSocketConfiguration getBTMOffloadAPMSocketConfiguration(String iniFileName) {
        if (btmConfig == null) {
            Class<BTMOffloadAPMSocketConfiguration> clazz = BTMOffloadAPMSocketConfiguration.class;
            synchronized (BTMOffloadAPMSocketConfiguration.class) {
                if (btmConfig == null) {
                    btmConfig = new BTMOffloadAPMSocketConfiguration(iniFileName);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else {
            btmConfig.updateConfiguration(true);
        }
        return btmConfig;
    }

    public boolean isOpenOffloadPort() {
        return this.OpenOffloadPort;
    }

    public int getCheckInterval() {
        if (this.configuredCheckInterval > 0) {
            return this.configuredCheckInterval;
        }
        return 15;
    }

    public int getOffloadWorkers() {
        if (this.workers > 0) {
            return this.workers;
        }
        return 5;
    }

    public int getQueueSize() {
        if (this.queuesize > 0) {
            return this.queuesize;
        }
        return 100000;
    }

    public boolean isBindLocalHostOnly() {
        return this.bindLocalHostOnly;
    }

    public int getSocketTimeOut() {
        if (this.socketTimeOut > -1) {
            return this.socketTimeOut;
        }
        return 1000;
    }

    public int getOffloadJavaServerSocketPort() {
        if (this.configuredPort > 0) {
            return this.configuredPort;
        }
        return 13700;
    }

    public int getOffloadNodeServerSocketPort() {
        if (this.configuredNodePort > 0) {
            return this.configuredNodePort;
        }
        return 23700;
    }

    public String getOffloadServerSocketIP() {
        return this.configuredIP;
    }

    public String getCustomOffloadServerSocketIP() {
        return this.customConfiguredIP;
    }

    public boolean isOffloadServerSocketIPLocal() {
        return this.isLocalHostIP;
    }

    public boolean isCustomIPAvailable() {
        return this.isCustomIPAvailable;
    }

    public boolean isCustomPortAvailable() {
        return this.isCustomPortAvailable;
    }

    private void updateConfiguration(boolean checkForUpdate) {
        boolean iniUpdated = false;
        String iniFilePath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + this.iniFileName;
        long lastModified = IniFile.getLastModified(iniFilePath);
        if (lastModifiedTime > -1L) {
            if (lastModified != lastModifiedTime) {
                iniUpdated = true;
                lastModifiedTime = lastModified;
            }
        } else {
            lastModifiedTime = lastModified;
            iniUpdated = true;
        }
        AgentStartupLogger.logger.trace("{} {} iniUpdated :  {} , currentModifiedTime : {}, lastModifiedTime: {}", new Object[]{this.logPrefix, this.iniFileName, iniUpdated, lastModified, lastModifiedTime});
        if (iniUpdated) {
            this.updateConfiguration();
        }
    }

    private void updateConfiguration() {
        String offloadNodePort;
        String socketTimeout;
        String bindLocalhostOnly;
        String bindIP;
        String offloadPort;
        String workerSize;
        String queueSize;
        String flagValue;
        String iniFilePath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + this.iniFileName;
        AgentStartupLogger.logger.trace("{} Reading BTM offload socket configuration from {}", (Object)this.logPrefix, (Object)iniFilePath);
        IniFile IniFileObj = new IniFile(iniFilePath);
        String flagStatus = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, OpenBTMOffloadPortInAgent);
        flagStatus = flagStatus.trim();
        if (flagStatus != null && flagStatus.length() > 0) {
            this.OpenOffloadPort = flagStatus.equalsIgnoreCase("true") || flagStatus.equalsIgnoreCase("yes");
        }
        if ((flagValue = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, CheckUpdatesForOpenBTMOffloadPortInAgent)) != null && flagValue.length() > 0) {
            try {
                this.configuredCheckInterval = Integer.parseInt(flagValue);
            }
            catch (Exception e) {
                this.configuredCheckInterval = 15;
                AgentStartupLogger.logger.warn("{} Given CheckUpdatesForOpenBTMOffloadPortInAgent is invalid. So, using default value {} ", (Object)this.logPrefix, (Object)15);
            }
        }
        if ((queueSize = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_OFFLOAD_QUEUE_SIZE_KEY)) != null && queueSize.length() > 0) {
            try {
                this.queuesize = Integer.parseInt(queueSize);
                if (this.queuesize <= 0) {
                    this.queuesize = 100000;
                }
            }
            catch (Exception e) {
                this.queuesize = 100000;
                AgentStartupLogger.logger.warn("{} Given Agent offload queue size is invalid. So, using default queue size : {}", (Object)this.logPrefix, (Object)100000);
            }
        }
        if ((workerSize = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_OFFLOAD_WORKERS_KEY)) != null && workerSize.length() > 0) {
            try {
                this.workers = Integer.parseInt(workerSize);
                if (this.workers <= 0) {
                    this.workers = 5;
                } else if (this.workers >= 25) {
                    AgentStartupLogger.logger.error("{} Given Agent offload workers count[{}] is greater than 25, It will cause eG Agent to get CPU Spike. So, using default workers: {}.\n \t\t\t\t\t\t Please give worker count value in eg_tests.ini in manager config under [AGENT_SOCKET_SETTINGS] section, AgentOffloadWorkers=50 or \n \t\t\t\t\t\t Please ensure that AGENT SOCKET SETTINGS discovery info getting downloaded in proper order... ", new Object[]{this.logPrefix, this.workers, 5});
                    this.workers = 5;
                }
            }
            catch (Exception e) {
                this.workers = 5;
                AgentStartupLogger.logger.warn("{} Given Agent offload workers count is invalid. So, using default workers: {}", (Object)this.logPrefix, (Object)5);
            }
        }
        if ((offloadPort = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SERVER_SOCKET_PORTNO)) != null && offloadPort.length() > 0) {
            try {
                int validport = Integer.parseInt(offloadPort);
                if (validport <= 0) {
                    AgentStartupLogger.logger.warn("{}  Given Offload server socket port {}  is invalid.", (Object)this.logPrefix, (Object)validport);
                } else {
                    this.configuredPort = validport;
                    this.setPortDecidedFrom("INI File - agentTests.ini");
                }
            }
            catch (Exception e) {
                AgentStartupLogger.logger.warn("{}  Given Offload server socket port {}  is invalid.", (Object)this.logPrefix, (Object)offloadPort);
            }
        }
        if ((bindIP = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SERVER_SOCKET_IP)) != null && bindIP.length() > 0) {
            this.configuredIP = bindIP.trim();
            if (this.configuredIP.equalsIgnoreCase("localhost") || this.configuredIP.equalsIgnoreCase("127.0.0.1")) {
                this.isLocalHostIP = true;
            }
            this.setIpDecidedFrom("INI File - agentTests.ini");
        }
        String customPort = null;
        customPort = System.getenv("EG_JAVA_PROFILER_PORT");
        if (customPort != null && customPort.trim().length() > 0) {
            this.setPortDecidedFrom("Environment variable : variable name = EG_JAVA_PROFILER_PORT");
        } else {
            customPort = System.getProperty("eg.java.profiler.port");
            if (customPort != null && customPort.trim().length() > 0) {
                this.setPortDecidedFrom("System property : property-name = eg.java.profiler.port");
            }
        }
        if (!this.isCustomPortAvailable && customPort != null && customPort.trim().length() > 0) {
            this.configuredPort = Integer.parseInt(customPort.trim());
            this.isCustomPortAvailable = true;
            AgentStartupLogger.logger.warn("{} INFO:- APM - BTM Offload Server Socket Port found from {} ", (Object)this.logPrefix, (Object)this.configuredPort);
        }
        if (!this.isCustomPortAvailable) {
            String customIniPath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + "eg_apm_custom.ini";
            IniFile customIniFileObj = new IniFile(customIniPath);
            customPort = customIniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SERVER_SOCKET_PORTNO);
            AgentStartupLogger.logger.info("{} Custom Offload server socket Port from eg_apm_custom.ini: {}  ", (Object)this.logPrefix, (Object)customPort);
            if (customPort != null && customPort.trim().length() > 0) {
                this.configuredPort = Integer.parseInt(customPort.trim());
                this.setPortDecidedFrom("INI File - eg_apm_custom.ini - sub: AGENT_SOCKET_SETTINGS - key : AgentServerSocketPortNo - value : " + customPort);
                this.isCustomPortAvailable = true;
            }
        }
        if ((bindLocalhostOnly = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, BindBTMOffloadPortToLocalhostOnly)) != null && bindLocalhostOnly.length() > 0) {
            this.bindLocalHostOnly = bindLocalhostOnly.equalsIgnoreCase("true") || bindLocalhostOnly.equalsIgnoreCase("yes");
        }
        if ((socketTimeout = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SERVER_SOCKET_TIMEOUT)) != null && socketTimeout.length() > 0) {
            try {
                this.socketTimeOut = Integer.parseInt(socketTimeout);
            }
            catch (Exception e) {
                AgentStartupLogger.logger.warn("{}  Given Offload server socket timeout {}  is invalid.", (Object)this.logPrefix, (Object)socketTimeout);
                this.socketTimeOut = 1000;
            }
        }
        if ((offloadNodePort = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, NODEJS_AGENT_SERVER_SOCKET_PORTNO)) != null && offloadNodePort.length() > 0) {
            try {
                int validport = Integer.parseInt(offloadNodePort);
                if (validport <= 0) {
                    AgentStartupLogger.logger.warn("{}  Specified NodeJS Offload server socket port is invalid {} ", (Object)this.logPrefix, (Object)validport);
                } else {
                    this.configuredNodePort = validport;
                }
            }
            catch (Exception e) {
                AgentStartupLogger.logger.warn("{}  Specified NodeJS Offload server socket port is invalid {} ", (Object)this.logPrefix, (Object)offloadNodePort);
            }
        }
        String javaPortList = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SOCKET_PORT_ORDER);
        try {
            String[] javaPorts;
            if (javaPortList != null && javaPortList.length() > 0 && (javaPorts = javaPortList.split(",")) != null && javaPorts.length > 0) {
                JAVA_SERVER_SOCKET_PORT_ORDER = javaPorts;
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("{}  Specified Java Port list is invalid {}  ", (Object)this.logPrefix, (Object)javaPortList);
        }
        String nodeJsPortList = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, NODEJS_AGENT_SERVER_SOCKET_PORT_ORDER);
        try {
            String[] nodeJsPorts;
            if (nodeJsPortList != null && nodeJsPortList.length() > 0 && (nodeJsPorts = nodeJsPortList.split(",")) != null && nodeJsPorts.length > 0) {
                NODEJS_SERVER_SOCKET_PORT_ORDER = nodeJsPorts;
            }
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("{}  Specified NodeJS port list is invalid {}  ", (Object)this.logPrefix, (Object)nodeJsPortList);
        }
        this.updateCustomSocketSetting();
        this.printConfigs();
    }

    private void printConfigs() {
        if (AgentStartupLogger.logger.isDebugEnabled()) {
            AgentStartupLogger.logger.debug("{} current configurations : {} ", (Object)this.logPrefix, (Object)this.toString());
        }
    }

    private void updateCustomSocketSetting() {
        try {
            String customIp = null;
            customIp = System.getenv("EG_JAVA_PROFILER_IP");
            if (customIp != null && customIp.trim().length() > 0) {
                this.setIpDecidedFrom("Environment variable : variable name = EG_JAVA_PROFILER_IP");
            } else {
                customIp = System.getenv("EG_HOST_IP");
                if (customIp != null && customIp.trim().length() > 0) {
                    this.setIpDecidedFrom("Environment variable : variable name = EG_HOST_IP");
                } else {
                    customIp = System.getProperty("eg.java.profiler.ip");
                    if (customIp != null && customIp.trim().length() > 0) {
                        this.setIpDecidedFrom("System property : property-name = eg.java.profiler.ip");
                    } else {
                        customIp = System.getProperty("eG_BTM_Server_Socket_Bind_IP");
                        if (customIp != null && customIp.trim().length() > 0) {
                            this.setIpDecidedFrom("System property : property-name = eG_BTM_Server_Socket_Bind_IP");
                        }
                    }
                }
            }
            if (!this.isCustomIPAvailable && customIp != null && customIp.trim().length() > 0) {
                this.customConfiguredIP = customIp.trim();
                this.isCustomIPAvailable = true;
                AgentStartupLogger.logger.warn("{} INFO:- APM - BTM Offload Server Socket IP found in ENV variable: {}  ", (Object)this.logPrefix, (Object)this.customConfiguredIP);
            }
            if (!this.isCustomIPAvailable) {
                String iniFilePath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_CONFIG_FOLDER + File.separator + "eg_apm_custom.ini";
                IniFile IniFileObj = new IniFile(iniFilePath);
                String bindIP = IniFileObj.getValue(AGENT_SOCKET_SETTINGS_SECTION, AGENT_SERVER_SOCKET_IP);
                AgentStartupLogger.logger.info("{} Custom Offload server socket IP bindIP from eg_apm_custom.ini: {}  ", (Object)this.logPrefix, (Object)bindIP);
                if (bindIP != null && bindIP.length() > 0) {
                    this.customConfiguredIP = bindIP.trim();
                    this.isCustomIPAvailable = true;
                    this.setIpDecidedFrom("INI File : eg_apm_custom.ini");
                    AgentStartupLogger.logger.warn("{} INFO:- APM - BTM Offload Server Socket IP found in eg_apm_custom.ini file: {}  ", (Object)this.logPrefix, (Object)this.customConfiguredIP);
                }
            }
            AgentStartupLogger.logger.info("{} isCustomIPAvailable - {}, customConfiguredIP : {}  ", new Object[]{this.logPrefix, this.isCustomIPAvailable, this.customConfiguredIP});
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("{}  Unable to update custom socket settings: {}  ", (Object)this.logPrefix, (Object)e);
        }
    }

    public String[] getOffloadJavaPortList() {
        if (JAVA_SERVER_SOCKET_PORT_ORDER != null && JAVA_SERVER_SOCKET_PORT_ORDER.length > 0) {
            return JAVA_SERVER_SOCKET_PORT_ORDER;
        }
        return DEFAULT_AGENT_JAVA_SERVER_SOCKET_PORT_ORDER;
    }

    public String[] getOffloadNodePortList() {
        if (NODEJS_SERVER_SOCKET_PORT_ORDER != null && NODEJS_SERVER_SOCKET_PORT_ORDER.length > 0) {
            return NODEJS_SERVER_SOCKET_PORT_ORDER;
        }
        return DEFAULT_AGENT_NODEJS_SERVER_SOCKET_PORT_ORDER;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BTMOffloadAPMSocketConfiguration [iniFileName=");
        builder.append(this.iniFileName);
        builder.append(", OpenOffloadPort=");
        builder.append(this.OpenOffloadPort);
        builder.append(", configuredCheckInterval=");
        builder.append(this.configuredCheckInterval);
        builder.append(", queuesize=");
        builder.append(this.queuesize);
        builder.append(", workers=");
        builder.append(this.workers);
        builder.append(", configuredPort=");
        builder.append(this.configuredPort);
        builder.append(", configuredIP=");
        builder.append(this.configuredIP);
        builder.append(", customConfiguredIP=");
        builder.append(this.customConfiguredIP);
        builder.append(", isCustomIPAvailable=");
        builder.append(this.isCustomIPAvailable);
        builder.append(", isLocalHostIP=");
        builder.append(this.isLocalHostIP);
        builder.append(", bindLocalHostOnly=");
        builder.append(this.bindLocalHostOnly);
        builder.append(", socketTimeOut=");
        builder.append(this.socketTimeOut);
        builder.append(", configuredNodePort=");
        builder.append(this.configuredNodePort);
        builder.append(", logPrefix=");
        builder.append(this.logPrefix);
        builder.append("]");
        return builder.toString();
    }

    public String getPortDecidedFrom() {
        return this.portDecidedFrom;
    }

    public void setPortDecidedFrom(String portDecidedFrom) {
        this.portDecidedFrom = portDecidedFrom;
    }

    public String getIpDecidedFrom() {
        return this.ipDecidedFrom;
    }

    public void setIpDecidedFrom(String ipDecidedFrom) {
        this.ipDecidedFrom = ipDecidedFrom;
    }
}

