/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMConfigUtils;
import com.eg.apm.APMFileOperations;
import com.eg.apm.JavaBTMLogger;
import com.eg.jtm.BTMConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.configuration.PropertiesConfiguration;

public class BTMConfigWriter {
    private static final String loggerPrefix = " [BTMConfigWriter] - ";
    private static final String COMPONENT_GUIDNODE_ID = "COMPONENT_GUIDNODE_ID";
    private static final String apmIniPath = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apm.ini";
    private static final String apmConfigFile = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/config/eg_apmconfig.ini";
    private static final String AGENT_APM_GUID_FILEPATH = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.AGENT_APM_GUID_FILEPATH;
    private static final String DEFAULT = "Default";
    private static final String DELETE_TEXT = "_delete";
    private static final String pipePercentEscape = "%\\|%";
    private static final String pipeEscape = "~\\|~";
    private static final String NameEscape = "\\#NAME\\#";
    private static final String capEscape = "\\^";
    private static final String appendSeparator = "~%!~";
    private static final String appendRecordDelimiter = "~\\%\\!~";
    private static final String delimiter = "~|~";
    private static final String percentEscape = "~\\%~";
    private static BTMConfigWriter instance = null;
    APMFileOperations apmfileOperation = new APMFileOperations();
    private static final String EG_LOGBACK_PROPS_FILEPATH = String.valueOf(EgInstallInfo.getInstallDir()) + File.separator + "lib" + File.separator + "eg_logback.properties";
    private static final String DONOT_ADD_TO_GUID_PROPS = "DONOT_ADD_TO_GUID_PROPS";

    public void btmConfigAgentWriter(TreeSet componentGuid) {
        try {
            JavaBTMLogger.btmLogger.trace("{} componentGuid {}", (Object)loggerPrefix, (Object)componentGuid);
            this.apmfileOperation.createDirectory(BTMConstants.BTM_CONFIG_DIR_PATH);
            this.apmfileOperation.createDirectory(BTMConstants.NODEJS_CONFIG_DIR_PATH);
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} conf directory creation error {}", (Object)loggerPrefix, (Object)e);
        }
        try {
            this.getEgApmConfigIni(componentGuid);
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} btmConfigAgentWriter error {}", (Object)loggerPrefix, (Object)e);
        }
    }

    private String getTemplateValues(String section, String variable) {
        String teplateValues = null;
        try {
            String template = this.getTemplate(section, variable);
            if (template != null) {
                String[] teplateArray = template.split(pipePercentEscape);
                teplateValues = teplateArray[0];
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method getTemplateValues error {}", (Object)loggerPrefix, (Object)e);
        }
        return teplateValues;
    }

    private String[] getTemplateKeys(String section, String variable) {
        String[] templateKeys = null;
        try {
            String template = this.getTemplate(section, variable);
            if (template != null) {
                template = template.replaceAll(NameEscape, variable);
                String[] teplateArray = template.split(pipePercentEscape);
                templateKeys = teplateArray[1].split(pipeEscape);
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method getTemplateKeys error {}", (Object)loggerPrefix, (Object)e);
        }
        return templateKeys;
    }

    private String getTemplate(String section, String variable) {
        String template = null;
        try {
            IniFile apmIniFileObj = new IniFile(apmIniPath);
            template = apmIniFileObj.getValue(section, variable);
            if (template != null && template.equals("")) {
                template = apmIniFileObj.getValue(section, DEFAULT);
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method getTemplate error {}", (Object)loggerPrefix, (Object)e);
        }
        return template;
    }

    private HashMap getNodeIdByGuid(TreeSet componentGuid) {
        HashMap<String, String> guidWithNodeId = new HashMap<String, String>();
        try {
            IniFile apmIni = new IniFile(AGENT_APM_GUID_FILEPATH);
            String[] guidLines = apmIni.getLinesUnderSubject("APM_GUID_MAPPING_WITH_NICK");
            if (guidLines != null && guidLines.length > 0) {
                int i = 0;
                while (i < guidLines.length) {
                    String dataLine = guidLines[i];
                    int index = dataLine.indexOf("=");
                    if (index >= 0) {
                        String[] compValue;
                        String var = dataLine.substring(0, index);
                        String guid = dataLine.substring(index + 1);
                        if (componentGuid.contains(guid) && var != null && (compValue = var.split(capEscape)).length == 4) {
                            StringBuffer buffer = new StringBuffer();
                            buffer.append("[");
                            buffer.append(compValue[0]);
                            buffer.append(":");
                            buffer.append(compValue[2]);
                            buffer.append(":");
                            buffer.append(compValue[3]);
                            buffer.append("]");
                            guidWithNodeId.put(guid, buffer.toString());
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Exception Occured Getting data from:", (Object)loggerPrefix, (Object)e);
        }
        return guidWithNodeId;
    }

    private void getEgApmConfigIni(TreeSet componentGuid) {
        try {
            IniFile guidFileObj = new IniFile(apmConfigFile);
            HashMap guidWithNodeId = this.getNodeIdByGuid(componentGuid);
            ArrayList donotAddToGuidProps = this.getDoNotAddToGuidPropsList();
            String[] arrayOfString = guidFileObj.getSubjects();
            for (String GUID : componentGuid) {
                String[] confDirWithnickWithPort = this.getCommonGuidConfigDir(guidWithNodeId, GUID);
                String confDir = confDirWithnickWithPort[0];
                String nickWithPort = confDirWithnickWithPort[1];
                TreeMap map = new TreeMap();
                String[] stringArray = arrayOfString;
                int n = arrayOfString.length;
                int n2 = 0;
                while (n2 < n) {
                    String subjectTitle = stringArray[n2];
                    String[] lines = guidFileObj.getLinesUnderSubject(subjectTitle);
                    TreeMap subjectMap = new TreeMap();
                    this.processApmConfigIni(lines, GUID, subjectMap, confDir, subjectTitle);
                    if (subjectMap.size() > 0) {
                        map.put(subjectTitle, subjectMap);
                    }
                    ++n2;
                }
                this.saveProperty(map, GUID, guidWithNodeId, confDir, nickWithPort, donotAddToGuidProps);
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Unable to get getEgApmConfigIni details for {}", (Object)loggerPrefix, (Object)e);
        }
    }

    private void processApmConfigIni(String[] lines, String GUID, TreeMap subjectMap, String confDir, String subjectTitle) {
        try {
            if (lines != null && lines.length > 0) {
                int j = 0;
                while (j < lines.length) {
                    String line = lines[j];
                    int compIndex = line.indexOf(GUID);
                    if (compIndex > -1) {
                        int equalIndex = line.indexOf("=");
                        String deleteText = "";
                        if (equalIndex > 0) {
                            String[] valueList;
                            if (line.indexOf(appendSeparator) != -1) {
                                String IDSList;
                                valueList = line.substring(equalIndex + 1).split(appendRecordDelimiter);
                                StringBuffer buffer = new StringBuffer();
                                String prefix = "";
                                int index = 1;
                                while (index < valueList.length) {
                                    String value = valueList[index];
                                    if (index == 1 && !(prefix = valueList[1].substring(0, 3)).endsWith("_")) {
                                        prefix = String.valueOf(prefix) + "_";
                                    }
                                    String keyId = value.substring(0, value.indexOf(delimiter));
                                    String keyValue = value.substring(value.indexOf(delimiter) + 3, value.length());
                                    StringBuffer uvalue = new StringBuffer();
                                    uvalue.append(subjectTitle).append(".").append(keyId).append(deleteText);
                                    subjectMap.put(uvalue.toString(), keyValue);
                                    if (buffer.length() > 0) {
                                        buffer.append(delimiter);
                                    }
                                    buffer.append(keyId);
                                    ++index;
                                }
                                StringBuffer propsKey = new StringBuffer();
                                propsKey.append(subjectTitle).append(".").append(prefix).append("IDS");
                                String IdList = this.getGuidPropsValue(GUID, confDir, propsKey.toString());
                                if (IdList != null && !IdList.equalsIgnoreCase("")) {
                                    if (IdList.indexOf(buffer.toString()) == -1) {
                                        StringBuffer idBuffer = new StringBuffer();
                                        idBuffer.append(IdList).append(delimiter).append(buffer.toString());
                                        IdList = idBuffer.toString();
                                    }
                                } else {
                                    IdList = buffer.toString();
                                }
                                if ((IDSList = this.getIDSUnique(IdList)).length() == 0) {
                                    propsKey.append(DELETE_TEXT);
                                    StringBuffer idBuffer = new StringBuffer();
                                    idBuffer.append(IDSList).append(DELETE_TEXT);
                                    subjectMap.put(propsKey.toString(), idBuffer.toString());
                                } else {
                                    subjectMap.put(propsKey.toString(), IDSList);
                                }
                            } else {
                                valueList = line.substring(equalIndex + 1).split(percentEscape);
                                String templateValues = this.getTemplateValues(valueList[0], subjectTitle);
                                String[] templateKeys = this.getTemplateKeys(valueList[0], subjectTitle);
                                String[] values = valueList[1].split(pipeEscape);
                                if (templateValues.equalsIgnoreCase(valueList[1])) {
                                    deleteText = DELETE_TEXT;
                                }
                                int index = 0;
                                while (index < templateKeys.length) {
                                    StringBuffer buffer = new StringBuffer();
                                    buffer.append(templateKeys[index]).append(deleteText);
                                    subjectMap.put(buffer.toString(), values[index]);
                                    ++index;
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method processApmConfigIni error {}", (Object)loggerPrefix, (Object)e);
        }
    }

    private void saveProperty(TreeMap data, String GUID, HashMap guidWithNodeId, String confDir, String nickWithPort, ArrayList donotAddToGuidProps) {
        String guidPropsfilePath = "";
        if (data == null || data.isEmpty()) {
            return;
        }
        try {
            if (confDir != null) {
                guidPropsfilePath = new StringBuffer().append(confDir).append(GUID.replaceAll(":", "_")).append(".props").toString();
                this.createFileIfNotExist(guidPropsfilePath);
                PropertiesConfiguration config = new PropertiesConfiguration(guidPropsfilePath);
                config.setProperty("COMPONENT_GUID", (Object)GUID);
                config.setProperty("NODE_ID", (Object)nickWithPort);
                PropertiesConfiguration egLogBackconfig = new PropertiesConfiguration(EG_LOGBACK_PROPS_FILEPATH);
                for (String keySubject : data.keySet()) {
                    if (donotAddToGuidProps.indexOf(keySubject) != -1) {
                        this.updateGuidProps(data, keySubject, GUID, egLogBackconfig, confDir, false);
                        continue;
                    }
                    this.updateGuidProps(data, keySubject, GUID, config, confDir, true);
                }
                config.save();
                egLogBackconfig.save();
                String allPropsKeyValue = this.getAllPropsKeys(guidPropsfilePath);
                if (allPropsKeyValue.equalsIgnoreCase(COMPONENT_GUIDNODE_ID)) {
                    this.apmfileOperation.deleteFile(guidPropsfilePath);
                }
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Exception while write the property {} due to {}", new Object[]{loggerPrefix, guidPropsfilePath, e});
        }
    }

    private String[] getCommonGuidConfigDir(HashMap guidWithNodeId, String GUID) {
        String compTypewithNodeId;
        String[] confDirWithnickWithPort;
        block6: {
            confDirWithnickWithPort = new String[2];
            compTypewithNodeId = (String)guidWithNodeId.get(GUID);
            if (compTypewithNodeId != null && compTypewithNodeId.length() != 0) break block6;
            return null;
        }
        try {
            confDirWithnickWithPort[0] = BTMConstants.BTM_CONFIG_DIR_PATH;
            int idx = compTypewithNodeId.indexOf(":");
            if (idx > 0) {
                String compType = compTypewithNodeId.substring(0, idx);
                if (compType.startsWith("[")) {
                    compType = compType.substring(1);
                    if ((compType = compType.trim()).equalsIgnoreCase("NodeJS")) {
                        confDirWithnickWithPort[0] = BTMConstants.NODEJS_CONFIG_DIR_PATH;
                    }
                }
                confDirWithnickWithPort[1] = "[" + compTypewithNodeId.substring(idx + 1);
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Exception while retriving the common guid conf dir {} due to {}", new Object[]{loggerPrefix, GUID, e});
        }
        return confDirWithnickWithPort;
    }

    private boolean createFileIfNotExist(String filePathName) {
        boolean result = false;
        try {
            File file = new File(filePathName);
            if (!file.exists()) {
                file.createNewFile();
                result = true;
            } else {
                result = true;
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method createFileIfNotExist error {}", (Object)loggerPrefix, (Object)e);
        }
        return result;
    }

    private void updateGuidProps(TreeMap data, String keySubject, String GUID, PropertiesConfiguration propertiesConfig, String confDir, boolean delete) {
        try {
            TreeMap valueMap = (TreeMap)data.get(keySubject);
            if (valueMap != null && valueMap.size() > 0) {
                for (String key : valueMap.keySet()) {
                    String value = (String)valueMap.get(key);
                    if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
                    if (delete) {
                        if (key.indexOf(DELETE_TEXT) != -1) {
                            key = key.substring(0, key.indexOf(DELETE_TEXT));
                            propertiesConfig.clearProperty(key);
                            continue;
                        }
                        propertiesConfig.setProperty(key, (Object)value);
                        continue;
                    }
                    String logsKey = key.substring(0, key.lastIndexOf("."));
                    propertiesConfig.setProperty(logsKey, (Object)value);
                }
                APMConfigUtils.getInstance().processApmConfigIni(GUID, false, keySubject, confDir, "agent");
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method defineSubjectByElements error {}", (Object)loggerPrefix, (Object)e);
        }
    }

    private String getAllPropsKeys(String propertyFilePath) {
        StringBuffer buffer = new StringBuffer();
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(propertyFilePath);
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                buffer.append((String)keys.next());
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Exception while read the property due to {}", (Object)loggerPrefix, (Object)e);
        }
        return buffer.toString();
    }

    private String getGuidPropsValue(String componentId, String confDir, String key) {
        String value = "";
        try {
            String propertyFilePath = new StringBuffer().append(confDir).append(componentId.replaceAll(":", "_")).append(".props").toString();
            PropertiesConfiguration config = new PropertiesConfiguration(propertyFilePath);
            value = config.getString(key);
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} Exception while read the property due to {}", (Object)loggerPrefix, (Object)e);
        }
        return value;
    }

    private String getIDSUnique(String IDS) {
        StringBuffer buffer = new StringBuffer();
        try {
            ArrayList<String> deleteList = new ArrayList<String>();
            String[] idList = IDS.split(pipeEscape);
            TreeSet<String> setIDs = new TreeSet<String>();
            int index = 0;
            while (index < idList.length) {
                if (idList[index].indexOf(DELETE_TEXT) != -1) {
                    deleteList.add(idList[index].substring(0, idList[index].indexOf(DELETE_TEXT)));
                }
                setIDs.add(idList[index]);
                ++index;
            }
            for (String value : setIDs) {
                if (value.indexOf(DELETE_TEXT) != -1 || deleteList.contains(value)) continue;
                if (buffer.length() > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(value);
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method getIDSUnique error {}", (Object)loggerPrefix, (Object)e);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BTMConfigWriter getInstance() {
        if (instance != null) return instance;
        Class<BTMConfigWriter> clazz = BTMConfigWriter.class;
        synchronized (BTMConfigWriter.class) {
            if (instance != null) return instance;
            instance = new BTMConfigWriter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ArrayList getDoNotAddToGuidPropsList() {
        ArrayList<String> doNotAddList = new ArrayList<String>();
        try {
            IniFile apmIniFileObj = new IniFile(apmIniPath);
            String[] doNotAddLines = apmIniFileObj.getLinesUnderSubject(DONOT_ADD_TO_GUID_PROPS);
            if (doNotAddLines != null && doNotAddLines.length > 0) {
                ArrayList<String> doNotSubject = new ArrayList<String>();
                int i = 0;
                while (i < doNotAddLines.length) {
                    String dataLine = doNotAddLines[i];
                    int index = dataLine.indexOf("=");
                    if (index != -1) {
                        String key = dataLine.substring(0, index);
                        String value = dataLine.substring(index + 1);
                        if (value.toLowerCase().equalsIgnoreCase("true")) {
                            doNotSubject.add(key);
                        }
                    }
                    ++i;
                }
                int sindex = 0;
                while (sindex < doNotSubject.size()) {
                    String[] doNotVariables = apmIniFileObj.getVariables(doNotSubject.get(sindex).toString());
                    doNotAddList.addAll(Arrays.asList(doNotVariables));
                    ++sindex;
                }
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} method getDoNotAddToGuidPropsList error {}", (Object)loggerPrefix, (Object)e);
        }
        return doNotAddList;
    }
}

