/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMLanguage;
import com.eg.apm.AppTierName;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APMWorkerHelper {
    private static final APMWorkerHelper instance = new APMWorkerHelper();
    private ConcurrentHashMap<String, Integer> autoNameMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> computedNodeOrders = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AppTierName> appTierNameTable = new ConcurrentHashMap();

    private APMWorkerHelper() {
    }

    public static APMWorkerHelper getInstance() {
        return instance;
    }

    void clearRepository(APMComponent component) {
        String componentID = component.getID();
        String nick = component.getNickWithPort();
        this.autoNameMap.remove(componentID);
        this.autoNameMap.remove(nick);
        this.computedNodeOrders.remove(componentID);
        this.computedNodeOrders.remove(nick);
        int count = 0;
        APMLanguage language = component.getAPMLanguage();
        if (!component.isEntityExists(language.getBusinessTransTestName())) {
            component.removeEntity(language.getBusinessTransTestName());
            ++count;
        }
        if (!component.isEntityExists(language.getKeyBusinessTransTestName())) {
            component.removeEntity(language.getKeyBusinessTransTestName());
            ++count;
        }
        if (count == 2) {
            component.reset();
        }
    }

    Integer getRequestCount(String keyString) {
        return this.autoNameMap.get(keyString);
    }

    void addToAutoNameMap(String keyString, Integer count) {
        this.autoNameMap.put(keyString, count);
    }

    void removeFromAutoNameMap(String keyString) {
        this.autoNameMap.remove(keyString);
    }

    public ConcurrentHashMap<String, Integer> getAutoNameMap() {
        return this.autoNameMap;
    }

    public ConcurrentHashMap<String, String> getComputedNodeOrders() {
        return this.computedNodeOrders;
    }

    public void addEntryIntoComputedNodeOrders(String nodeOrder) {
        this.computedNodeOrders.put(nodeOrder, nodeOrder);
    }

    boolean isAvilableInComputedNodeOrders(String nodeOrder) {
        return this.computedNodeOrders.containsKey(nodeOrder);
    }

    public ConcurrentHashMap getAppTierNameTable() {
        return this.appTierNameTable;
    }

    public boolean IsThisAvailableInAppTierNameTable(String key) {
        return this.appTierNameTable.containsKey(key);
    }

    AppTierName getAppTierObject(String nodeID) {
        return this.appTierNameTable.get(nodeID);
    }

    public void addNewComponentForAppTierName(String nodeID, String componentType) {
        AppTierName appTierObject = new AppTierName();
        appTierObject.setComponentType(componentType);
        this.appTierNameTable.put(nodeID, appTierObject);
    }

    public void setAppTierNames(String nodeID, String appName, String tierName) {
        AppTierName appTierObject = this.appTierNameTable.get(nodeID);
        if (appTierObject != null) {
            appTierObject.setAppName(appName);
            appTierObject.setTierName(tierName);
        }
    }

    public String toString() {
        return "APMWorkerHelper [autoNameMap=" + this.autoNameMap + ", computedNodeOrders=" + this.computedNodeOrders + ", appTierNameTable=" + this.appTierNameTable + "]";
    }
}

