/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class EgCreateTrigger
extends EgConfigInfo {
    static String entity = "setup_manager";
    private EgConfigInfo configInfo = new EgConfigInfo("manager");
    File file;
    Connection conn = null;
    String host;
    String sid;
    String port;
    String sql;
    String url;
    String user;
    String password;
    String pathDir;
    String ntlmV2;
    public String errorMsg = " ";
    static IniFile iniFile;
    static IniFile iniDBFile;
    public String dbDriver;
    public String dbUrl;
    ResultSet rs = null;
    Properties p_testNames;
    String[] s_a_testNames;
    int i_count = 0;

    public static void main(String[] stringArray) {
        System.setProperty("jsse.enableCBCProtection", "false");
        if (stringArray.length != 14) {
            System.out.println("Please pass 14 arguments to execute ...! ");
            return;
        }
        if (!(stringArray[0].equals("-host") && stringArray[2].equals("-port") && stringArray[4].equals("-sid") && stringArray[6].equals("-user") && stringArray[8].equals("-password") && stringArray[10].equals("-dir") && stringArray[12].equals("-ntlmv2"))) {
            System.out.println("Usage java EgCreateTrigger -host <hostname>  -port <portNo> -sid<Database Instance Name> -user <DbUser>  -password <UserPasswd> -dir <source dir of SQL Files> -ntlmv2 <true / false>");
            return;
        }
        EgCreateTrigger egCreateTrigger = new EgCreateTrigger(stringArray);
        if (!egCreateTrigger.deployTriggers()) {
            System.out.println(egCreateTrigger.errorMsg);
        } else {
            System.out.println("TRUE");
        }
    }

    public void createSetupFile() {
        iniFile = new IniFile(this.configInfo.getSetupFile());
        iniDBFile = new IniFile(this.configInfo.getDbFile());
        this.loadTestNames();
    }

    public EgCreateTrigger(String[] stringArray) {
        this.host = stringArray[1];
        this.port = stringArray[3];
        this.sid = stringArray[5];
        this.user = stringArray[7];
        this.password = stringArray[9];
        this.pathDir = stringArray[11];
        this.ntlmV2 = stringArray[13];
        this.file = new File(this.pathDir);
        this.createSetupFile();
    }

    public EgCreateTrigger(Connection connection, String string) {
        this.conn = connection;
        this.file = new File(string);
        this.createSetupFile();
    }

    public boolean deployTriggers() {
        return this.deployTriggers(null);
    }

    public boolean deployTriggers(String string) {
        boolean bl = false;
        if (this.conn == null) {
            bl = true;
            if (!this.connect()) {
                return false;
            }
        }
        try {
            File[] fileArray = this.file.listFiles();
            if (fileArray.length == 0) {
                this.logToErrorFile(entity, this.pathDir + " doesn't have any .sql files");
                this.errorMsg = this.pathDir + "doesn't have any .sql files";
                if (bl) {
                    this.closeConnection();
                }
                return false;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getPath();
                if (!string2.endsWith(".sql")) continue;
                Vector vector = this.getData(string2);
                if (vector == null) {
                    this.logToErrorFile(entity, this.pathDir + string2 + " doesn't exist ..");
                    this.errorMsg = this.errorMsg + string2 + " doesn't exist ..";
                    if (bl) {
                        this.closeConnection();
                    }
                    return false;
                }
                int n = vector.size();
                Statement statement = null;
                for (int j = 0; j < n; ++j) {
                    String string3 = (String)vector.get(j);
                    String string4 = this.conn.nativeSQL(string3);
                    string4 = string4.replace('#', ' ');
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        statement = this.conn.prepareStatement(string4);
                        this.rs = statement.executeQuery();
                        int n2 = 0;
                        while (this.rs.next()) {
                            boolean bl2;
                            ++n2;
                            this.sql = this.rs.getString("EG_TRIG_LIST");
                            this.sql = this.getProperSql(this.sql);
                            if (this.sql == null || (bl2 = this.executeAllTrigger(this.sql, this.conn, string))) continue;
                            if (bl) {
                                this.closeConnection();
                            }
                            return false;
                        }
                        statement.close();
                        this.rs.close();
                        continue;
                    }
                    catch (SQLException sQLException) {
                        this.errorMsg = sQLException.toString();
                        string4 = string4.trim();
                        SQLException sQLException2 = sQLException;
                        return false;
                    }
                }
            }
            if (bl) {
                this.closeConnection();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorMsg = "Error when building the query ...";
            if (bl) {
                this.closeConnection();
            }
            return false;
        }
        return true;
    }

    boolean executeAllTrigger(String string, Connection connection, String string2) {
        if (string.equals("") || string == null) {
            return false;
        }
        if (string2 != null && string.toLowerCase().indexOf(string2.toLowerCase()) < 0) {
            return true;
        }
        string = string.replace('/', ' ');
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeQuery(string);
            statement.close();
            return true;
        }
        catch (Exception exception) {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            System.out.println(exception);
            exception.printStackTrace();
            return false;
        }
    }

    private String getProperSql(String string) {
        int n;
        int n2 = string.lastIndexOf(",");
        String string2 = string.substring(n2 + 2, n = string.lastIndexOf(":"));
        String string3 = this.getProperTestName(string2);
        if (string3 == null) {
            return null;
        }
        string2 = "'" + string2 + "'";
        string3 = "'" + string3 + "'";
        string = this.replace(string, string2, string3);
        ++this.i_count;
        return string;
    }

    private String replace(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) == -1) continue;
            String string4 = string.substring(0, n);
            string4 = string4 + string3;
            string = string4 = string4 + string.substring(n + string2.length());
        } while (n != -1);
        return string;
    }

    private void loadTestNames() {
        String string = this.configInfo.getThresholdsFile("manager");
        IniFile iniFile = new IniFile(string);
        this.s_a_testNames = iniFile.getVariables("DEFAULT_THRESHOLDS");
    }

    private String getProperTestName(String string) {
        for (int i = 0; i < this.s_a_testNames.length; ++i) {
            if (!this.s_a_testNames[i].equalsIgnoreCase(string)) continue;
            return this.s_a_testNames[i];
        }
        return null;
    }

    void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            this.conn = null;
        }
        catch (Exception exception) {
            this.errorMsg = "Error when closing the database connection ...";
            return;
        }
    }

    public void getInfo() {
        try {
            this.dbDriver = iniDBFile.getValue("DB_PROPERTIES", "sql.driver");
            this.dbUrl = iniDBFile.getValue("DB_PROPERTIES", "sql.url");
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
    }

    boolean connect() {
        try {
            this.getInfo();
            Class.forName(this.dbDriver).newInstance();
            if (this.password.equals("NULL") || this.password.equals("null") || this.password.equals("none") || this.password.equals("NONE")) {
                this.password = "";
            }
            String string = "";
            int n = this.user.indexOf("\\");
            if (n < 0) {
                n = this.user.indexOf("/");
            }
            if (n < 0) {
                this.conn = DriverManager.getConnection(this.dbUrl, this.user, this.password);
            } else {
                string = this.user.substring(0, n);
                this.user = this.user.substring(n + 1);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", string);
                if (this.ntlmV2 != null && this.ntlmV2.equals("true")) {
                    properties.put("useNTLMv2", this.ntlmV2);
                }
                this.conn = DriverManager.getConnection(this.dbUrl, properties);
            }
        }
        catch (Exception exception) {
            this.errorMsg = "Database connection failed ...";
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public Vector getData(String string) {
        BufferedReader bufferedReader = null;
        Object var3_3 = null;
        boolean bl = true;
        String string2 = " Null";
        String string3 = "";
        boolean bl2 = false;
        Vector<String> vector = new Vector<String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || (string3 = string3 + " " + string2).indexOf("#") == -1) continue;
                vector.addElement(string3);
                string3 = "";
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }
}

