/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class CitrixXenServerHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private int timeOut;
    private PrintWriter pw;
    private BufferedReader br;
    public boolean done;
    public boolean ssl;
    public boolean isXen = false;

    public CitrixXenServerHelperThread(String string, int n, int n2, boolean bl) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = n2;
        this.ssl = bl;
        this.setName("CitrixXenServerHelperThread");
        this.setDaemon(true);
        this.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        if (this.ssl) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                Object var3_9 = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                URL uRL = null;
                HttpsURLConnection httpsURLConnection = null;
                try {
                    uRL = new URL("https://" + this.hostIp + ":" + this.portNo);
                    httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                    httpsURLConnection.setDoInput(true);
                    httpsURLConnection.setUseCaches(false);
                    int n = httpsURLConnection.getContentLength();
                    if (n <= 0) return;
                    try {
                        String string;
                        this.br = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
                        while ((string = this.br.readLine()) != null) {
                            if (string.indexOf("<address>Xapi Server</address>") < 0 && string.indexOf("XenServer") < 0) continue;
                            this.isXen = true;
                            break;
                        }
                        this.done = true;
                        this.cleanup();
                        return;
                    }
                    catch (Exception exception) {
                        this.done = true;
                        this.cleanup();
                        return;
                    }
                }
                catch (Exception exception) {
                    this.done = true;
                    this.cleanup();
                }
                return;
            }
            catch (Exception exception) {
                this.done = true;
                this.cleanup();
                return;
            }
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.done = true;
            this.cleanup();
            return;
        }
        try {
            this.pw = new PrintWriter(this.sd.getOutputStream(), false);
            this.pw.print("GET / HTTP/1.0\r\n\r\n");
            this.pw.flush();
            this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
            if (this.br != null) {
                String string = this.br.readLine();
                while (string != null) {
                    try {
                        if (string.indexOf("<address>Xapi Server</address>") >= 0 || string.indexOf("XenServer") >= 0) {
                            this.isXen = true;
                            break;
                        }
                        string = this.br.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
            }
            this.done = true;
            this.cleanup();
            return;
        }
        catch (Exception exception) {
            this.done = true;
            this.cleanup();
        }
    }

    public void cleanup() {
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

