/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ZoneDiskSpaceTest
extends GenericTest {
    ZoneHelper znh = ZoneHelper.getInstance();
    ZoneMonitor zoneMon = null;
    public String prefix = "sudo";

    public ZoneDiskSpaceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        String string = this.getValueForParam("connect_using");
        if (string != null && string.length() > 0) {
            this.prefix = string;
        }
        this.zoneMon = ZoneMonitor.getInstance(this.prefix);
    }

    public void computeMeasures(Hashtable hashtable) {
        Object var2_2 = null;
        ArrayList arrayList = null;
        arrayList = this.zoneMon.getAllZoneList();
        this.parse(arrayList);
    }

    public void parse(ArrayList arrayList) {
        String string = null;
        ArrayList arrayList2 = null;
        if (arrayList == null || arrayList.size() <= 0) {
            System.out.println("[ZoneDiskSpaceTest] failed to get zone's info");
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Zones zones = (Zones)arrayList.get(i);
            boolean bl = false;
            string = ZoneCommands.getZoneTestCommands(zones, 1, this.prefix);
            ArrayList arrayList3 = ZoneHelper.getCommandOutput(string);
            int n = arrayList3 != null && arrayList3.size() > 0 ? arrayList3.size() : 0;
            System.out.println("[ZoneDiskSpaceTest] output of  the " + zones.getZoneName() + "'s  command  is " + string + " ");
            if (arrayList3 == null || arrayList3.size() == 0) continue;
            for (int j = 0; j < n; ++j) {
                StringTokenizer stringTokenizer;
                String string2 = (String)arrayList3.get(j);
                long l = 0L;
                long l2 = 0L;
                if (string2.startsWith("Filesystem") || (stringTokenizer = new StringTokenizer(string2)).countTokens() != 6) continue;
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                try {
                    l2 = Long.parseLong(stringTokenizer.nextToken().trim());
                    l = Long.parseLong(stringTokenizer.nextToken().trim());
                }
                catch (Exception exception) {
                    continue;
                }
                string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                if (string5.indexOf("cdrom") >= 0 || string5.indexOf("/dev/fd") >= 0 || string5.indexOf("/mnt/floppy") >= 0 || l2 + l == 0L) continue;
                double d = (double)l2 / (double)(l2 + l);
                d *= 100.0;
                ArrayList<Double> arrayList4 = new ArrayList<Double>();
                double d2 = (double)(l2 + l) / 1024.0;
                string = ZoneCommands.getCommondirs(zones.getZoneName() + "");
                arrayList2 = ZoneHelper.getCommandOutput(string);
                arrayList4.add(new Double(d2));
                d2 = (double)l2 / 1024.0;
                arrayList4.add(new Double(d2));
                d2 = (double)l / 1024.0;
                arrayList4.add(new Double(d2));
                d2 = d;
                arrayList4.add(new Double(d2));
                String string6 = zones.getZoneName() + ":" + string5;
                bl = string6 != null && string6.startsWith("running") ? false : this.isDuplicate(arrayList2, string5);
                if (bl) continue;
                this.addNewMeasure(string6, arrayList4);
            }
        }
    }

    public boolean isDuplicate(ArrayList arrayList, String string) {
        if (arrayList == null || arrayList.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i).toString().trim();
            if (string.indexOf(string2) < 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        ZoneDiskSpaceTest zoneDiskSpaceTest = new ZoneDiskSpaceTest(stringArray);
        try {
            while (true) {
                zoneDiskSpaceTest.computeMeasures(new Hashtable());
                Thread.currentThread();
                Thread.sleep(10000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exceptione ==>" + exception);
            return;
        }
    }
}

