/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class WinNetworkTrafficTest
extends GenericTest {
    private EgUtilities egutil = null;
    private static final String command = "netstat -i";
    private String itfCmd = "sudo entstat ";
    private static final double BToMb = 7.62939453125E-6;
    private Hashtable prev_txBytes = new Hashtable();
    private Hashtable prev_rxBytes = new Hashtable();
    private Hashtable prev_txErrors = new Hashtable();
    private Hashtable prev_rxErrors = new Hashtable();

    public WinNetworkTrafficTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            ArrayList arrayList;
            if (this.meAgentless) {
                return;
            }
            if (this.egutil == null) {
                this.egutil = EgUtilities.createInstance();
            }
            if ((arrayList = this.egutil.getExecOutputLines(command)) == null || arrayList.size() < 2) {
                this.prev_txBytes = new Hashtable();
                this.prev_rxBytes = new Hashtable();
                this.prev_txErrors = new Hashtable();
                this.prev_rxErrors = new Hashtable();
                return;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                this.prev_txBytes = new Hashtable();
                this.prev_rxBytes = new Hashtable();
                this.prev_txErrors = new Hashtable();
                this.prev_rxErrors = new Hashtable();
                return;
            }
            ArrayList arrayList3 = this.getInterfaceNameList(arrayList2);
            if (arrayList3 == null || arrayList3.size() == 0) {
                this.prev_txBytes = new Hashtable();
                this.prev_rxBytes = new Hashtable();
                this.prev_txErrors = new Hashtable();
                this.prev_rxErrors = new Hashtable();
                return;
            }
            int n = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                Serializable serializable;
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = -5.0;
                String string = (String)arrayList3.get(i);
                ArrayList arrayList4 = this.getInterfaceDataList(this.itfCmd + string);
                if (arrayList4 == null || arrayList4.size() < 6) continue;
                double d7 = (Double)arrayList4.get(0);
                double d8 = (Double)arrayList4.get(1);
                double d9 = (Double)arrayList4.get(2);
                double d10 = (Double)arrayList4.get(3);
                double d11 = (Double)arrayList4.get(4);
                double d12 = (Double)arrayList4.get(5);
                if (d7 >= 0.0 && (d = this.getDiffMeasure(d7, (Double)(serializable = (Double)this.prev_rxBytes.get(string)))) >= 0.0 && this.timeSinceLastTest > 0.0) {
                    d = d * 7.62939453125E-6 / this.timeSinceLastTest;
                }
                if (d9 >= 0.0 && (d3 = this.getDiffMeasure(d9, (Double)(serializable = (Double)this.prev_txBytes.get(string)))) > 0.0 && this.timeSinceLastTest > 0.0) {
                    d3 = d3 * 7.62939453125E-6 / this.timeSinceLastTest;
                }
                if (d8 >= 0.0) {
                    serializable = (Double)this.prev_rxErrors.get(string);
                    d2 = this.getDiffMeasure(d8, (Double)serializable);
                }
                if (d10 >= 0.0) {
                    serializable = (Double)this.prev_txErrors.get(string);
                    d4 = this.getDiffMeasure(d10, (Double)serializable);
                }
                if (d > 0.0) {
                    d5 = d;
                }
                if (d3 > 0.0) {
                    if (d5 < 0.0) {
                        d5 = 0.0;
                    }
                    d5 += d3;
                }
                if (d5 >= 0.0 && d12 > 0.0 && (d6 = d5 / d12 * 100.0) > 100.0) {
                    d6 = 100.0;
                }
                this.prev_rxBytes.put(string, new Double(d7));
                this.prev_rxErrors.put(string, new Double(d8));
                this.prev_txBytes.put(string, new Double(d9));
                this.prev_txErrors.put(string, new Double(d10));
                serializable = new ArrayList();
                ((ArrayList)serializable).add(new Double(d));
                ((ArrayList)serializable).add(new Double(d3));
                ((ArrayList)serializable).add(new Double(d12));
                ((ArrayList)serializable).add(new Double(d6));
                ((ArrayList)serializable).add(new Double(d11));
                ((ArrayList)serializable).add(new Double(d2));
                ((ArrayList)serializable).add(new Double(d4));
                this.addNewMeasure(string, (ArrayList)serializable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList getInterfaceNameList(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                StringTokenizer stringTokenizer;
                int n2;
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.trim().length() == 0 || (string2 = string2.trim()).indexOf("Name") >= 0 || string2.indexOf("Mtu") >= 0 || string2.indexOf("Address") >= 0 || (n2 = (stringTokenizer = new StringTokenizer(string2)).countTokens()) < 9 || (string = stringTokenizer.nextToken()) == null || (string = string.trim()).length() == 0 || string.equalsIgnoreCase("lo0") || arrayList2.contains(string)) continue;
                arrayList2.add(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    private ArrayList getInterfaceDataList(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            ArrayList arrayList2 = this.egutil.getExecOutputLines(string);
            if (arrayList2 == null || arrayList2.size() < 2) {
                return arrayList;
            }
            ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
            if (arrayList3 == null || arrayList3.size() == 0) {
                return arrayList;
            }
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            double d6 = -5.0;
            int n = -1;
            int n2 = -1;
            int n3 = arrayList3.size();
            for (int i = 0; i < n3; ++i) {
                int n4;
                int n5;
                String string2 = (String)arrayList3.get(i);
                if (string2 == null || string2.trim().length() == 0) continue;
                if ((string2 = string2.trim()).indexOf("Transmit Statistics") >= 0 && string2.indexOf("Receive Statistics") >= 0) {
                    n = string2.indexOf("Transmit Statistics");
                    n2 = string2.indexOf("Receive Statistics");
                    continue;
                }
                if (string2.indexOf("Bytes") >= 0) {
                    n5 = string2.indexOf(":");
                    int n6 = string2.lastIndexOf(":");
                    n4 = string2.lastIndexOf("Bytes");
                    String string3 = string2.substring(n5 + 1, n4);
                    String string4 = string2.substring(n6 + 1);
                    if (n < n2) {
                        d = this.getDoubleValue(string3);
                        d2 = this.getDoubleValue(string4);
                        continue;
                    }
                    d2 = this.getDoubleValue(string3);
                    d = this.getDoubleValue(string4);
                    continue;
                }
                if (string2.indexOf("Transmit Errors") >= 0 && string2.indexOf("Receive Errors") >= 0) {
                    String string5;
                    String string6;
                    int n7;
                    n5 = string2.indexOf("Transmit Errors");
                    int n8 = string2.indexOf("Receive Errors");
                    n4 = string2.indexOf(":");
                    int n9 = string2.lastIndexOf(":");
                    if (n < n2) {
                        n7 = string2.indexOf("Receive");
                        string6 = string2.substring(n4 + 1, n7);
                        string5 = string2.substring(n9 + 1);
                        d3 = this.getDoubleValue(string6);
                        d4 = this.getDoubleValue(string5);
                        continue;
                    }
                    n7 = string2.indexOf("Transmit");
                    string6 = string2.substring(n4 + 1, n7);
                    string5 = string2.substring(n9 + 1);
                    d4 = this.getDoubleValue(string6);
                    d3 = this.getDoubleValue(string5);
                    continue;
                }
                if (string2.indexOf("Current S/W+H/W Transmit Queue Length") >= 0) {
                    n5 = string2.indexOf(":");
                    String string7 = string2.substring(n5 + 1);
                    d5 = this.getDoubleValue(string7);
                    continue;
                }
                if (string2.indexOf("Adapter Data Rate") < 0) continue;
                n5 = string2.indexOf(":");
                String string8 = string2.substring(n5 + 1);
                d6 = this.getDoubleValue(string8);
            }
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d6));
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return arrayList;
        }
    }

    private double getDiffMeasure(double d, Double d2) {
        double d3 = -5.0;
        try {
            if (d2 != null) {
                double d4 = d2;
                d3 = d - d4;
                d3 = d3 < 0.0 ? -5.0 : d3;
            }
            return d3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d3;
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string == null || string.trim().length() == 0) {
                return d;
            }
            string = string.trim();
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("[WinNetworkTrafficTest] Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }
}

