/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class WebServerTester
extends WebAdapterTester {
    private boolean debug = false;

    public WebServerTester(ThreadGroup threadGroup, String string, EgMainAgent egMainAgent, String string2, String string3, Long l) {
        super(threadGroup, string, "WebServerTest", egMainAgent);
        this.mgrIp = string2;
        this.mgrPortNo = string3;
    }

    public void startTester(String[] stringArray, Integer n) {
        this.measurePeriod = n;
        this.tests = new WebServerTest[stringArray.length];
        for (int i = 0; i < this.tests.length; ++i) {
            this.tests[i] = this.generateTest(stringArray[i]);
        }
        this.start();
    }

    public EgTest generateTest(String string) {
        String string2 = null;
        string = string + " -period " + this.measurePeriod / 1000;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n + 2];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("-port")) continue;
            string3 = new String(stringArray[i + 1]);
            break;
        }
        if (string3 == null) {
            return null;
        }
        String string4 = null;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("-host")) continue;
            string4 = stringArray[i + 1];
            break;
        }
        if (string4 == null) {
            return null;
        }
        if (!this.isIpAddress(string4)) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string4);
            }
            catch (UnknownHostException unknownHostException) {
                this.logToErrorFile("ERROR", this.entity, string4 + "is not a valid" + " Host Name or IpAddress ");
                return null;
            }
            string2 = inetAddress.getHostAddress();
        } else {
            string2 = string4;
        }
        stringArray[n] = "-hostIp";
        stringArray[n + 1] = string2;
        WebServerTest webServerTest = new WebServerTest(stringArray);
        webServerTest.host = string2;
        webServerTest.port = string3;
        return webServerTest;
    }

    public void run() {
        long l = -1L;
        this.initializeEgTester();
        this.reinitOnMeasurePeriodChange = true;
        while (true) {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.tests = this.updateTester(this.tests);
            if (this.tests == null) {
                System.out.println(this.entity + ": STOPPING TESTER!");
                return;
            }
            this.checkForUniqueTests(this.tests);
            for (int i = 0; i < this.tests.length; ++i) {
                if (this.tests[i] == null || !this.tests[i].isValid) continue;
                if (!this.tests[i].executeTest()) {
                    this.logToErrorFile("ERROR", this.entity, this.tests[i].errorMsg);
                }
                Enumeration enumeration = this.tests[i].results.keys();
                while (enumeration.hasMoreElements()) {
                    int n;
                    String string = (String)enumeration.nextElement();
                    EgResultSet egResultSet = (EgResultSet)this.tests[i].results.get(string);
                    String[] stringArray = this.getSiteAndInfo(egResultSet.index);
                    if (stringArray == null) continue;
                    String string2 = this.tests[i].reportingName + "\t" + this.tests[i].portNo + "\t" + stringArray[0] + "\t" + stringArray[1] + "\t" + this.tests[i].measurementHost + "\t" + this.tests[i].testDateAndTime;
                    String string3 = new String("");
                    for (n = 0; n < egResultSet.values.length; ++n) {
                        string3 = string3 + "\t" + egResultSet.values[n] + "\t" + egResultSet.thresholds[n].state;
                    }
                    string2 = string2 + string3;
                    arrayList.add(string2);
                    for (n = 0; n < this.tests.length; ++n) {
                        if (this.tests[n] == null || this.tests[n].isValid || n == i || ((WebServerTest)this.tests[n]).host == null || ((WebServerTest)this.tests[n]).port == null || !this.isMultiPortServer(((WebServerTest)this.tests[n]).host, ((WebServerTest)this.tests[n]).port, (WebAdapterTest)this.tests[i])) continue;
                        String string4 = this.tests[n].reportingName + "\t" + ((WebServerTest)this.tests[n]).port + "\t" + stringArray[0] + "\t" + stringArray[1] + "\t" + this.tests[n].measurementHost + "\t" + this.tests[i].testDateAndTime;
                        string4 = string4 + string3;
                        arrayList.add(string4);
                    }
                }
            }
            String[] stringArray = new String[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
            this.outputResults(stringArray, this.mgrIp, this.mgrPortNo);
            l = this.measurePeriod;
            this.suspendTesterForPeriod(l);
        }
    }
}

