/*
 * Decompiled with CFR 0.152.
 */
import com.eg.snmpgetsubtree;
import java.util.ArrayList;
import java.util.Hashtable;

public class WLJDBCTestUsingSNMP {
    private String mibName = "";
    private int timeOut = 10;
    private String community = "public";
    private String snmpWalkCmd = "snmpgetsubtree";
    private String snmpPortNo = "5000";
    private static String jdbcPoolNameOid = ".1.3.6.1.4.1.140.600.50.1.5";
    private static String jdbcPoolServerOid = ".1.3.6.1.4.1.140.600.50.1.10";
    private static String jdbcMaxOid = ".1.3.6.1.4.1.140.600.50.1.15";
    private static String jdbcCurrInUseOid = ".1.3.6.1.4.1.140.600.50.1.30";
    private static String jdbcPendingConnOid = ".1.3.6.1.4.1.140.600.50.1.35";
    private static String listenServerNamesOid = ".1.3.6.1.4.1.140.600.30.1.5";
    private static String listenServerPortsOid = ".1.3.6.1.4.1.140.600.30.1.20";
    private String[] lhs;
    private String[] rhs;
    private int reRun = 0;
    private int reDiscoveryCount = 12;
    String[] jdbcPoolName;
    String[] jdbcMax;
    String[] jdbcInUse;
    String[] jdbcPending;
    ArrayList serverPoolIndex;
    String serverName = null;
    String serverPortIndex = null;
    private boolean isWindowsOS = false;
    private String errorMsg = null;
    private String targetHost = null;
    private String portNo = null;
    private String siteName = null;
    private String siteAndInfoSeparator = null;
    private String infoFieldSeparator = null;
    private WLJDBCTest theTest = null;

    public WLJDBCTestUsingSNMP(WLJDBCTest wLJDBCTest, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.theTest = wLJDBCTest;
        this.targetHost = string;
        this.portNo = string2;
        this.siteName = string3;
        this.siteAndInfoSeparator = string4;
        this.infoFieldSeparator = string5;
        this.snmpPortNo = string6;
        this.community = string7;
        String string8 = System.getProperty("os.name").toLowerCase();
        if (string8.indexOf("win") >= 0) {
            this.isWindowsOS = true;
        }
    }

    public Hashtable getMeasures() {
        if (this.reRun == 0 && !this.findWlsJdbc()) {
            return null;
        }
        ++this.reRun;
        if (this.reRun > this.reDiscoveryCount) {
            this.reRun = 0;
        }
        this.findWlsJdbcEntries();
        String string = new String(this.siteName + this.siteAndInfoSeparator + this.infoFieldSeparator);
        int n = 0;
        int n2 = 0;
        if (this.serverPoolIndex == null || this.serverPoolIndex.size() == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < this.serverPoolIndex.size(); ++i) {
            String string2 = string + this.jdbcPoolName[i];
            n = this.parse(this.jdbcMax[i]);
            n2 = this.parse(this.jdbcInUse[i]);
            int n3 = this.parse(this.jdbcPending[i]);
            hashtable.put(string2, n + "," + n2 + "," + n3);
        }
        return hashtable;
    }

    public boolean findWlsJdbc() {
        this.runSnmpCmdForOid(listenServerPortsOid);
        this.serverPortIndex = this.findString(this.portNo, this.lhs, this.rhs);
        if (this.serverPortIndex == null) {
            return false;
        }
        this.runSnmpCmdForOid(listenServerNamesOid);
        this.serverName = this.findString(this.serverPortIndex, this.rhs, this.lhs);
        if (this.serverName == null) {
            return false;
        }
        this.runSnmpCmdForOid(jdbcPoolServerOid);
        this.serverPoolIndex = this.findIndexString(this.serverName, this.lhs, this.rhs);
        if (this.serverPoolIndex == null) {
            return false;
        }
        this.runSnmpCmdForOid(jdbcPoolNameOid);
        this.jdbcPoolName = this.assignValues();
        this.runSnmpCmdForOid(jdbcMaxOid);
        this.jdbcMax = this.assignValues();
        return true;
    }

    private String findString(String string, String[] stringArray, String[] stringArray2) {
        String string2 = null;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equals(stringArray2[i])) continue;
            string2 = new String(stringArray[i]);
            break;
        }
        return string2;
    }

    public ArrayList findIndexString(String string, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equals(stringArray2[i])) continue;
            arrayList.add(this.lhs[i]);
        }
        return arrayList;
    }

    public void findWlsJdbcEntries() {
        this.runSnmpCmdForOid(jdbcCurrInUseOid);
        this.jdbcInUse = this.assignValues();
        this.runSnmpCmdForOid(jdbcPendingConnOid);
        this.jdbcPending = this.assignValues();
    }

    private int parse(String string) {
        if (string == null || string.equals("")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    public String[] assignValues() {
        String[] stringArray = new String[this.serverPoolIndex.size()];
        block0: for (int i = 0; i < this.serverPoolIndex.size(); ++i) {
            for (int j = 0; j < this.lhs.length; ++j) {
                if (!this.lhs[j].equals((String)this.serverPoolIndex.get(i))) continue;
                stringArray[i] = new String(this.rhs[j]);
                continue block0;
            }
        }
        return stringArray;
    }

    public boolean runSnmpCmdForOid(String string) {
        String[] stringArray = new String[]{"-p", "" + this.snmpPortNo, "-c", this.community, "-o", "-v", "1", this.targetHost, string};
        snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeOut);
        ArrayList arrayList = snmpgetsubtree2.getSubTree();
        this.lhs = null;
        this.rhs = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.mibName = string;
        if (arrayList != null && arrayList.size() > 0) {
            int n;
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                int n3;
                String string2 = ((String)arrayList.get(n)).trim();
                if (!string2.startsWith(string) || (n3 = string2.indexOf(61)) < 0) continue;
                String string3 = string2.substring(0, n3);
                String string4 = string2.substring(n3 + 1);
                String string5 = this.replace(string3, string, "");
                if (string5.length() > 0) {
                    string5 = new String(string5.substring(1));
                }
                if (string4.startsWith("\"")) {
                    String string6;
                    int n4 = string4.lastIndexOf("\"");
                    while (n4 <= 0 && ++n < n2 && (string6 = (String)arrayList.get(n)) != null) {
                        string4 = string4 + " " + string6;
                        n4 = string4.lastIndexOf("\"");
                    }
                    string4 = new String(string4.substring(1, n4));
                }
                arrayList2.add(string4);
                arrayList3.add(string5);
            }
            Object[] objectArray = arrayList2.toArray();
            this.rhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.rhs[n] = objectArray[n].toString();
            }
            objectArray = arrayList3.toArray();
            this.lhs = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.lhs[n] = objectArray[n].toString();
            }
            return this.lhs.length > 0;
        }
        this.errorMsg = new String("Failed to run " + this.snmpWalkCmd + " for " + this.targetHost + " with community " + this.community + " and MIB=" + this.mibName);
        System.out.println("From EgSnmpTest :" + this.errorMsg);
        return false;
    }

    private String replace(String string, String string2, String string3) {
        int n;
        do {
            if ((n = string.indexOf(string2)) == -1) continue;
            String string4 = string.substring(0, n);
            string4 = string4 + string3;
            string = string4 = string4 + string.substring(n + string2.length());
        } while (n != -1);
        return string;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

