/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class WAPVirtualAPStTest
extends EgSnmpGenericTest {
    boolean isFirst = true;

    public WAPVirtualAPStTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(2);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.4.1.1.5");
        Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.4.1.1.3");
        Hashtable hashtable4 = this.getMeasures(".1.3.6.1.4.1.9.6.1.104.1.4.1.1.17");
        if (hashtable2 == null || hashtable2.size() == 0) {
            if (this.isFirst) {
                this.logToErrorFile("Info", "WAPVirtualAPStTest No Radio found for this Accesspoint :", this.targetHost);
                this.isFirst = false;
            }
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            double d = -5.0;
            double d2 = -5.0;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            String string3 = (String)hashtable3.get(string);
            String string4 = (String)hashtable4.get(string);
            d2 = this.getDoubleValue(string3);
            d = this.getDoubleValue(string4);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            System.out.println(this.entity + " MeasureList == >" + arrayList);
            this.addNewMeasure(string2, arrayList);
        }
    }

    private Hashtable getMeasures(String string) {
        String string2 = "";
        String string3 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl = this.runSnmpCmdForOid(string);
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string2 = this.lhs[i];
                    string3 = this.rhs[i] != null && this.rhs[i].trim().length() > 0 ? this.rhs[i].trim() : "-5";
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "WAPVirtualAPStTest error occured in getMeasures for targetHost :", this.targetHost);
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) : -5.0;
        }
        catch (Exception exception) {
            d = -5.0;
            this.logToErrorFile("Exception", "WAPVirtualAPStTest Exception occured in Double value conversion for targetHost :", this.targetHost);
            exception.printStackTrace();
        }
        return d;
    }

    public static void main(String[] stringArray) {
        WAPVirtualAPStTest wAPVirtualAPStTest = new WAPVirtualAPStTest(stringArray);
        wAPVirtualAPStTest.computeMeasures(new Hashtable());
    }
}

