/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.IniFile;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UCSValidator
extends EgServerValidator {
    public String host = "";
    private String ucsUrl = "";
    private String ucsUser = "";
    private String ucsPwd = "";
    private int ucsPort = 80;
    private boolean isSSL = false;
    private long xmlQueryTimeout = 60000L;
    private ArrayList validationMsgs = null;
    private String validationErrorMessage = "";

    public UCSValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        IniFile iniFile;
        String string;
        String string2;
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                string = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.host = string;
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-ucs_User")) {
                    this.ucsUser = string;
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-ucs_Password")) {
                    this.ucsPwd = string;
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-ssl")) {
                    if (string != null && string.length() != 0 && (string.equalsIgnoreCase("True") || string.equalsIgnoreCase("Yes"))) {
                        this.isSSL = true;
                        continue;
                    }
                    this.isSSL = false;
                    continue;
                }
                if (string3 == null || !string3.equalsIgnoreCase("-webPort") || string == null || string.length() == 0) continue;
                if (string.equalsIgnoreCase("default")) {
                    if (this.isSSL) {
                        this.ucsPort = 443;
                        continue;
                    }
                    this.ucsPort = 80;
                    continue;
                }
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n = this.isSSL ? 443 : 80;
                }
                this.ucsPort = n;
            }
        }
        if ((string2 = (iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false)).getValue("AGENT_SETTINGS", "UCSAPITimeout")) != null && string2.trim().length() > 0) {
            try {
                this.xmlQueryTimeout = Long.parseLong(string2) * 1000L;
            }
            catch (Exception exception) {
                string = EgInstallInfo.getStackTraceAsString(exception);
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host:192.168.9.98", "-ucs_User:epucs", "-ucs_Password:epucs", "-ssl:false"};
        UCSValidator uCSValidator = new UCSValidator(stringArray2, new Boolean(true));
    }

    public void validate() {
        try {
            if (!this.getConnection()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("UCS Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Web Port$#$NA");
                } else if (!this.isSpecificPortReachable("" + this.ucsPort)) {
                    this.validationMsgs.add("UCS Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Web Port$#$WebPort is down");
                } else {
                    this.validationMsgs.add("UCS Connectivity$#$" + this.validationErrorMessage);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Web Port$#$OK");
                }
                return;
            }
            this.validationMsgs.add("UCS Connectivity$#$OK");
            this.validationMsgs.add("Host IP/Name$#$OK");
            this.validationMsgs.add("Web Port$#$OK");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getConnection() {
        boolean bl = false;
        if (this.isSSL) {
            this.installSSL();
            this.ucsUrl = "https://" + this.host + ":" + this.ucsPort + "/nuova";
        } else {
            this.ucsUrl = "http://" + this.host + ":" + this.ucsPort + "/nuova";
        }
        try {
            String string = this.getCookie();
            if (string == null || string.length() < 47) {
                this.validationErrorMessage = "UCS manager login failed for URL " + this.ucsUrl;
                return bl;
            }
            bl = true;
            this.logoutCookie(string);
        }
        catch (Exception exception) {
            bl = false;
            this.validationErrorMessage = "UCS manager login failed for URL " + this.ucsUrl + " Reason: " + exception;
            exception.printStackTrace();
        }
        return bl;
    }

    private String getCookie() {
        String string = "<aaaLogin inName=\"" + this.ucsUser + "\" inPassword=\"" + this.ucsPwd + "\" />";
        String string2 = "";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string);
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        ArrayList arrayList = this.getAttributes(string3, "aaaLogin");
        if (arrayList == null || arrayList.size() == 0) {
            return string2;
        }
        Hashtable hashtable = (Hashtable)arrayList.get(0);
        if (hashtable == null || hashtable.size() == 0) {
            return string2;
        }
        if (hashtable.containsKey("outCookie")) {
            string2 = (String)hashtable.get("outCookie");
        }
        return string2;
    }

    private void logoutCookie(String string) {
        String string2 = "<aaaLogout inCookie=\"" + string + "\" />";
        String string3 = this.getXmlResponseFromUCS(this.ucsUrl, string2);
    }

    private String getXmlResponseFromUCS(String string, String string2) {
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (httpURLConnection == null) {
                return "";
            }
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDefaultUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            int n = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n);
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(string2.getBytes("UTF-8"));
            outputStream.flush();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList = null;
            int n2 = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n2 = connectionThread.code;
                arrayList = connectionThread.data;
            }
            httpURLConnection.disconnect();
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            String string3 = (String)arrayList.get(0);
            return string3;
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    private ArrayList getAttributes(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            byte[] byArray = string.getBytes("UTF-8");
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            Document document = documentBuilder.parse(byteArrayInputStream);
            if (document == null) {
                return arrayList;
            }
            document.getDocumentElement().normalize();
            document.getDocumentElement().getNodeName();
            NodeList nodeList = document.getElementsByTagName(string2);
            if (nodeList == null) {
                return arrayList;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                NamedNodeMap namedNodeMap;
                Node node = nodeList.item(i);
                if (node == null || node.getNodeType() != 1) continue;
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                Element element = (Element)node;
                if (element == null || (namedNodeMap = element.getAttributes()) == null) continue;
                int n = namedNodeMap.getLength();
                for (int j = 0; j < n; ++j) {
                    Node node2 = namedNodeMap.item(j);
                    if (node2 == null) continue;
                    String string3 = node2.getNodeName();
                    String string4 = node2.getNodeValue();
                    hashtable.put(string3, string4);
                }
                arrayList.add(hashtable);
            }
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        long l4 = this.xmlQueryTimeout;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void installSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_5 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString(exception);
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }
}

