/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class TibDbGrowthTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private boolean useMaxSize = true;
    private double gbConvertor = 1.073741824E9;

    public TibDbGrowthTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        String string = this.getValueForParam("use_max_size");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.useMaxSize = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block15: {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            String string = "select a.FILE_ID,decode(a.maxbytes,0,a.bytes,a.maxbytes) total_size,a.bytes allocated_size,b.free_space free_size from dba_data_files a left join (select file_id,sum(bytes) as free_space from DBA_FREE_SPACE group by file_id) b on a.file_id = b.file_id";
            double d6 = 0.0;
            try {
                String string2 = "jdbc:tibero:thin:@";
                String string3 = string2 + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
                System.out.println("URL::" + string3);
                TbDataSource tbDataSource = new TbDataSource();
                tbDataSource.setURL(string3);
                tbDataSource.setUser(this.username);
                tbDataSource.setPassword(this.password);
                try {
                    connection = tbDataSource.getConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    double d7 = resultSet.getDouble(1);
                    double d8 = resultSet.getDouble(2);
                    double d9 = resultSet.getDouble(3);
                    double d10 = resultSet.getDouble(4);
                    if (d8 == 0.0) {
                        d8 = d9;
                    }
                    if (this.useMaxSize) {
                        d3 += d8;
                        d6 = d8 - d9 + d10;
                        d += d6;
                        continue;
                    }
                    d3 += d9;
                    d6 = d10;
                    d += d6;
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                d4 = d3 / this.gbConvertor;
                d4 = d3 / this.gbConvertor;
                d2 = d / this.gbConvertor;
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d4 - d2));
                arrayList.add(new Double(d2));
                BigDecimal bigDecimal = new BigDecimal((d4 - d2) / d4 * 100.0);
                bigDecimal = bigDecimal.setScale(2, 6);
                arrayList.add(new Double(bigDecimal.doubleValue()));
                BigDecimal bigDecimal2 = new BigDecimal(d2 / d4 * 100.0);
                bigDecimal2 = bigDecimal2.setScale(2, 6);
                arrayList.add(new Double(bigDecimal2.doubleValue()));
                this.addNewMeasure(arrayList);
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                break block15;
            }
            finally {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibDbGrowthTest tibDbGrowthTest = new TibDbGrowthTest(stringArray);
        tibDbGrowthTest.computeMeasures(new Hashtable());
    }
}

