/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class SybResponseTest
extends GenericTest {
    private String driver = "com.sybase.jdbc4.jdbc.SybDriver";
    String user = "";
    String password = "";
    String query = "select * from sysobjects";
    String index = "";
    private int availability = 0;
    private double responseTime = -5.0;
    public double dbConnAvailable = -5.0;
    public double dbConResTime = -5.0;
    public int qryProAvailable = -5;
    public double qryExecTime = -5.0;
    public int noOfRecords = -5;
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";
    public ArrayList sybRespDDList = new ArrayList();
    private String charSet = "";
    private String encryptPassword = "false";
    private boolean isCharsetProcNeeded = false;
    private String sybBelow15 = "";
    private boolean isSybBelow15 = false;

    public SybResponseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.charSet = this.getValueForParam("charset");
        this.encryptPassword = this.getValueForParam("encrypt_password");
        this.sybBelow15 = this.getValueForParam("Driver_compatibility");
        this.isSybBelow15 = this.sybBelow15 == null || this.sybBelow15.trim().length() == 0 ? false : this.sybBelow15.equalsIgnoreCase("true") || this.sybBelow15.equalsIgnoreCase("yes");
        if (this.isSybBelow15) {
            this.driver = "com.sybase.jdbc2.jdbc.SybDriver";
            this.charSet = this.defaultCharSet;
        } else {
            if (this.charSet == null || this.charSet.trim().length() == 0 || this.charSet.equalsIgnoreCase("NULL") || this.charSet.equalsIgnoreCase("none")) {
                this.charSet = this.defaultCharSet;
                this.isCharsetProcNeeded = true;
            }
            this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting test ........");
        SybResponseTest sybResponseTest = new SybResponseTest(stringArray);
        for (int i = 0; i < 20; ++i) {
            sybResponseTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(1500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isCharsetProcNeeded && this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.password, this.charSet, this.encryptPassword, this.driver, this.isSybBelow15);
            System.out.println(" charSetName :" + (String)object);
            if (object != null && ((String)object).length() > 0) {
                this.charSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        object = null;
        Object var3_3 = null;
        Statement statement = null;
        Connection connection = null;
        this.availability = 0;
        this.responseTime = -5.0;
        this.dbConnAvailable = -5.0;
        this.dbConResTime = -5.0;
        this.qryProAvailable = -5;
        this.qryExecTime = -5.0;
        this.noOfRecords = -5;
        try {
            try {
                if (this.isSybBelow15) {
                    connection = this.getConnection(this.targetHost, this.portNo, this.user, this.password, this.charSet, this.driver);
                } else {
                    Class.forName(this.driver);
                    Properties properties = new Properties();
                    properties.put("user", this.user);
                    properties.put("password", this.password);
                    properties.put("charset", this.charSet);
                    properties.put("IS_CLOSED_TEST", "INTERNAL");
                    properties.put("ENCRYPT_PASSWORD", this.encryptPassword);
                    this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
                    long l = System.currentTimeMillis();
                    String string = "jdbc:sybase:Tds:" + this.targetHost + ":" + this.portNo;
                    connection = DriverManager.getConnection(string, properties);
                }
            }
            catch (Exception exception) {
                this.dbConnAvailable = 0.0;
                this.dbConResTime = -5.0;
                this.closeConn(connection);
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.sybRespDDList.add(string);
                System.out.println("sybRespDDList :" + this.sybRespDDList);
            }
            long l = 0L;
            if (connection != null) {
                this.dbConnAvailable = 100.0;
                this.availability = 100;
                this.qryProAvailable = 0;
                long l2 = System.currentTimeMillis();
                this.dbConResTime = (double)(l2 - this.startTime) / 1000.0;
                l = System.currentTimeMillis();
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (statement != null) {
                    object = statement.executeQuery(this.query);
                }
                if (object != null) {
                    this.noOfRecords = 0;
                    this.qryProAvailable = 100;
                    long l3 = System.currentTimeMillis();
                    this.qryExecTime = (double)(l3 - l) / 1000.0;
                    try {
                        while (object.next()) {
                            ++this.noOfRecords;
                        }
                    }
                    catch (Exception exception) {
                        this.noOfRecords = 0;
                    }
                } else {
                    this.qryProAvailable = 0;
                    this.qryExecTime = -5.0;
                }
            }
            try {
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            this.responseTime = this.availability == 100 ? (double)(l4 - this.startTime) / 1000.0 : -5.0;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.availability));
            arrayList.add(new Double(this.responseTime));
            if (this.measureCount > 2) {
                arrayList.add(new Double(this.dbConnAvailable));
                arrayList.add(new Double(this.dbConResTime));
                arrayList.add(new Double(this.qryProAvailable));
                arrayList.add(new Double(this.qryExecTime));
                arrayList.add(new Double(this.noOfRecords));
            }
            this.addNewMeasure(arrayList);
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                this.responseTime = this.dbConResTime;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                if (this.measureCount > 2) {
                    arrayList.add(new Double(this.dbConnAvailable));
                    arrayList.add(new Double(this.dbConResTime));
                    arrayList.add(new Double(this.qryProAvailable));
                    arrayList.add(new Double(this.qryExecTime));
                    arrayList.add(new Double(this.noOfRecords));
                }
                this.addNewMeasure(arrayList);
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.sybRespDDList.add(string);
                this.errorMsg = new String("Exception " + exception.toString() + " while" + "executing SybResponseTest for target: " + this.targetHost);
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            catch (Throwable throwable) {
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn(connection);
                throw throwable;
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void freeTest() {
        this.sybRespDDList = new ArrayList();
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Class.forName(string6);
            String string7 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("charset", string5);
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string7, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.dbConnAvailable = 0.0;
            this.dbConResTime = -5.0;
            String string8 = EgInstallInfo.getStackTraceAsString(exception);
            this.sybRespDDList.add(string8);
            System.out.println("sybRespDDList :" + this.sybRespDDList);
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }
}

