/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class SybMonProcCacheTest
extends GenericTest {
    private String user;
    private String passwd;
    private String ddRowcount;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc4.jdbc.SybDriver";
    private double defValue = -1.0;
    private static final int i_measureCount = 1;
    public ArrayList ddList = new ArrayList();
    private String testQuery = "";
    private String ddQuery = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";
    private String charSet = "";
    private String encryptPassword = "";
    private boolean isCharsetProcNeeded = false;

    public SybMonProcCacheTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(1);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.ddRowcount = this.getValueForParam("dd_row_count");
        this.s_debug = this.getValueForParam("isdebug");
        this.charSet = this.getValueForParam("charset");
        this.encryptPassword = this.getValueForParam("encrypt_password");
        if (this.charSet == null || this.charSet.trim().length() == 0 || this.charSet.equalsIgnoreCase("NULL") || this.charSet.equalsIgnoreCase("none")) {
            this.charSet = this.defaultCharSet;
            this.isCharsetProcNeeded = true;
        }
        this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        if (this.ddRowcount == null || this.ddRowcount.length() == 0) {
            this.ddRowcount = "10";
        }
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append("select Proc_hit_ratio = ( Requests - Loads ) * 100 / Requests from monProcedureCache ");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" set rowcount " + this.ddRowcount + " select ObjectID, ");
        stringBuffer.append("  OwnerUID, DBID,DBName, ");
        stringBuffer.append("  MemUsageKB, ObjectName,  ");
        stringBuffer.append(" ObjectType, OwnerName  ");
        stringBuffer.append("  from monCachedProcedures order by MemUsageKB desc  ");
        this.testQuery = ((StringBuffer)comparable).toString();
        this.ddQuery = stringBuffer.toString();
    }

    public void freeTest() {
        this.ddList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isCharsetProcNeeded && this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword, this.driver, false);
            System.out.println(" charSetName :" + (String)object);
            if (object != null && ((String)object).length() > 0) {
                this.charSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        object = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword);
        SybStatement sybStatement = null;
        if (this.isDebug) {
            System.out.println("[SybMonProcCacheTest] Test Query : " + this.testQuery);
            System.out.println("[SybMonProcCacheTest] DD   Query : " + this.ddQuery);
        }
        if (object == null) {
            return;
        }
        try {
            sybStatement = (SybStatement)object.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
            return;
        }
        try {
            ArrayList arrayList = this.executeTestQuery(sybStatement, this.testQuery);
            if (arrayList != null && arrayList.size() > 0) {
                if (this.isDebug) {
                    System.out.println("[" + this.getClass().getName() + "]-Final MeasureList ==>" + arrayList);
                }
                this.addNewMeasure(arrayList);
                this.executeDDQuery(sybStatement, this.ddQuery);
                if (this.isDebug) {
                    System.out.println("[SybMonProcCacheTest]-dd output List ==>" + this.ddList);
                }
            } else {
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(-5.0));
                this.addNewMeasure(arrayList2);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybMonProcCacheTest computeMeasure ", exception.toString());
            exception.printStackTrace();
            if (this.isPassive) {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.defValue));
                this.addNewMeasure(arrayList);
            }
        }
        finally {
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList executeTestQuery(SybStatement sybStatement, String string) {
        ResultSet resultSet = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = 0.0;
        try {
            resultSet = sybStatement.executeQuery(string);
            while (resultSet.next()) {
                d = resultSet.getDouble(1);
                arrayList.add(new Double(d));
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybMonProcCacheTest execute Test Query ", exception.toString());
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDDQuery(SybStatement sybStatement, String string) {
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        try {
            resultSet = sybStatement.executeQuery(string);
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string3 = resultSet.getString(2);
                string4 = resultSet.getString(3);
                string5 = resultSet.getString(4);
                string6 = resultSet.getString(5);
                string7 = resultSet.getString(6);
                string8 = resultSet.getString(7);
                string9 = resultSet.getString(8);
                string10 = string2 + "~!~" + string3 + "~!~" + string4 + "~!~" + string5 + "~!~" + string6 + "~!~" + string7 + "~!~" + string8 + "~!~" + string9;
                this.ddList.add(string10);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybMonProcCacheTest execute DD Query ", exception.toString());
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
        }
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Class.forName(this.driver);
            String string7 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", string5);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            properties.put("ENCRYPT_PASSWORD", string6);
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string7, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybMonProcCacheTest unable to connect the DB ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybMonProcCacheTest sybMonProcCacheTest = new SybMonProcCacheTest(stringArray);
        sybMonProcCacheTest.computeMeasures(new Hashtable());
    }
}

