/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybDBStatsTest
extends GenericTest {
    private String user;
    private String passwd;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc4.jdbc.SybDriver";
    private static final int i_measureCount = 5;
    ArrayList allInfoList = new ArrayList();
    private String memUseQuery = "";
    private String query = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";
    private String charSet = "";
    private String encryptPassword = "false";
    private boolean isCharsetProcNeeded = false;

    public SybDBStatsTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(5);
        this.isDynamicInfoTest = true;
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.s_debug = this.getValueForParam("isdebug");
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        this.charSet = this.getValueForParam("charset");
        this.encryptPassword = this.getValueForParam("encrypt_password");
        if (this.charSet == null || this.charSet.trim().length() == 0 || this.charSet.equalsIgnoreCase("NULL") || this.charSet.equalsIgnoreCase("none")) {
            this.isCharsetProcNeeded = true;
            this.charSet = this.defaultCharSet;
        }
        this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(" \tselect DBName = db_name(DBID) , ");
        ((StringBuffer)comparable).append(" sum(MemUsageKB) TotMemUsageKB  ");
        ((StringBuffer)comparable).append(" from monSysStatement group by db_name(DBID) ");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" select DBID, DBName, LastBackupFailed, ");
        stringBuffer.append("  TransactionLogFull, AppendLogRequests,");
        stringBuffer.append("  AppendLogWaits from monOpenDatabases");
        this.memUseQuery = ((StringBuffer)comparable).toString();
        this.query = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isCharsetProcNeeded && this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword, this.driver, false);
            System.out.println(" charSetName :" + (String)object);
            if (object != null && ((String)object).length() > 0) {
                this.charSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        object = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword);
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        ResultSet resultSet2 = null;
        if (object == null) {
            return;
        }
        try {
            sybStatement = (SybStatement)object.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
            return;
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        String string = "";
        double d = 0.0;
        try {
            resultSet = sybStatement.executeQuery(this.memUseQuery);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                d = resultSet.getDouble(2);
                hashtable2.put(string, new Double(d));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
        }
        Hashtable hashtable3 = new Hashtable();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = "";
        string = "";
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        try {
            resultSet2 = sybStatement.executeQuery(this.query);
            Hashtable hashtable4 = new Hashtable();
            while (resultSet2.next()) {
                arrayList = new ArrayList();
                string2 = resultSet2.getString(1);
                string = resultSet2.getString(2);
                d2 = resultSet2.getDouble(3);
                d3 = resultSet2.getDouble(4);
                d4 = resultSet2.getDouble(5);
                d5 = resultSet2.getDouble(6);
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                hashtable3.put(string, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", " SybDBStatsTest execute query ", exception.toString());
            exception.printStackTrace();
        }
        finally {
            if (resultSet2 != null) {
                this.closeRs(resultSet2);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
        }
        this.getKeys(hashtable2);
        this.getKeys(hashtable3);
        int n = 0;
        if (this.allInfoList != null) {
            n = this.allInfoList.size();
        }
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            String string3 = (String)this.allInfoList.get(i);
            double d6 = 0.0;
            if (hashtable2.containsKey(string3)) {
                d6 = (Double)hashtable2.get(string3);
            }
            d6 = d6 > 0.0 ? (d6 /= 1024.0) : -5.0;
            ArrayList arrayList3 = (ArrayList)hashtable3.get(string3);
            double d7 = -5.0;
            double d8 = -5.0;
            double d9 = -5.0;
            double d10 = -5.0;
            if (arrayList3 != null && arrayList3.size() > 0) {
                d7 = (Double)arrayList3.get(0);
                d8 = (Double)arrayList3.get(1);
                d9 = (Double)arrayList3.get(2);
                d10 = (Double)arrayList3.get(3);
            }
            arrayList2.add(new Double(d6));
            arrayList2.add(new Double(d7));
            arrayList2.add(new Double(d8));
            arrayList2.add(new Double(d9));
            arrayList2.add(new Double(d10));
            if (this.isDebug) {
                System.out.println("[" + this.getClass().getName() + "] -Final Measurelist ==>" + string3 + "-->" + arrayList2);
            }
            this.addNewMeasure(string3, arrayList2);
        }
    }

    private void getKeys(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.allInfoList.contains(string)) continue;
            this.allInfoList.add(string);
        }
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Class.forName(this.driver);
            String string7 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", string5);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            properties.put("ENCRYPT_PASSWORD", string6);
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string7, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybDBStatsTest sybDBStatsTest = new SybDBStatsTest(stringArray);
        while (true) {
            int n = 0;
            ++n;
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            sybDBStatsTest.computeMeasures(new Hashtable());
        }
    }
}

