/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class SqlResponseTest
extends GenericTest {
    private static final int MEASURE_COUNT = 2;
    private String driver;
    private String url;
    private String query;
    private String user;
    private String password;
    private String errorMsg;

    public SqlResponseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.driver = this.getValueForParam("jdbc_driver");
        this.url = this.getValueForParam("connection_url");
        this.query = this.getValueForParam("query");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        double d = 0.0;
        double d2 = -5.0;
        this.errorMsg = "";
        try {
            long l = System.currentTimeMillis();
            Class.forName(this.driver);
            connection = DriverManager.getConnection(this.url, this.user, this.password);
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.query);
            long l2 = System.currentTimeMillis();
            d2 = (double)(l2 - l) / 1000.0;
            d = 1.0;
        }
        catch (Exception exception) {
            this.errorMsg = exception.toString();
            this.logToErrorFile("ERROR", this.entity, "driver=" + this.driver + " url=" + this.url + "\n" + this.errorMsg);
            exception.printStackTrace();
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            resultSet = null;
            statement = null;
            connection = null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(2);
        arrayList.add(new Double(d));
        arrayList.add(new Double(d2));
        this.addNewMeasure(arrayList);
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

