/*
 * Decompiled with CFR 0.152.
 */
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SapMonPerfJco3Test
extends AsAbapJco3Base {
    public ArrayList monSetsList = new ArrayList();
    public int perfAtr = 0;
    public int red = 0;
    public int yellow = 0;
    public int green = 0;
    public int inactive = 0;
    public ArrayList ddlist = new ArrayList();
    public ArrayList mteVal = new ArrayList();
    protected Hashtable ddhash = new Hashtable();
    public Hashtable detHT;
    public String monSets = this.getValueForParam("Sets");
    public String mons = this.getValueForParam("Monitors");
    public String MonitorName = "";
    public String MonitorSetName = "";
    public String prevDt = "";
    public String prevTime = "";
    public String currValTime = "";
    public String currValDt = "";
    public static final String MON_SET_NAME = "SAP CCMS Monitor Templates";
    private static final ArrayList perfAttrList = new ArrayList();

    public SapMonPerfJco3Test(String[] stringArray) {
        super(stringArray);
        this.printOut("INFO    :monitor sets are " + this.monSets + " and monitors are " + this.mons);
        this.detHT = this.parseMonDetails(this.monSets, this.mons);
        this.setMeasureCount(5);
    }

    public synchronized Hashtable getDDData() {
        return this.ddhash;
    }

    public void resetDDData() {
        if (this.ddhash.size() != 0) {
            this.ddhash = new Hashtable();
        }
    }

    public synchronized Hashtable getMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        this.resetDDData();
        Enumeration enumeration = this.detHT.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)this.detHT.get(string);
            this.printOut("INFO    :setName is " + string + " monsList is " + arrayList.toString());
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (!this.prepMonitorTree(string, string2)) {
                    this.addNotAvailableMeasure(hashtable2, string2);
                    continue;
                }
                this.ddhash.put(string2, this.ddlist);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(this.perfAtr));
                arrayList2.add(new Double(this.red));
                arrayList2.add(new Double(this.yellow));
                arrayList2.add(new Double(this.green));
                arrayList2.add(new Double(this.inactive));
                System.out.println("monitorName   :" + string2 + "  :  measurelist   :" + arrayList2);
                hashtable2.put(string2, arrayList2);
            }
        }
        return hashtable2;
    }

    void addNotAvailableMeasure(Hashtable hashtable, String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        hashtable.put(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean prepMonitorTree(String string, String string2) {
        this.printOut("INFO    :Getting tree for monitor " + string2 + " in set " + string);
        this.setSessID();
        try {
            this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 1), "Begin Context");
            if (!this.logonToXMI("XAL", "1.0")) {
                this.logoffFromXMI();
                this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
                this.endSession();
                boolean bl = false;
                return bl;
            }
            JCoTable jCoTable = this.getTreeNodesTblForMonitor(string, string2);
            if (jCoTable == null) {
                System.out.println("(TreeNodesTbl= getTreeNodesTblForMonitor(setName, monitorName)) == null");
                this.logoffFromXMI();
                this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
                this.endSession();
                boolean bl = false;
                return bl;
            }
            JCoTable jCoTable2 = this.getTemplateNodesTblForMonitor(string, string2);
            if (jCoTable2 == null) {
                System.out.println("Second (TmplNodesTbl= getTemplateNodesTblForMonitor(setName, monitorName)) == null");
                this.logoffFromXMI();
                this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
                this.endSession();
                boolean bl = false;
                return bl;
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            this.prevDt = "N/A";
            this.prevTime = "N/A";
            this.currValTime = "";
            this.currValDt = "";
            this.red = 0;
            this.yellow = 0;
            this.green = 0;
            this.inactive = 0;
            this.perfAtr = 0;
            this.ddlist = new ArrayList();
            this.printOut("INFO    :Num rows is " + jCoTable.getNumRows());
            for (int i = 0; i < jCoTable.getNumRows(); ++i) {
                int n;
                jCoTable.setRow(i);
                String string7 = jCoTable.getString("MTCLASS");
                if (this.isAttribute(string7) && !this.isPerfAttr(string7)) {
                    this.printOut("INFO    :Skipping  . Since possible shutdown app server");
                    continue;
                }
                String string8 = jCoTable.getString("MTNAMESHRT");
                if (string8.indexOf(" Segment ") != -1) {
                    this.printOut("INFO    :Skipping " + string8 + " . Since possible shutdown app server");
                    continue;
                }
                if (this.isPerfAttr(string7)) {
                    this.mteVal = this.getMTEVal(jCoTable, jCoTable2);
                    System.out.println("mteVal  :" + this.mteVal);
                    if (this.mteVal == null || this.mteVal.size() == 0) continue;
                    this.mteVal.add(string8);
                    this.getMetrics(this.mteVal);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer();
                String string9 = jCoTable.getString("ALLEVINTRE");
                int n2 = Integer.parseInt(string9);
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append("/t");
                }
                if (string8.indexOf(" : MTE class ") != -1) {
                    n = 0;
                    int n3 = string8.indexOf(44);
                    string8 = string8.substring(0, n3) + " : No MTEs currently available";
                } else {
                    n = this.isLongMTENameNeeded(jCoTable) ? 1 : 0;
                }
                if (n != 0) {
                    String string10 = jCoTable.getString("MSEGNAME");
                    String string11 = this.getNameFromTemplateNode(jCoTable, jCoTable2, string10);
                    if (string11 != null) {
                        stringBuffer.append(string11);
                    } else {
                        stringBuffer.append(string8);
                    }
                } else {
                    stringBuffer.append(string8);
                }
                String string12 = stringBuffer.toString();
                this.ddlist.add(string12);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.logoffFromXMI();
            try {
                this.runThread(new AsAbapJco3Base.ContextManager(this, this.sessID, this.destName, 2), "End Context");
            }
            catch (Exception exception) {
                this.printOut("Exception while ending context : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + " : " + this.entity, "Exception while ending context : " + exception.toString());
            }
            this.endSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLongMTENameNeeded(JCoTable jCoTable) {
        boolean bl = false;
        int n = jCoTable.getRow();
        try {
            int n2 = jCoTable.getInt("ALPARINTRE") - 1;
            if (n2 < 0) {
                boolean bl2 = true;
                return bl2;
            }
            String string = jCoTable.getString("MTCLASS");
            if (this.isVirtualNode(string)) {
                bl = false;
            }
            jCoTable.setRow(n2);
            string = jCoTable.getString("MTCLASS");
            if (this.isVirtualNode(string)) {
                bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception while determining if long MTE name is needed for MTE " + jCoTable.getString("MTNAMESHRT") + " : " + exception.toString());
        }
        finally {
            jCoTable.setRow(n);
            return bl;
        }
    }

    String getNameFromTemplateNode(JCoTable jCoTable, JCoTable jCoTable2, String string) {
        int n = jCoTable2.getNumRows();
        int n2 = jCoTable2.getRow() + 1;
        if (n2 > n) {
            this.printOut("ERROR   :Curser in Template Nodes Table exceeded table size even before lookup");
            return null;
        }
        String string2 = "";
        if (string.startsWith("SAP_CCMS_")) {
            string = string.substring(9);
        }
        String string3 = null;
        boolean bl = false;
        try {
            string2 = jCoTable.getString("MTUID");
            for (int i = n2; i < n; ++i) {
                jCoTable2.nextRow();
                String string4 = jCoTable2.getString("MTUID");
                String string5 = jCoTable2.getString("MTMCNAME");
                if (string5.startsWith("SAP_CCMS_")) {
                    string5 = string5.substring(9);
                }
                if (!string4.equals(string2) || !string5.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) {
                string3 = jCoTable2.getString("NAME");
            }
        }
        catch (Exception exception) {
            this.printOut("ERROR   :Exception while getting template node name for MT ROW UID " + string2 + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while getting template node name for MT ROW UID " + string2 + " : " + exception.toString());
            return null;
        }
        if (string3 == null) {
            this.printOut("ERROR   :Could not find template node name for MT ROW UID " + string2 + " and mtName " + jCoTable.getString("MTNAMESHRT"));
            return null;
        }
        return string3;
    }

    void getMetrics(ArrayList arrayList) {
        String string;
        String string2;
        System.out.println("Calling getMetrics ...");
        String string3 = (String)arrayList.get(0);
        String string4 = (String)arrayList.get(1);
        if (string4 == null || string4.length() == 0) {
            string4 = "N/A";
        }
        if ((string2 = (String)arrayList.get(2)).equalsIgnoreCase("red")) {
            ++this.red;
        } else if (string2.equalsIgnoreCase("yellow")) {
            ++this.yellow;
        } else if (string2.equalsIgnoreCase("green")) {
            ++this.green;
        } else if (string2.equalsIgnoreCase("grey")) {
            ++this.inactive;
        }
        String string5 = (String)arrayList.get(3);
        String string6 = (String)arrayList.get(4);
        if (string6 == null || string6.length() == 0) {
            string6 = this.prevDt.equals("N/A") ? "N/A" : this.prevDt;
        }
        if ((string = (String)arrayList.get(5)) == null || string.length() == 0) {
            string = this.prevTime.equals("N/A") ? "N/A" : this.prevTime;
        }
        String string7 = (String)arrayList.get(6);
        ++this.perfAtr;
    }

    boolean isAttribute(String string) {
        return string.equals("100") || string.equals("101") || string.equals("102") || string.equals("110") || string.equals("111");
    }

    boolean isPerfAttr(String string) {
        return string.equals("100");
    }

    boolean isVirtualNode(String string) {
        return string.equals("199");
    }

    JCoTable getTemplateNodesTblForMonitor(String string, String string2) {
        JCoStructure jCoStructure;
        JCoDestination jCoDestination = null;
        try {
            jCoDestination = JCoDestinationManager.getDestination((String)this.destName);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while getting destination with name " + this.destName + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while getting destination with name " + this.destName + " : " + exception.toString());
            return null;
        }
        this.printOut("DEBUG : Got destination " + this.destName);
        JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETTEMPLATE");
        if (jCoFunction == null) {
            this.logToErrorFile("ERROR", this.entity, " Could not find function BAPI_SYSTEM_MON_GETTREE\n");
            return null;
        }
        JCoParameterList jCoParameterList = jCoFunction.getImportParameterList();
        jCoParameterList.setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
        try {
            jCoStructure = jCoParameterList.getStructure("MONITOR_NAME");
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Could not get MONITOR_NAME JCO structure for BAPI_SYSTEM_MON_GETTEMPALTE input : " + exception.toString());
            return null;
        }
        jCoStructure.setValue("MS_NAME", MON_SET_NAME);
        jCoStructure.setValue("MONI_NAME", string2);
        try {
            this.executeFunction(jCoFunction, true);
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MON_GETTEMPLATE function : " + exception.toString());
            return null;
        }
        jCoParameterList = jCoFunction.getTableParameterList();
        JCoTable jCoTable = null;
        try {
            jCoTable = jCoParameterList.getTable("TEMPLATE_NODES");
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Could not get TREE_NODES JCO table for BAPI_SYSTEM_MON_GETTEMPALTE output : " + exception.toString());
            return null;
        }
        System.out.println("JTable template " + jCoTable);
        return jCoTable;
    }

    ArrayList getMTEVal(JCoTable jCoTable, JCoTable jCoTable2) {
        try {
            String string = jCoTable.getString("MTSYSID");
            String string2 = jCoTable.getString("MTMCNAME");
            String string3 = jCoTable.getString("MTNUMRANGE");
            String string4 = jCoTable.getString("MTUID");
            String string5 = jCoTable.getString("MTCLASS");
            String string6 = jCoTable.getString("MTINDEX");
            String string7 = jCoTable.getString("EXTINDEX");
            JCoFunction jCoFunction = this.getFunction("BAPI_SYSTEM_MTE_GETPERFCURVAL");
            if (jCoFunction == null) {
                return null;
            }
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("TID");
            jCoStructure.setValue("MTSYSID", string);
            jCoStructure.setValue("MTMCNAME", string2);
            jCoStructure.setValue("MTNUMRANGE", string3);
            jCoStructure.setValue("MTUID", string4);
            jCoStructure.setValue("MTCLASS", string5);
            jCoStructure.setValue("MTINDEX", string6);
            jCoStructure.setValue("MTSYSID", string);
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            try {
                this.executeFunction(jCoFunction, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETPERFCURVAL function : " + exception.toString());
            }
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("CURRENT_VALUE");
            if (jCoStructure2 == null) {
                this.printOut("INFO    :CURRENT_VAL struct from getperfcurVal is null");
                return null;
            }
            JCoFunction jCoFunction2 = this.getFunction("BAPI_SYSTEM_MTE_GETPERFPROP");
            if (jCoFunction2 == null) {
                return null;
            }
            jCoStructure = jCoFunction2.getImportParameterList().getStructure("TID");
            jCoStructure.setValue("MTSYSID", string);
            jCoStructure.setValue("MTMCNAME", string2);
            jCoStructure.setValue("MTNUMRANGE", string3);
            jCoStructure.setValue("MTUID", string4);
            jCoStructure.setValue("MTCLASS", string5);
            jCoStructure.setValue("MTINDEX", string6);
            jCoStructure.setValue("MTSYSID", string);
            jCoFunction2.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            try {
                this.executeFunction(jCoFunction2, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETPERFPROP function : " + exception.toString());
            }
            JCoStructure jCoStructure3 = jCoFunction2.getExportParameterList().getStructure("PROPERTIES");
            if (jCoStructure3 == null) {
                this.printOut("INFO    :PROPERTIES struct from getperfprop is null");
                return null;
            }
            JCoFunction jCoFunction3 = this.getFunction("BAPI_SYSTEM_MTE_GETGENPROP");
            if (jCoFunction3 == null) {
                return null;
            }
            jCoStructure = jCoFunction3.getImportParameterList().getStructure("TID");
            jCoStructure.setValue("MTSYSID", string);
            jCoStructure.setValue("MTMCNAME", string2);
            jCoStructure.setValue("MTNUMRANGE", string3);
            jCoStructure.setValue("MTUID", string4);
            jCoStructure.setValue("MTCLASS", string5);
            jCoStructure.setValue("MTINDEX", string6);
            jCoStructure.setValue("MTSYSID", string);
            jCoFunction3.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            try {
                this.executeFunction(jCoFunction3, true);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MTE_GETGENPROP function : " + exception.toString());
            }
            JCoStructure jCoStructure4 = jCoFunction3.getExportParameterList().getStructure("ACTUAL_ALERT_DATA");
            if (jCoStructure4 == null) {
                this.printOut("INFO    :ACTUAL_ALERT_DATA struct from getgenprop is null");
                return null;
            }
            ArrayList arrayList = this.formatVal(jCoStructure2, jCoStructure3, jCoStructure4);
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, " Exception while printing mte Value : " + exception.toString());
            return null;
        }
    }

    ArrayList formatVal(JCoStructure jCoStructure, JCoStructure jCoStructure2, JCoStructure jCoStructure3) {
        try {
            if (this.currValDt.length() != 0) {
                this.prevDt = this.currValDt;
                this.prevTime = this.currValTime;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = "";
            String string2 = jCoStructure.getString("ALRELEVVAL");
            this.currValDt = jCoStructure.getString("ALRELVALDT");
            this.currValTime = jCoStructure.getString("ALRELVALTI");
            String string3 = jCoStructure2.getString("VALUNIT");
            String string4 = jCoStructure2.getString("DECIMALS");
            String string5 = jCoStructure2.getString("ATTRGROUP");
            String string6 = jCoStructure3.getString("VALUE");
            int n = Integer.parseInt(string6);
            if (n == 0) {
                string = "grey";
            } else if (n == 1) {
                string = "green";
            } else if (n == 2) {
                string = "yellow";
            } else if (n == 3) {
                string = "red";
            }
            int n2 = Integer.parseInt(string4);
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                int n3;
                int n4 = string2.length();
                if (n2 > n4 - 1) {
                    n3 = n2 - n4 + 1;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < n3; ++i) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer2.append(string2);
                    string2 = stringBuffer2.toString();
                    n4 = string2.length();
                }
                n3 = n4 - n2;
                stringBuffer.append(string2.substring(0, n3)).append(".").append(string2.substring(n3)).append(" ");
            } else {
                stringBuffer.append(string2).append(" ");
            }
            arrayList.add(stringBuffer.toString());
            arrayList.add(string3);
            arrayList.add(string);
            arrayList.add(string6);
            arrayList.add(this.currValDt);
            arrayList.add(this.currValTime);
            return arrayList;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, " Exception while printing node data : " + exception.toString());
            return null;
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        SapMonPerfJco3Test sapMonPerfJco3Test = new SapMonPerfJco3Test(stringArray);
        System.out.println(sapMonPerfJco3Test.getMeasures(new Hashtable()));
    }

    public Hashtable parseMonDetails(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer3 = null;
        Hashtable hashtable = new Hashtable();
        int n2 = stringTokenizer.countTokens();
        int n3 = n2 < (n = stringTokenizer2.countTokens()) ? n2 : n;
        this.printOut("INFO    :Number of valid iterations of monitor details is " + n3);
        for (int i = 0; i < n3; ++i) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer2.nextToken();
            stringTokenizer3 = new StringTokenizer(string4, "~#~");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer3.hasMoreTokens()) {
                String string5 = stringTokenizer3.nextToken().trim();
                arrayList.add(string5);
            }
            hashtable.put(string3, arrayList);
        }
        this.printOut("INFO    :Parsed monitor details : " + hashtable.toString());
        return hashtable;
    }

    protected JCoTable getTreeNodesTblForMonitor(String string, String string2) {
        Object var3_3 = null;
        long l = System.currentTimeMillis();
        String string3 = "BAPI_SYSTEM_MON_GETTREE not found in SAP.";
        JCoFunction jCoFunction = null;
        try {
            jCoFunction = this.getFunction("BAPI_SYSTEM_MON_GETTREE");
        }
        catch (Exception exception) {
            this.printOut("Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        if (jCoFunction == null) {
            this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETTREE");
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        JCoTable jCoTable = null;
        Object var12_13 = null;
        String string4 = new String();
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        try {
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", this.eGSapXMIUser);
            JCoStructure jCoStructure = jCoFunction.getImportParameterList().getStructure("MONITOR_NAME");
            jCoStructure.setValue("MONI_NAME", string2);
            jCoStructure.setValue("MS_NAME", MON_SET_NAME);
            this.executeFunction(jCoFunction, true);
            jCoTable = jCoFunction.getTableParameterList().getTable("TREE_NODES");
            bl = perfAttrList.contains(string2);
            int n = jCoTable.getNumRows();
            if (debug) {
                this.printOut(jCoTable.toString());
            }
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
            boolean bl2 = false;
        }
        return jCoTable;
    }

    static {
        perfAttrList.add("Entire System");
        perfAttrList.add("Communications");
        perfAttrList.add("Background Processing");
        perfAttrList.add("Database");
        perfAttrList.add("Buffers");
        perfAttrList.add("System Configuration");
        perfAttrList.add("Spool System");
    }
}

