/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SWSVirtualServerTest
extends GenericTest {
    protected static String options = new String();
    protected static String options1 = new String();
    protected static String os_specific_option = "";
    protected static String wadmPath = null;
    protected static String rootDirName = null;
    protected static BufferedWriter bw = null;
    private ArrayList virtualservers = new ArrayList();
    private static String userName = null;
    private static String passwordFile = null;
    private static String adminServer = null;
    private static String adminPort = null;
    private static String config = null;
    private static String ssl = null;
    private static ArrayList vsHttpData = null;
    private static ArrayList vsWebAppData = null;

    public SWSVirtualServerTest(String[] stringArray) {
        super(stringArray);
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            os_specific_option = "cmd /c ";
        }
        vsHttpData = new ArrayList();
        vsWebAppData = new ArrayList();
    }

    protected void getVirtualServers(String string) {
        if (wadmPath == null && !SWSVirtualServerTest.verifyExistanceOfWadm()) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(os_specific_option);
        stringBuffer.append(wadmPath);
        stringBuffer.append(" list-virtual-servers");
        stringBuffer.append(options);
        stringBuffer.append(" --config=");
        stringBuffer.append(string);
        if (ssl.compareToIgnoreCase("false") == 0) {
            stringBuffer.append(" --no-ssl");
        }
        try {
            this.virtualservers.clear();
            process = runtime.exec(stringBuffer.toString());
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                this.virtualservers.add(string2);
                string2 = bufferedReader.readLine();
            }
            process.destroy();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            process.destroy();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized boolean verifyExistanceOfWadm() {
        File file = new File(rootDirName);
        if (file.exists() && file.isDirectory()) {
            File file2;
            String string = "wadm";
            if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                string = "wadm.bat";
            }
            if ((file2 = new File(file.getAbsolutePath() + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + string)).exists()) {
                wadmPath = file2.getAbsolutePath();
                return true;
            }
        }
        return false;
    }

    protected ArrayList getHttpMetrics(Hashtable hashtable) {
        this.pullHttpMetrics(hashtable);
        return vsHttpData;
    }

    protected ArrayList getWebAppMetrics(Hashtable hashtable) {
        this.pullWebAppMetrics(hashtable);
        return vsWebAppData;
    }

    private void pullHttpMetrics(Hashtable hashtable) {
        BufferedReader bufferedReader = null;
        userName = (String)hashtable.get("User");
        passwordFile = (String)hashtable.get("PasswdFile");
        adminServer = (String)hashtable.get("AdminServer");
        adminPort = (String)hashtable.get("AdminPort");
        config = (String)hashtable.get("Config");
        ssl = (String)hashtable.get("SSL");
        rootDirName = (String)hashtable.get("Webserverdir");
        options = " --user=" + userName + " --password-file=" + rootDirName + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + passwordFile + " --host=" + adminServer + " --port=" + adminPort;
        options1 = " --user=" + userName + " --password-file=" + rootDirName + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + passwordFile;
        this.getVirtualServers(config);
        StringBuffer stringBuffer = new StringBuffer();
        vsHttpData.clear();
        for (int i = 0; i < this.virtualservers.size(); ++i) {
            String string = this.virtualservers.get(i).toString();
            try {
                Runtime runtime = Runtime.getRuntime();
                ArrayList arrayList = new ArrayList();
                stringBuffer = new StringBuffer();
                stringBuffer.append(os_specific_option);
                stringBuffer.append(wadmPath);
                stringBuffer.append(" get-virtual-server-stats ");
                stringBuffer.append(options);
                stringBuffer.append(" --config=" + config);
                stringBuffer.append(" --vs=" + string);
                stringBuffer.append(" --ssl=" + ssl);
                this.process = runtime.exec(stringBuffer.toString());
                bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                String string2 = bufferedReader.readLine();
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                while (string2 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    hashtable2.put(string3, string4);
                    string2 = bufferedReader.readLine();
                }
                vsHttpData.add(hashtable2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.process.destroy();
                if (bufferedReader != null) {
                    this.closeReader(bufferedReader);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.process.destroy();
            if (bufferedReader == null) continue;
            this.closeReader(bufferedReader);
        }
    }

    private void pullWebAppMetrics(Hashtable hashtable) {
        BufferedReader bufferedReader = null;
        userName = (String)hashtable.get("User");
        passwordFile = (String)hashtable.get("PasswdFile");
        adminServer = (String)hashtable.get("AdminServer");
        adminPort = (String)hashtable.get("AdminPort");
        config = (String)hashtable.get("Config");
        ssl = (String)hashtable.get("SSL");
        rootDirName = (String)hashtable.get("Webserverdir");
        options = " --user=" + userName + " --password-file=" + rootDirName + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + passwordFile + " --host=" + adminServer + " --port=" + adminPort;
        options1 = " --user=" + userName + " --password-file=" + rootDirName + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + passwordFile;
        this.getVirtualServers(config);
        vsWebAppData.clear();
        for (int i = 0; i < this.virtualservers.size(); ++i) {
            String string;
            Object object;
            Object object2;
            String string2 = this.virtualservers.get(i).toString();
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                StringBuffer stringBuffer = new StringBuffer();
                object2 = Runtime.getRuntime();
                object = new ArrayList();
                stringBuffer = new StringBuffer();
                stringBuffer.append(os_specific_option);
                stringBuffer.append(wadmPath);
                stringBuffer.append(" list-webapps ");
                stringBuffer.append(options);
                stringBuffer.append(" --config=" + config);
                stringBuffer.append(" --vs=" + string2);
                this.process = ((Runtime)object2).exec(stringBuffer.toString());
                bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                string = bufferedReader.readLine();
                while (string != null) {
                    arrayList.add(string);
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.process.destroy();
                if (bufferedReader != null) {
                    this.closeReader(bufferedReader);
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.process.destroy();
            if (bufferedReader != null) {
                this.closeReader(bufferedReader);
            }
            for (int j = 0; j < arrayList.size(); ++j) {
                string = arrayList.get(j).toString();
                try {
                    object2 = new StringBuffer();
                    Runtime runtime = Runtime.getRuntime();
                    ArrayList arrayList2 = new ArrayList();
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(os_specific_option);
                    ((StringBuffer)object2).append(wadmPath);
                    ((StringBuffer)object2).append(" get-webapp-stats ");
                    ((StringBuffer)object2).append(options);
                    ((StringBuffer)object2).append(" --config=" + config);
                    ((StringBuffer)object2).append(" --vs=" + string2);
                    ((StringBuffer)object2).append(" --uri=" + string);
                    ((StringBuffer)object2).append(" --ssl=" + ssl);
                    this.process = runtime.exec(((StringBuffer)object2).toString());
                    bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                    object = bufferedReader.readLine();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    while (object != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "=");
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        arrayList3.add(string4);
                        object = bufferedReader.readLine();
                    }
                    vsWebAppData.add(arrayList3);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.process.destroy();
                    if (bufferedReader != null) {
                        this.closeReader(bufferedReader);
                    }
                    return;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.process.destroy();
                if (bufferedReader == null) continue;
                this.closeReader(bufferedReader);
            }
        }
    }
}

