/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class SWSInstanceTest
extends SWSBaseTest {
    private boolean isFirstTime = true;
    public Hashtable generalInfo = null;
    private long last_count_requests = 0L;
    private long last_count_errors = 0L;
    private long last_count_bytes_received = 0L;
    private long last_count_bytes_transmitted = 0L;

    public SWSInstanceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            this.getMetrics(hashtable);
            this.generalInfo = this.getGeneralInfo();
            if (this.generalInfo == null || this.generalInfo.size() == 0) {
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                this.addNewMeasure(arrayList);
                return;
            }
            long l = Long.parseLong(this.generalInfo.get("secondsRunning").toString());
            arrayList.add(new Double(l));
            String string = this.generalInfo.get("countRequests").toString();
            long l2 = Long.parseLong(string);
            if (this.isFirstTime) {
                arrayList.add(new Double(-5.0));
            } else {
                long l3 = l2 - this.last_count_requests;
                double d = (double)l3 / this.timeSinceLastTest;
                arrayList.add(new Double(d));
            }
            this.last_count_requests = l2;
            String string2 = this.generalInfo.get("countErrors").toString();
            long l4 = Long.parseLong(string2);
            if (this.isFirstTime) {
                arrayList.add(new Double(-5.0));
            } else {
                arrayList.add(new Double(l4 - this.last_count_errors));
            }
            this.last_count_errors = l4;
            double d = Double.parseDouble(this.generalInfo.get("maxResponseTime").toString());
            arrayList.add(new Double(d));
            double d2 = Double.parseDouble(this.generalInfo.get("rtLast5MinAvg").toString());
            double d3 = d2 / 1000.0;
            arrayList.add(new Double(d3));
            String string3 = this.generalInfo.get("countBytesReceived").toString();
            long l5 = Long.parseLong(string3);
            if (this.isFirstTime) {
                arrayList.add(new Double(-5.0));
            } else {
                long l6 = l5 - this.last_count_bytes_received;
                double d4 = (double)l6 / (this.timeSinceLastTest * 1024.0);
                arrayList.add(new Double(d4));
            }
            this.last_count_bytes_received = l5;
            String string4 = this.generalInfo.get("countBytesTransmitted").toString();
            long l7 = Long.parseLong(string4);
            if (this.isFirstTime) {
                arrayList.add(new Double(-5.0));
            } else {
                long l8 = l7 - this.last_count_bytes_transmitted;
                double d5 = (double)l8 / (this.timeSinceLastTest * 1024.0);
                arrayList.add(new Double(d5));
            }
            this.last_count_bytes_transmitted = l7;
            this.isFirstTime = false;
            System.out.println("SWSInstanceTest = " + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            arrayList.add(new Double(-5.0));
            System.out.println("SWSInstanceTest = " + arrayList);
            this.addNewMeasure(arrayList);
        }
    }
}

