/*
 * Decompiled with CFR 0.152.
 */
import com.eg.CertificateVerifier;
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import com.eg.EgSSL;
import com.eg.SSLContextProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLCertificateHelper {
    public static void main(String[] stringArray) {
        SSLCertificateHelper.enableSSL();
        try {
            Vector vector;
            ArrayList arrayList = SSLCertificateHelper.readInputData();
            String string = "";
            if (arrayList != null && arrayList.size() > 0 && (vector = (Vector)arrayList.get(0)) != null && vector.size() > 0) {
                Hashtable hashtable = (Hashtable)vector.get(0);
                string = (String)vector.get(1);
                String string2 = (String)vector.get(2);
                Hashtable hashtable2 = SSLCertificateHelper.processData(hashtable, string, string2);
                SSLCertificateHelper.writeOutputData(hashtable2);
            }
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][main]:" + exception.toString());
            exception.printStackTrace();
        }
    }

    public static Hashtable processData(Hashtable hashtable, String string, String string2) {
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        KeyStore keyStore = null;
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        while (iterator.hasNext()) {
            int n;
            Object object;
            Object object2;
            Object object3;
            String string3;
            String string4 = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashtable.get(string4);
            if (arrayList == null) continue;
            if (string4.equals("KeyStoreFile")) {
                String string5 = (String)arrayList.get(0);
                string3 = (String)arrayList.get(1);
                object3 = (String)arrayList.get(2);
                try {
                    keyStore = KeyStore.getInstance((String)object3);
                    object2 = string3.toCharArray();
                    object = new FileInputStream(string5);
                    keyStore.load((InputStream)object, (char[])object2);
                    ((FileInputStream)object).close();
                }
                catch (KeyStoreException keyStoreException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:Exception in loading KeyStore : " + keyStoreException.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:KeyStore file not found : " + fileNotFoundException.toString());
                }
                catch (IOException iOException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:IO Exception : " + iOException.toString());
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:Exception : " + exception.toString());
                }
                if (keyStore == null) continue;
                try {
                    object2 = keyStore.aliases();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        Hashtable hashtable3 = SSLCertificateHelper.doTheWork("KeyStore", (String)object, string, keyStore, string2);
                        if (hashtable3 == null) continue;
                        hashtable2.put((String)object + " [KeyStore entry]", hashtable3);
                    }
                    continue;
                }
                catch (KeyStoreException keyStoreException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:KeyStoreException : " + keyStoreException.toString());
                    continue;
                }
            }
            if (string4.equals("certificates")) {
                for (n = 0; n < arrayList.size(); ++n) {
                    string3 = (String)arrayList.get(n);
                    object3 = SSLCertificateHelper.doTheWork("certificate", string3, string, null, string2);
                    if (object3 == null) continue;
                    hashtable2.put(string3, object3);
                }
                continue;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string3 = (String)arrayList.get(n);
                if (string3 == null || string3.indexOf(":") == -1 || (object = SSLCertificateHelper.doTheWork((String)(object3 = string3.substring(0, string3.lastIndexOf(":"))), (String)(object2 = string3.substring(string3.lastIndexOf(":") + 1)), string, null, string2)) == null) continue;
                if (((String)object2).equals("443")) {
                    hashtable2.put(object3, object);
                    continue;
                }
                hashtable2.put((String)object3 + ":" + (String)object2, object);
            }
        }
        return hashtable2;
    }

    private static Hashtable doTheWork(String string, String string2, String string3, KeyStore keyStore, String string4) {
        String string5 = "-";
        String string6 = "-";
        String string7 = "-";
        String string8 = "-";
        String string9 = "-";
        String string10 = "-";
        String string11 = "-";
        String string12 = "-";
        String string13 = "-";
        String string14 = "-";
        String string15 = "-";
        String string16 = "-";
        String string17 = "-";
        String string18 = "-";
        String string19 = "-";
        String string20 = "-";
        String string21 = "-";
        String string22 = "-";
        String string23 = "-";
        String string24 = "-";
        String string25 = "-";
        String string26 = "-";
        String string27 = "none";
        String string28 = "NOTDONE";
        try {
            Object[] objectArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5 = null;
            if (string.equalsIgnoreCase("KeyStore") && (object5 = keyStore.getCertificate(string2)) != null && (object4 = keyStore.getCertificateChain(string2)) != null) {
                try {
                    string28 = SSLCertificateHelper.verifyCertificate((Certificate)object5, (Certificate[])object4, string2);
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork]: Unable to verify certificate for " + string2 + "  " + exception.getMessage());
                }
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper-KEYSTORE] resultOfCertificateVerify :" + string28 + " for " + string2);
            }
            if (string.equalsIgnoreCase("certificate")) {
                Object object6;
                object4 = null;
                try {
                    object6 = new FileInputStream(string2);
                    object3 = CertificateFactory.getInstance("X.509");
                    object4 = ((CertificateFactory)object3).generateCertificates((InputStream)object6);
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Specified certificate file not found !!! " + string2);
                }
                if (object4 == null) {
                    return null;
                }
                try {
                    string28 = SSLCertificateHelper.verifyCertificate(new ArrayList<Certificate>((Collection<Certificate>)object4), string2);
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork]: Unable to verify certificate for " + string2 + "  " + exception.getMessage());
                }
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper-CERTIFICATE] resultOfCertificateVerify :" + string28 + " for " + string2);
                object6 = object4.iterator();
                if (object6.hasNext()) {
                    object5 = (Certificate)object6.next();
                }
            }
            if (!string.equalsIgnoreCase("KeyStore") && !string.equalsIgnoreCase("certificate")) {
                int n = 30000;
                int n2 = 443;
                try {
                    n = Integer.parseInt(string3);
                    n2 = Integer.parseInt(string2);
                    object3 = null;
                    object2 = SSLContextProvider.getContext();
                    object = null;
                    if (object2 != null) {
                        int n3;
                        object = ((SSLContext)object2).getSocketFactory();
                        if (string.startsWith("tcp_")) {
                            object3 = string.substring(4);
                            n3 = ((String)object3).indexOf("_");
                            if (n3 > -1) {
                                object3 = ((String)object3).substring(0, n3);
                            }
                        } else {
                            n3 = string.indexOf("_");
                            object3 = n3 > -1 ? string.substring(0, n3) : string;
                        }
                        SSLSocket sSLSocket = (SSLSocket)((SocketFactory)object).createSocket((String)object3, n2);
                        sSLSocket.setSoTimeout(n);
                        sSLSocket.startHandshake();
                        objectArray = sSLSocket.getSession().getPeerCertificates();
                        if (objectArray.length > 0) {
                            object5 = objectArray[0];
                        }
                        try {
                            if (objectArray != null) {
                                string28 = SSLCertificateHelper.verifyCertificate((Certificate)object5, (Certificate[])objectArray, string + ":" + string2);
                            }
                        }
                        catch (Exception exception) {
                            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork]: Unable to verify certificate for " + string + ":" + string2 + "  " + exception.getMessage());
                        }
                        sSLSocket.close();
                    } else {
                        SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Unable to get SSLContext for " + string + " " + string2);
                    }
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper-HTTPS] resultOfCertificateVerify :" + string28 + " for " + string + ":" + string2);
                }
                catch (NumberFormatException numberFormatException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : NumberFormatException  for " + string + " " + string2);
                    n = 30000;
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Exception for : " + string + " " + string2 + " " + SSLCertificateHelper.stackTraceToString(exception));
                }
            }
            if (object5 == null) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Certificate file is null for " + string + " " + string2);
                return null;
            }
            object4 = ((Certificate)object5).getPublicKey();
            if (object4 != null) {
                string5 = object4.toString();
                if (string5.indexOf("modulus") > -1) {
                    string5 = string5.substring(0, string5.indexOf("modulus"));
                } else if (string5.indexOf("Parameters:") > -1) {
                    string5 = string5.substring(0, string5.indexOf("Parameters:"));
                }
                string5 = string5.trim();
                string6 = object4.getAlgorithm();
                string7 = object4.getFormat();
            }
            if ((string8 = ((Certificate)object5).getType()) != null && string8.length() > 0 && string8.equalsIgnoreCase("x.509")) {
                Set<String> set;
                Object object7;
                StringBuffer stringBuffer;
                Object object8;
                Serializable serializable;
                ArrayList arrayList;
                byte[] byArray;
                BigInteger bigInteger;
                X509Certificate x509Certificate = (X509Certificate)object5;
                int n = x509Certificate.getVersion();
                string9 = String.valueOf(n);
                object2 = x509Certificate.getNotBefore();
                if (object2 != null) {
                    string10 = ((Date)object2).toString();
                }
                if ((object = x509Certificate.getNotAfter()) != null) {
                    if (string4.equals("SSLCertValidityTest")) {
                        long l;
                        long l2 = ((Date)object).getTime();
                        double d = (l2 - (l = System.currentTimeMillis())) / EgConfigInfo.msecPerDay;
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        string11 = String.valueOf(d);
                    } else {
                        string11 = ((Date)object).toString();
                    }
                }
                if ((bigInteger = x509Certificate.getSerialNumber()) != null) {
                    string12 = SSLCertificateHelper.hexify(bigInteger.toByteArray());
                    string12 = string12.trim();
                }
                string13 = x509Certificate.getSigAlgName();
                string14 = x509Certificate.getSigAlgOID();
                objectArray = x509Certificate.getSigAlgParams();
                if (objectArray != null && objectArray.length > 0) {
                    string15 = objectArray.toString();
                }
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                string16 = "" + messageDigest.getAlgorithm();
                string17 = "" + SSLCertificateHelper.getThumbPrint(x509Certificate, messageDigest);
                string17 = string17.trim();
                String string29 = "" + SSLCertificateHelper.getThumbPrint(x509Certificate, messageDigest, false);
                String string30 = System.getProperty("Thumbprint");
                if (string30 != null && string30.length() > 0) {
                    string27 = "false";
                }
                if (string27.equals("false") && string29.equals(string30)) {
                    string27 = "true";
                }
                if ((byArray = SSLCertificateHelper.getAuthorityKeyId(x509Certificate)) != null) {
                    string18 = SSLCertificateHelper.hexify(byArray);
                }
                if ((arrayList = SSLCertificateHelper.getCrlDistributionPoint(x509Certificate)) != null) {
                    serializable = new StringBuffer();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ((StringBuffer)serializable).append(arrayList.get(i));
                        ((StringBuffer)serializable).append(";");
                    }
                    string19 = ((StringBuffer)serializable).toString();
                }
                if (x509Certificate.getIssuerDN() != null) {
                    string20 = x509Certificate.getIssuerDN().toString();
                }
                if ((serializable = (ArrayList)x509Certificate.getIssuerAlternativeNames()) != null && serializable.size() > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < serializable.size(); ++i) {
                        object8 = (String)serializable.get(i);
                        stringBuffer2.append((String)object8);
                        stringBuffer2.append(";");
                    }
                    string21 = stringBuffer2.toString();
                }
                if (x509Certificate.getSubjectX500Principal() != null) {
                    String string31;
                    string22 = string31 = x509Certificate.getSubjectX500Principal().toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string31, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string32;
                        object8 = stringTokenizer.nextToken();
                        if (object8 != null && ((String)object8).length() > 0 && ((String)object8).indexOf("=") > -1 && (string32 = ((String)object8).substring(0, ((String)object8).indexOf("=")).trim()).equals("CN")) continue;
                    }
                }
                if (x509Certificate.getSubjectAlternativeNames() != null) {
                    string23 = x509Certificate.getSubjectAlternativeNames().toString();
                    string23 = string23.trim();
                }
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("digitalSignature");
                arrayList2.add("nonRepudiation");
                arrayList2.add("keyEncipherment");
                arrayList2.add("dataEncipherment");
                arrayList2.add("keyAgreement");
                arrayList2.add("keyCertSign");
                arrayList2.add("cRLSign");
                arrayList2.add("encipherOnly");
                arrayList2.add("decipherOnly");
                boolean[] blArray = x509Certificate.getKeyUsage();
                if (blArray != null && blArray.length > 0) {
                    object8 = new StringBuffer();
                    for (int i = 0; i < blArray.length; ++i) {
                        if (!blArray[i]) continue;
                        ((StringBuffer)object8).append(arrayList2.get(i));
                        if (i >= blArray.length - 1) continue;
                        ((StringBuffer)object8).append(", ");
                    }
                    string24 = ((StringBuffer)object8).toString();
                    if ((string24 = string24.trim()).indexOf(",") > -1) {
                        string24 = string24.substring(0, string24.lastIndexOf(","));
                    }
                }
                object8 = null;
                try {
                    object8 = x509Certificate.getExtendedKeyUsage();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (object8 != null) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("1.3.6.1.4.1.311.10.3.3", "Microsoft Server Gated Crypto");
                    hashtable.put("1.3.6.1.5.5.7.3.1", "TLS Web server authentication");
                    hashtable.put("1.3.6.1.5.5.7.3.2", "TLS Web client authentication");
                    hashtable.put("1.3.6.1.5.5.7.3.3", "Code signing");
                    hashtable.put("1.3.6.1.5.5.7.3.4", "E-mail protection");
                    hashtable.put("1.3.6.1.5.5.7.3.5", "IP security end system");
                    hashtable.put("1.3.6.1.5.5.7.3.6", "IP security tunnel termination");
                    hashtable.put("1.3.6.1.5.5.7.3.7", "IP security user");
                    hashtable.put("1.3.6.1.5.5.7.3.8", "Timestamping");
                    hashtable.put("1.3.6.1.5.5.7.3.9", "OCSPstamping");
                    hashtable.put("2.16.840.1.113730.4.1", "Netscape Server Gated Crypto");
                    stringBuffer = new StringBuffer();
                    for (int i = 0; i < object8.size(); ++i) {
                        String string33 = (String)object8.get(i);
                        if (string33 == null || string33.length() <= 0) continue;
                        object7 = (String)hashtable.get(string33);
                        if (object7 == null) {
                            object7 = "-";
                        }
                        if (!object7.equals("-")) {
                            stringBuffer.append((String)object7);
                            stringBuffer.append(", ");
                            continue;
                        }
                        stringBuffer.append(string33);
                        stringBuffer.append(", ");
                    }
                    string25 = stringBuffer.toString();
                    if (string25.indexOf(",") > -1) {
                        string25 = string25.substring(0, string25.lastIndexOf(","));
                    }
                }
                if ((set = x509Certificate.getCriticalExtensionOIDs()) != null && !set.isEmpty()) {
                    stringBuffer = new StringBuffer();
                    for (String string33 : set) {
                        object7 = x509Certificate.getExtensionValue(string33);
                        if (object7 == null) continue;
                        stringBuffer.append(string33);
                        stringBuffer.append(",");
                    }
                    string26 = stringBuffer.toString();
                    if (string26.indexOf(",") > -1) {
                        string26 = string26.substring(0, string26.lastIndexOf(","));
                    }
                }
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("CertificateKey", string5);
            hashtable.put("KeyAlgorithm", string6);
            hashtable.put("KeyFormat", string7);
            hashtable.put("CertificateType", string8);
            hashtable.put("CertificateVersion", string9);
            hashtable.put("ValidFrom", string10);
            hashtable.put("ValidTo", string11);
            hashtable.put("SerialNumber", string12);
            hashtable.put("SignatureAlgorithm", string13);
            hashtable.put("SignatureOID", string14);
            hashtable.put("SignatureParams", string15);
            hashtable.put("ThumbAlgorithm", string16);
            hashtable.put("ThumbPrint", string17);
            hashtable.put("KeyIdentifier", string18);
            hashtable.put("CrlDP", string19);
            hashtable.put("Issuer", string20);
            hashtable.put("IssuerAlt", string21);
            hashtable.put("InstalledOn", string22);
            hashtable.put("SAlternative", string23);
            hashtable.put("KeyUsage", string24);
            hashtable.put("ExtendedKeyUsage", string25);
            hashtable.put("CriticalExtensions", string26);
            hashtable.put("ThumbPrintMatch", string27);
            hashtable.put("ResultOfCertificateVerify", string28);
            return hashtable;
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork]:Exception is : " + exception.toString());
            return new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList readInputData() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(System.in);
            object = objectInputStream.readObject();
            arrayList.add(object);
            objectInputStream.close();
            objectInputStream = null;
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][readInputData]Error 1 : " + exception.toString());
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                    objectInputStream = null;
                }
            }
            catch (Exception exception) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][readInputData]Error 2 : " + exception.toString());
            }
        }
        return arrayList;
    }

    private static void writeOutputData(Hashtable hashtable) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(System.out);
            objectOutputStream.writeObject(hashtable);
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][writeOutputData]Error 1 : " + exception.toString());
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (Exception exception) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][writeOutputData]Error 2 : " + exception.toString());
            }
        }
    }

    public static synchronized void logToTempFile(String string) {
        try {
            PrintWriter printWriter;
            String string2 = EgInstallInfo.getInstallDir() + "/agent/logs/sslcerttest.log";
            File file = new File(string2);
            if (file.exists() && file.length() >= 1000000L) {
                EgInstallInfo.fileRename(string2, string2 + ".1");
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                return;
            }
            String string3 = new String(string);
            printWriter.println(string3);
            printWriter.close();
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][logToTempFile] : Exception is : " + exception.toString());
        }
    }

    protected static byte[] getAuthorityKeyId(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.35");
        if (byArray == null) {
            return null;
        }
        DEROctetString dEROctetString = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)aSN1InputStream.readObject());
        return authorityKeyIdentifier.getKeyIdentifier();
    }

    protected static ArrayList getCrlDistributionPoint(X509Certificate x509Certificate) throws CertificateParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getEncoded());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            TBSCertificateStructure tBSCertificateStructure = x509CertificateStructure.getTBSCertificate();
            X509Extensions x509Extensions = tBSCertificateStructure.getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(aSN1ObjectIdentifier);
                    ASN1OctetString aSN1OctetString = x509Extension.getValue();
                    ASN1InputStream aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
                    if (!aSN1ObjectIdentifier.equals((ASN1Primitive)X509Extensions.CRLDistributionPoints)) continue;
                    CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1InputStream2.readObject());
                    DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
                    for (int i = 0; i != distributionPointArray.length; ++i) {
                        DistributionPoint distributionPoint = distributionPointArray[i];
                        DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                        GeneralNames generalNames = (GeneralNames)distributionPointArray[i].getDistributionPoint().getName();
                        GeneralName[] generalNameArray = generalNames.getNames();
                        for (int j = 0; j < generalNameArray.length; ++j) {
                            if (generalNameArray[j].getTagNo() != 6) continue;
                            ASN1String aSN1String = (ASN1String)generalNameArray[j].getName();
                            arrayList.add(aSN1String.getString());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][getCrlDistributionPoint] : Exception is : " + exception.toString());
        }
        return arrayList;
    }

    protected static ASN1Primitive getExtensionValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
        return aSN1InputStream.readObject();
    }

    protected static String getStringFromGeneralNames(ASN1Primitive aSN1Primitive) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
        if (aSN1Sequence.size() == 0) {
            return null;
        }
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(0);
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)dERTaggedObject, (boolean)false).getOctets());
    }

    protected static String getThumbPrint(X509Certificate x509Certificate, MessageDigest messageDigest) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (byArray2 != null) {
            return SSLCertificateHelper.hexify(byArray2);
        }
        return null;
    }

    protected static String hexify(byte[] byArray) {
        return SSLCertificateHelper.hexify(byArray, true);
    }

    protected static String getThumbPrint(X509Certificate x509Certificate, MessageDigest messageDigest, boolean bl) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (byArray2 != null) {
            return SSLCertificateHelper.hexify(byArray2, bl);
        }
        return null;
    }

    protected static String hexify(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = null;
            if (byArray == null) break block4;
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            stringBuffer = new StringBuffer(byArray.length * 2);
            if (bl) {
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
                    stringBuffer.append(cArray[byArray[i] & 0xF]);
                    stringBuffer.append(" ");
                }
            } else {
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
                    stringBuffer.append(cArray[byArray[i] & 0xF]);
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stackTraceToString(Throwable throwable) {
        String string = null;
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = stringWriter.toString();
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (stringWriter != null) {
                    stringWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static void enableSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.err.println("[SSLCertificateBase][SSLCertificateBase]: " + exception.toString());
        }
    }

    public static String verifyCertificate(ArrayList<Certificate> arrayList, String string) {
        String string2 = "NOTDONE";
        if (arrayList != null && arrayList.size() > 0) {
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            X509Certificate x509Certificate = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                X509Certificate x509Certificate2 = (X509Certificate)arrayList.get(i);
                if (i == 0) {
                    x509Certificate = x509Certificate2;
                    continue;
                }
                hashSet.add(x509Certificate2);
            }
            if (x509Certificate != null) {
                string2 = SSLCertificateHelper.verifyCertificate(x509Certificate, hashSet, string);
            }
        }
        return string2;
    }

    private static String verifyCertificate(X509Certificate x509Certificate, Set<X509Certificate> set, String string) {
        String string2 = "NOTDONE";
        if (x509Certificate != null) {
            try {
                PKIXCertPathBuilderResult pKIXCertPathBuilderResult = CertificateVerifier.verifyCertificate(x509Certificate, set, false, null);
                string2 = "PUBLIC_CA_SIGNED";
            }
            catch (Exception exception) {
                String string3 = SSLCertificateHelper.checkException(exception);
                if (string3 != null) {
                    string2 = string3;
                }
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][certificateChain] : for " + string + " " + exception.getMessage());
            }
        }
        return string2;
    }

    private static String checkException(Exception exception) {
        String string = null;
        String string2 = exception.getMessage();
        if (string2 != null) {
            if (string2.indexOf("The certificate is self-signed") > -1) {
                string = "SELF_SIGNED";
            } else if (string2.indexOf("The certificate is from Local CA") > -1) {
                string = "LOCAL_CA_SIGNED";
            } else if (string2.indexOf("The certificate is revoked by CRL") > -1) {
                string = "REVOKED";
            }
        }
        return string;
    }

    public static String verifyCertificate(Certificate certificate, Certificate[] certificateArray, String string) {
        String string2;
        String string3 = "NOTDONE";
        if (certificate != null && (string2 = certificate.getType()).equalsIgnoreCase("x.509")) {
            X509Certificate x509Certificate = null;
            try {
                X509Certificate x509Certificate2 = (X509Certificate)certificate;
                HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
                for (int i = 1; i < certificateArray.length; ++i) {
                    X509Certificate x509Certificate3 = (X509Certificate)certificateArray[i];
                    hashSet.add(x509Certificate3);
                    x509Certificate = x509Certificate3;
                }
                PKIXCertPathBuilderResult pKIXCertPathBuilderResult = CertificateVerifier.verifyCertificate(x509Certificate2, hashSet, false, x509Certificate);
                string3 = "PUBLIC_CA_SIGNED";
            }
            catch (Exception exception) {
                String string4 = SSLCertificateHelper.checkException(exception);
                if (string4 != null) {
                    string3 = string4;
                }
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][certificateChain] : for " + string + " " + exception.getMessage());
            }
        }
        return string3;
    }
}

