/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisReplicaTest
extends RedisBase {
    private static final String REDIS_REPLICATION_COMMAND = "Replication";
    private static final String indexSubject = "REDIS_REPLICATION_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_REPLICATION_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousMastRepOffset = 0.0;
    private double previousSlavRepOffset = 0.0;
    private double previousRepBacklogSize = 0.0;
    private double previousRepBacklogFirByteOff = 0.0;
    private double previousRepBacklogHistLen = 0.0;
    private double roleChanged = -5.0;
    private String previousRole = "None";
    public String roleStatus = "";
    public long runtime = 0L;

    public RedisReplicaTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisReplicationTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisReplicationTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisReplicationTest", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_REPLICATION_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Client Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureForReplication(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasureForReplication(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasureForReplication]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} measureCount : {}, redisNameList     : {}", new Object[]{this.logPrefix, this.measureCount, redisNameList});
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string2);
                    logger.debug("{} [getRedisMeasureForReplication] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable2);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasureForReplication] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                String string3 = "none";
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForReplication] Exception occured while getting fetching the values from metricTable {}", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!redisNameList.contains(string)) continue;
                    String string4 = (String)measureNameTable.get(string);
                    int n = Integer.parseInt(measureIndexTable.get(string4).toString());
                    double d = 0.0;
                    if (object.toString().equalsIgnoreCase("master")) {
                        d = 1.0;
                        logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value: {}", new Object[]{this.logPrefix, n, string, d});
                        arrayList.set(n, new Double(d));
                        string3 = "master";
                        continue;
                    }
                    if (object.toString().equalsIgnoreCase("slave")) {
                        d = 2.0;
                        logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string, d});
                        arrayList.set(n, new Double(d));
                        string3 = "slave";
                        continue;
                    }
                    if (object.toString().equalsIgnoreCase("sentinel")) {
                        d = 3.0;
                        logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string, d});
                        arrayList.set(n, new Double(d));
                        string3 = "sentinel";
                        continue;
                    }
                    try {
                        if (n != 2 && n != 8 && n != 9 && n != 10 && n != 12 && n != 13 && n != 14) {
                            if (n == 4) {
                                String string5 = object.toString();
                                d = string5.equals("up") ? 1.0 : 0.0;
                                logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string, d});
                            } else {
                                d = Double.parseDouble(object.toString());
                                d = d == -1.0 ? -5.0 : d;
                                logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string, d});
                            }
                            arrayList.set(n, new Double(d));
                            continue;
                        }
                        if (n == 8 || n == 12) {
                            d = Double.parseDouble(EgUtils.convertMemoryValues(object.toString(), "B", "MB"));
                        } else if (n == 9) {
                            double d2 = Double.parseDouble(object.toString());
                            d = d2 >= this.previousMastRepOffset ? d2 - this.previousMastRepOffset : d2;
                        } else if (n == 10) {
                            double d3 = Double.parseDouble(object.toString());
                            d = d3 >= this.previousSlavRepOffset ? d3 - this.previousSlavRepOffset : d3;
                        } else if (n == 12) {
                            double d4 = Double.parseDouble(object.toString());
                            d = d4 >= this.previousRepBacklogSize ? d4 - this.previousRepBacklogSize : d4;
                            this.previousRepBacklogSize = d4;
                        } else if (n == 13) {
                            double d5 = Double.parseDouble(object.toString());
                            d = d5 >= this.previousRepBacklogFirByteOff ? d5 - this.previousRepBacklogFirByteOff : d5;
                        } else if (n == 14) {
                            double d6 = Double.parseDouble(object.toString());
                            d = d6 >= this.previousRepBacklogHistLen ? d6 - this.previousRepBacklogHistLen : d6;
                            this.previousRepBacklogHistLen = d6;
                        }
                        logger.debug("{} [getRedisMeasureForReplication] index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, n, string, d});
                        arrayList.set(n, new Double(d));
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasureForReplication] Exception occured while parsing String to Double {}", (Object)this.logPrefix, (Object)exception);
                    }
                }
                string = this.redisInfo.getRedisRole();
                if (string != null && !string.equalsIgnoreCase("any") && string3 != null && !string3.equalsIgnoreCase("none")) {
                    this.roleChanged = string.equalsIgnoreCase(string3) ? 0.0 : 1.0;
                    if (!this.previousRole.equalsIgnoreCase("None") && !this.previousRole.equalsIgnoreCase(string3)) {
                        this.roleStatus = "Node Role changed from " + this.previousRole.toUpperCase() + " to " + string3.toUpperCase();
                    }
                }
                logger.info(" {} [role_changed***] Current Role :{} , Previous Role :{}, Role Status :{}, runtime :{} ", new Object[]{this.logPrefix, string3, this.previousRole, this.roleStatus, this.runtime});
                this.previousRole = string3;
                if (this.measureCount >= 16) {
                    arrayList.set(15, new Double(this.roleChanged));
                }
                logger.debug("{} [getRedisMeasureForReplication] Excepted Redis Role : {} , Current Role : {} , Role Changed : {} ", new Object[]{this.logPrefix, string, string3, this.roleChanged});
                logger.info("{} [getRedisMeasureForReplication] The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasureForReplication] ", (Object)this.logPrefix, (Object)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisReplicaTest redisReplicaTest = new RedisReplicaTest(stringArray);
        redisReplicaTest.computeMeasures(new Hashtable());
    }
}

