/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.json.simple.JSONObject;

public class RUMCollSiteTest
extends RUMCollectorBaseTest {
    private static final String myDatePattern = "E MMM dd hh:mm:ss Z yyyy";
    private static final SimpleDateFormat mySDF = new SimpleDateFormat("E MMM dd hh:mm:ss Z yyyy", Locale.US);
    private static final SimpleDateFormat finalformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    private ArrayList activeSiteIdsInfoAList = null;
    private ArrayList inactiveSiteIdsInfoAList = null;

    public RUMCollSiteTest(String[] arg0) {
        super(arg0);
    }

    private ArrayList defaultValues(ArrayList a_measures, int length) {
        int i = 0;
        while (i < length) {
            a_measures.add(new Double(0.0));
            ++i;
        }
        return a_measures;
    }

    public ArrayList getActiveSiteIdsInfo() {
        return this.activeSiteIdsInfoAList;
    }

    public ArrayList getInactiveSiteIdsInfo() {
        return this.inactiveSiteIdsInfoAList;
    }

    private void setInactiveSiteIdsInfo(ArrayList inactiveSiteIdDataAList) {
        this.inactiveSiteIdsInfoAList = new ArrayList();
        try {
            String finalBcnRcvedDate = null;
            String finalAgentReqDate = null;
            int i = 0;
            while (i < inactiveSiteIdDataAList.size()) {
                HashMap inactiveSiteIdsInfoHMap = (HashMap)inactiveSiteIdDataAList.get(i);
                String siteId = (String)inactiveSiteIdsInfoHMap.get("siteId");
                String componentName = (String)inactiveSiteIdsInfoHMap.get("componentName");
                String collectorName = (String)inactiveSiteIdsInfoHMap.get("collectorName");
                String agentIp = (String)inactiveSiteIdsInfoHMap.get("agentIP");
                String managerIpAndPort = (String)inactiveSiteIdsInfoHMap.get("managerIPAndPort");
                String lastBcnRcvedTime = (String)inactiveSiteIdsInfoHMap.get("lastBcnRcvedTime");
                String lastAgentReqTime = (String)inactiveSiteIdsInfoHMap.get("lastAgentReqTime");
                try {
                    if (lastBcnRcvedTime == null) {
                        Date tempAgentReqTime = mySDF.parse(lastAgentReqTime);
                        finalAgentReqDate = finalformat.format(tempAgentReqTime);
                    } else {
                        Date tempBcnRcvedDate = mySDF.parse(lastBcnRcvedTime);
                        Date tempAgentReqTime = mySDF.parse(lastAgentReqTime);
                        finalBcnRcvedDate = finalformat.format(tempBcnRcvedDate);
                        finalAgentReqDate = finalformat.format(tempAgentReqTime);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while changing DateTime format for DD");
                }
                ArrayList<String> inactvSiteData = new ArrayList<String>();
                inactvSiteData.add(siteId);
                inactvSiteData.add(componentName);
                inactvSiteData.add(collectorName);
                inactvSiteData.add(agentIp);
                inactvSiteData.add(managerIpAndPort);
                inactvSiteData.add(finalBcnRcvedDate);
                inactvSiteData.add(finalAgentReqDate);
                this.inactiveSiteIdsInfoAList.add(inactvSiteData);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollSiteTest][setInactiveSiteIdsInfo] exception occured while processing inactive siteId details: ", new Object[]{this.reportingName, this.entity, e});
        }
    }

    private void setActiveSiteIdsInfo(ArrayList activeSiteIdDataAList) {
        this.activeSiteIdsInfoAList = new ArrayList();
        try {
            String finalBcnRcvedDate = null;
            String finalAgentReqDate = null;
            int i = 0;
            while (i < activeSiteIdDataAList.size()) {
                HashMap activeSiteIdsInfoHMap = (HashMap)activeSiteIdDataAList.get(i);
                String siteId = (String)activeSiteIdsInfoHMap.get("siteId");
                String componentName = (String)activeSiteIdsInfoHMap.get("componentName");
                String collectorName = (String)activeSiteIdsInfoHMap.get("collectorName");
                String agentIp = (String)activeSiteIdsInfoHMap.get("agentIP");
                String managerIpAndPort = (String)activeSiteIdsInfoHMap.get("managerIPAndPort");
                String lastBcnRcvedTime = (String)activeSiteIdsInfoHMap.get("lastBcnRcvedTime");
                String lastAgentReqTime = (String)activeSiteIdsInfoHMap.get("lastAgentReqTime");
                try {
                    Date tempBcnRcvedDate = mySDF.parse(lastBcnRcvedTime);
                    Date tempAgentReqTime = mySDF.parse(lastAgentReqTime);
                    finalBcnRcvedDate = finalformat.format(tempBcnRcvedDate);
                    finalAgentReqDate = finalformat.format(tempAgentReqTime);
                }
                catch (Exception e) {
                    logger.error("Error while changing DateTime format for DD");
                }
                ArrayList<String> actvSiteIdData = new ArrayList<String>();
                actvSiteIdData.add(siteId);
                actvSiteIdData.add(componentName);
                actvSiteIdData.add(collectorName);
                actvSiteIdData.add(agentIp);
                actvSiteIdData.add(managerIpAndPort);
                actvSiteIdData.add(finalBcnRcvedDate);
                actvSiteIdData.add(finalAgentReqDate);
                this.activeSiteIdsInfoAList.add(actvSiteIdData);
                ++i;
            }
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollSiteTest][setActiveSiteIdsInfo] exception occured while processing active siteId details: ", new Object[]{this.reportingName, this.entity, e});
        }
    }

    public void computeMeasures(Hashtable params) {
        ArrayList a_measures = new ArrayList();
        try {
            String testName = this.getClass().getName();
            JSONObject rumCollSitesInfoJObj = this.httpCallToRUMMon(testName, null);
            logger.debug("[{}][{}][RUMCollSiteTest][computeMeasures] status and sites data/message: {}", new Object[]{this.reportingName, this.entity, rumCollSitesInfoJObj});
            if (rumCollSitesInfoJObj != null && rumCollSitesInfoJObj.containsKey((Object)"status")) {
                String status = (String)rumCollSitesInfoJObj.get((Object)"status");
                if (status.equals("success")) {
                    if (rumCollSitesInfoJObj.containsKey((Object)"data")) {
                        JSONObject sitesInfoJObj = (JSONObject)rumCollSitesInfoJObj.get((Object)"data");
                        Double configuredSiteIdsCount = (Double)sitesInfoJObj.get((Object)"configuredSiteIdsCount");
                        Double activeSiteIdsCount = (Double)sitesInfoJObj.get((Object)"activeSiteIdsCount");
                        Double inactiveSiteIdsCount = (Double)sitesInfoJObj.get((Object)"inactiveSiteIdsCount");
                        ArrayList activeSiteIdsDataAList = (ArrayList)sitesInfoJObj.get((Object)"activeSiteIdsDataAList");
                        ArrayList inactiveSiteIdsDataAList = (ArrayList)sitesInfoJObj.get((Object)"inactiveSiteIdsDataAList");
                        this.setActiveSiteIdsInfo(activeSiteIdsDataAList);
                        this.setInactiveSiteIdsInfo(inactiveSiteIdsDataAList);
                        a_measures.add(configuredSiteIdsCount);
                        a_measures.add(activeSiteIdsCount);
                        a_measures.add(inactiveSiteIdsCount);
                        this.addNewMeasure(a_measures);
                    }
                } else if (status.equals("fail")) {
                    logger.warn("[{}][{}][RUMCollSiteTest][computeMeasures] status: fail, message: {} ", new Object[]{this.reportingName, this.entity, rumCollSitesInfoJObj.get((Object)"message")});
                    a_measures = this.defaultValues(a_measures, 3);
                    this.addNewMeasure(a_measures);
                } else if (status.equals("error")) {
                    logger.warn("[{}][{}][RUMCollSiteTest][computeMeasures] status: error, message: {} ", new Object[]{this.reportingName, this.entity, rumCollSitesInfoJObj.get((Object)"message")});
                }
            }
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollConfigrdCompntTest][computeMeasures] Exception occured in computeMeasures: ", new Object[]{this.reportingName, this.entity, e});
        }
    }
}

