/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.JCO;
import java.util.ArrayList;

public class R3ConnectionJco2Test
extends AsAbapJco2Base {
    double defValue = -1.0;

    public R3ConnectionJco2Test(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        if (this.isPassive) {
            this.defValue = -5.0;
        }
    }

    protected boolean executeCmd(JCO.Client client) {
        try {
            JCO.ParameterList parameterList = JCO.createParameterList();
            JCO.ParameterList parameterList2 = JCO.createParameterList();
            parameterList2.addInfo("ECHOTEXT", 0, 255);
            parameterList2.addInfo("RESPTEXT", 0, 255);
            client.execute("STFC_CONNECTION", parameterList, parameterList2);
            this.printOut("Executed command");
            return true;
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", this.entity, "Exception in executeCommand method : " + exception.toString());
            return false;
        }
    }

    public ArrayList getMeasList() {
        JCO.Client client = null;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        long l = System.currentTimeMillis();
        client = this.getConnection();
        if (client != null) {
            this.printOut("Got connection");
            d3 = 100.0;
            long l2 = System.currentTimeMillis();
            boolean bl = this.executeCmd(client);
            this.printOut("executeCommand returned " + bl);
            if (!bl) {
                this.printOut("Could not process executeCommand  method ");
                this.logToErrorFile("ERROR :", this.reportingName + " " + this.entity, "Could not process executeCommand  method");
                this.releaseClient(client);
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                arrayList.add(new Double(0.0));
                this.printOut("Got measure " + arrayList.toString());
                return arrayList;
            }
            d2 = (double)(System.currentTimeMillis() - l2) / 1000.0;
            d = (double)(l2 - l) / 1000.0;
            this.releaseClient(client);
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            this.printOut("Got measure " + arrayList.toString());
            return arrayList;
        }
        this.printOut("Didn't get connection");
        if (this.isPassive) {
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            arrayList.add(new Double(this.defValue));
            this.printOut("Got measure " + arrayList.toString());
            return arrayList;
        }
        arrayList.add(new Double(0.0));
        arrayList.add(new Double(0.0));
        arrayList.add(new Double(0.0));
        this.printOut("Got measure " + arrayList.toString());
        return arrayList;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        R3ConnectionJco2Test r3ConnectionJco2Test = new R3ConnectionJco2Test(stringArray);
        r3ConnectionJco2Test.decryptPassword();
        System.out.println("Measures List : " + r3ConnectionJco2Test.getMeasList());
    }
}

