/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgSorter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class PgWorkLoadTest
extends GenericTest {
    private String pgsqlURL;
    private String pgSQLUser;
    private String pgSQLPwd;
    private String pgSQLDbName;
    private String ssl;
    private String pgsqlDriver;
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private Properties props;
    public Hashtable physicalReadHash;
    public Hashtable physicalWriteHash;
    public Hashtable elapsedTimeHash;
    public Hashtable memoryUsageHash;
    public Hashtable latencyHash;
    public Hashtable readLatencyHash;
    public Hashtable writeLatencyHash;
    private Hashtable measureHash;
    private ArrayList measureList;
    private boolean isPostgreSQLAbove12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PgWorkLoadTest(String[] stringArray) {
        block10: {
            super(stringArray);
            this.pgsqlURL = "";
            this.pgSQLUser = "";
            this.pgSQLPwd = "";
            this.pgSQLDbName = "";
            this.ssl = "false";
            this.pgsqlDriver = "org.postgresql.Driver";
            this.props = null;
            this.physicalReadHash = new Hashtable();
            this.physicalWriteHash = new Hashtable();
            this.elapsedTimeHash = new Hashtable();
            this.memoryUsageHash = new Hashtable();
            this.latencyHash = new Hashtable();
            this.readLatencyHash = new Hashtable();
            this.writeLatencyHash = new Hashtable();
            this.measureHash = new Hashtable();
            this.measureList = new ArrayList();
            this.isPostgreSQLAbove12 = true;
            this.setMeasureCount(this.measureCount);
            try {
                this.pgSQLUser = this.getValueForParam("username");
                this.pgSQLPwd = this.getValueForParam("password");
                this.pgSQLDbName = this.getValueForParam("dbName");
                this.ssl = this.getValueForParam("ssl");
                if (this.pgSQLUser == null || this.pgSQLUser.equalsIgnoreCase("NULL") || this.pgSQLUser.equalsIgnoreCase("none")) {
                    this.pgSQLUser = "";
                }
                if (this.pgSQLDbName == null || this.pgSQLDbName.equalsIgnoreCase("NULL") || this.pgSQLDbName.equalsIgnoreCase("none")) {
                    this.pgSQLDbName = "";
                }
                if (this.pgSQLPwd == null || this.pgSQLPwd.equalsIgnoreCase("NULL") || this.pgSQLPwd.equalsIgnoreCase("none")) {
                    this.pgSQLPwd = "";
                }
                this.pgsqlURL = "jdbc:postgresql://" + this.targetHost + ":" + this.portNo + "/" + this.pgSQLDbName;
                this.props = new Properties();
                this.props.setProperty("user", this.pgSQLUser);
                this.props.setProperty("password", this.pgSQLPwd);
                if (this.ssl != null && this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes") || this.ssl.equalsIgnoreCase("y")) {
                    this.ssl = "true";
                    this.props.setProperty("ssl", this.ssl);
                    this.props.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
                }
                this.isNewDynamicInfoTest = true;
                this.needAgentlessDD = true;
                if (fieldSep.length() != 0) break block10;
                String string = sync0;
                synchronized (string) {
                    if (fieldSep.length() == 0) {
                        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                        fieldSep = egTesterInfo.getDDSeparator1();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error :", this.entity + " Exception in Constructor targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(this.pgsqlURL, this.props);
            if (connection == null) {
                this.logToErrorFile("Error", this.entity, " Connection is null for for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DbName :" + this.pgSQLDbName);
                return;
            }
            System.out.println(this.entity + " Connection established Successfully.." + " for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DbName :" + this.pgSQLDbName);
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.closeST(statement);
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
                return;
            }
            this.measureList = new ArrayList();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductVersion();
            System.out.println(this.entity + " product_version :" + string + " for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DbName :" + this.pgSQLDbName);
            if (string != null && string.indexOf(".") > -1) {
                double d = Double.parseDouble(string.substring(0, string.indexOf(".")));
                this.isPostgreSQLAbove12 = d > 12.0;
            }
            this.executePhysicalReads(connection, statement);
            this.executePhysicalWrites(connection, statement);
            this.executeElapsedTime(connection, statement);
            this.executeMemoryUsage(connection, statement);
            this.executeLatency(connection, statement);
            System.out.println(this.entity + " measureHash :" + this.measureHash + " for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DbName :" + this.pgSQLDbName);
            if (this.measureHash != null && this.measureHash.size() > 0) {
                Enumeration enumeration = this.measureHash.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ArrayList arrayList = (ArrayList)this.measureHash.get(string2);
                    System.out.println(this.entity + " databaseName :" + string2 + " measureList :" + arrayList + " for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DbName :" + this.pgSQLDbName);
                    this.addNewMeasure(string2, arrayList);
                }
            }
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error", this.entity + " Exception while executing computeMeasure() for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
        }
        finally {
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
        }
    }

    private void executePhysicalReads(Connection connection, Statement statement) {
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        try {
            String string = "";
            string = this.isPostgreSQLAbove12 ? "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_exec_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Physical_Reads_per_execution DESC LIMIT 5;" : "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Physical_Reads_per_execution DESC LIMIT 5;";
            System.out.println(this.entity + " physicalReadsQuery :" + string + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                return;
            }
            if (resultSet != null) {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                String string5 = "";
                boolean bl = true;
                while (resultSet.next()) {
                    ArrayList arrayList;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    d = resultSet.getDouble(4);
                    d2 = resultSet.getDouble(5);
                    d4 = resultSet.getDouble(6);
                    d3 = resultSet.getDouble(7);
                    string5 = resultSet.getString(8);
                    if (string4 == null || string4.trim().length() == 0) continue;
                    if (!this.measureHash.containsKey(string4)) {
                        this.measureList = new ArrayList();
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        double d5 = this.getDoubleValue((Double)this.measureList.get(0));
                        if (d > d5) {
                            this.measureList.set(0, new Double(d));
                            this.measureHash.put(string4, this.measureList);
                        }
                    }
                    string2 = this.getDDValue(string2);
                    string3 = this.getDDValue(string3);
                    string5 = this.getDDValue(string5);
                    string5 = string5.replaceAll("\n", "");
                    String string6 = string2 + fieldSep + string3 + fieldSep + d + fieldSep + d2 + fieldSep + d4 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d3 + fieldSep + string5;
                    if (this.physicalReadHash != null && this.physicalReadHash.containsKey(string4)) {
                        arrayList = (ArrayList)this.physicalReadHash.get(string4);
                        arrayList.add(string6);
                        this.physicalReadHash.put(string4, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(string6);
                    this.physicalReadHash.put(string4, arrayList);
                }
                this.closeRS(resultSet);
            }
            hashtable = this.measureHash;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void executePhysicalWrites(Connection connection, Statement statement) {
        ResultSet resultSet = null;
        try {
            String string = "";
            string = this.isPostgreSQLAbove12 ? "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_exec_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Physical_Writes_per_execution DESC LIMIT 5" : "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Physical_Writes_per_execution DESC LIMIT 5";
            System.out.println(this.entity + " physicalWritesQuery :" + string + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                return;
            }
            if (resultSet != null) {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                String string5 = "";
                boolean bl = true;
                while (resultSet.next()) {
                    ArrayList arrayList;
                    Object object;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    d = resultSet.getDouble(4);
                    d2 = resultSet.getDouble(5);
                    d4 = resultSet.getDouble(6);
                    d3 = resultSet.getDouble(7);
                    string5 = resultSet.getString(8);
                    if (!this.measureHash.containsKey(string4)) {
                        this.measureList = new ArrayList();
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.set(1, new Double(d2));
                        this.measureHash.put(string4, this.measureList);
                    } else {
                        object = (ArrayList)this.measureHash.get(string4);
                        double d5 = this.getDoubleValue((Double)((ArrayList)object).get(1));
                        if (d2 > d5) {
                            ((ArrayList)object).set(1, new Double(d2));
                            this.measureHash.put(string4, object);
                        }
                    }
                    if (string4 == null || string4.trim().length() == 0) continue;
                    string2 = this.getDDValue(string2);
                    string3 = this.getDDValue(string3);
                    string5 = this.getDDValue(string5);
                    string5 = string5.replaceAll("\n", "");
                    object = string2 + fieldSep + string3 + fieldSep + d + fieldSep + d2 + fieldSep + d4 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d3 + fieldSep + string5;
                    if (this.physicalWriteHash != null && this.physicalWriteHash.containsKey(string4)) {
                        arrayList = (ArrayList)this.physicalWriteHash.get(string4);
                        arrayList.add(object);
                        this.physicalWriteHash.put(string4, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(object);
                    this.physicalWriteHash.put(string4, arrayList);
                }
                this.closeRS(resultSet);
            }
            System.out.println(this.entity + " physicalWriteHash :" + this.physicalWriteHash);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void executeElapsedTime(Connection connection, Statement statement) {
        ResultSet resultSet = null;
        try {
            String string = "";
            string = this.isPostgreSQLAbove12 ? "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_exec_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Elpased_time_per_execution DESC LIMIT 5" : "SELECT userid::regrole, queryid, datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,calls,total_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid ORDER BY Elpased_time_per_execution DESC LIMIT 5";
            System.out.println(this.entity + " elapsedTimeQuery :" + string + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                return;
            }
            if (resultSet != null) {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                String string5 = "";
                boolean bl = true;
                while (resultSet.next()) {
                    ArrayList arrayList;
                    Object object;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    d = resultSet.getDouble(4);
                    d2 = resultSet.getDouble(5);
                    d4 = resultSet.getDouble(6);
                    d3 = resultSet.getDouble(7);
                    string5 = resultSet.getString(8);
                    d3 /= 1000.0;
                    if (!this.measureHash.containsKey(string4)) {
                        this.measureList = new ArrayList();
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.set(2, new Double(d3));
                        this.measureHash.put(string4, this.measureList);
                    } else {
                        object = (ArrayList)this.measureHash.get(string4);
                        double d5 = this.getDoubleValue((Double)((ArrayList)object).get(2));
                        if (d3 > d5) {
                            ((ArrayList)object).set(2, new Double(d3));
                            this.measureHash.put(string4, object);
                        }
                    }
                    if (string4 == null || string4.trim().length() == 0) continue;
                    string2 = this.getDDValue(string2);
                    string3 = this.getDDValue(string3);
                    string5 = this.getDDValue(string5);
                    string5 = string5.replaceAll("\n", "");
                    object = string2 + fieldSep + string3 + fieldSep + d + fieldSep + d2 + fieldSep + d4 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d3 + fieldSep + string5;
                    if (this.elapsedTimeHash != null && this.elapsedTimeHash.containsKey(string4)) {
                        arrayList = (ArrayList)this.elapsedTimeHash.get(string4);
                        arrayList.add(object);
                        this.elapsedTimeHash.put(string4, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(object);
                    this.elapsedTimeHash.put(string4, arrayList);
                }
                this.closeRS(resultSet);
            }
            System.out.println(this.entity + " elapsedTimeHash :" + this.elapsedTimeHash + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void executeMemoryUsage(Connection connection, Statement statement) {
        ResultSet resultSet = null;
        try {
            String string = "";
            string = this.isPostgreSQLAbove12 ? "SELECT userid::regrole,queryid,datname as DbName,calls,shared_blks_hit,shared_blks_dirtied,current_setting('block_size')::int *(shared_blks_hit+shared_blks_dirtied)/(1024*1024)as Memory_Usage_MB,current_setting('block_size')::int *(shared_blks_hit+shared_blks_dirtied)/(1024*1024)/calls as Memory_Used_per_Execution_MB,total_exec_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid  ORDER BY Memory_Usage_MB DESC LIMIT 5" : "SELECT userid::regrole,queryid,datname as DbName,calls,shared_blks_hit,shared_blks_dirtied,current_setting('block_size')::int *(shared_blks_hit+shared_blks_dirtied)/(1024*1024)as Memory_Usage_MB,current_setting('block_size')::int *(shared_blks_hit+shared_blks_dirtied)/(1024*1024)/calls as Memory_Used_per_Execution_MB,total_time/calls as Elpased_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid  ORDER BY Memory_Usage_MB DESC LIMIT 5";
            System.out.println(this.entity + " memoryUsageQuery :" + string + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                return;
            }
            if (resultSet != null) {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                String string5 = "";
                boolean bl = true;
                while (resultSet.next()) {
                    ArrayList arrayList;
                    Object object;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    d = resultSet.getDouble(5);
                    d2 = resultSet.getDouble(6);
                    d4 = resultSet.getDouble(7);
                    d3 = resultSet.getDouble(8);
                    d5 = resultSet.getDouble(9);
                    string5 = resultSet.getString(10);
                    if (!this.measureHash.containsKey(string4)) {
                        this.measureList = new ArrayList();
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.set(3, new Double(d4));
                        this.measureHash.put(string4, this.measureList);
                    } else {
                        object = (ArrayList)this.measureHash.get(string4);
                        double d6 = this.getDoubleValue((Double)((ArrayList)object).get(3));
                        if (d4 > d6) {
                            ((ArrayList)object).set(3, new Double(d4));
                            this.measureHash.put(string4, object);
                        }
                    }
                    if (string4 == null || string4.trim().length() == 0) continue;
                    string2 = this.getDDValue(string2);
                    string3 = this.getDDValue(string3);
                    string5 = this.getDDValue(string5);
                    string5 = string5.replaceAll("\n", "");
                    object = string2 + fieldSep + string3 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d + fieldSep + d2 + fieldSep + d4 + fieldSep + d3 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d5 + fieldSep + string5;
                    if (this.memoryUsageHash != null && this.memoryUsageHash.containsKey(string4)) {
                        arrayList = (ArrayList)this.memoryUsageHash.get(string4);
                        arrayList.add(object);
                        this.memoryUsageHash.put(string4, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(object);
                    this.memoryUsageHash.put(string4, arrayList);
                }
                this.closeRS(resultSet);
            }
            System.out.println(this.entity + " memoryUsageHash :" + this.memoryUsageHash + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void executeLatency(Connection connection, Statement statement) {
        ResultSet resultSet = null;
        try {
            String string = "";
            string = this.isPostgreSQLAbove12 ? "SELECT userid::regrole,queryid,datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read) as Physical_Reads,(shared_blks_written+local_blks_written+temp_blks_written) as Physical_Writes,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,blk_read_time, blk_write_time, calls,total_exec_time/calls as Elapsed_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid" : "SELECT userid::regrole,queryid,datname as DbName,(shared_blks_read+local_blks_read+temp_blks_read) as Physical_Reads,(shared_blks_written+local_blks_written+temp_blks_written) as Physical_Writes,(shared_blks_read+local_blks_read+temp_blks_read)/calls as Physical_Reads_per_execution,(shared_blks_written+local_blks_written+temp_blks_written)/calls as Physical_Writes_per_execution,blk_read_time, blk_write_time, calls,total_time/calls as Elapsed_time_per_execution,query FROM pg_stat_statements a,pg_database b WHERE a.dbid=b.oid";
            System.out.println(this.entity + " latencyQuery :" + string + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            try {
                resultSet = statement.executeQuery(string);
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                exception.printStackTrace();
                return;
            }
            if (resultSet != null) {
                String string2 = "";
                String string3 = "";
                String string4 = "";
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                String string5 = "";
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
                while (resultSet.next()) {
                    ArrayList<Double> arrayList2;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    d = resultSet.getDouble(4);
                    d2 = resultSet.getDouble(5);
                    d3 = resultSet.getDouble(6);
                    d4 = resultSet.getDouble(7);
                    d6 = resultSet.getDouble(8);
                    d7 = resultSet.getDouble(9);
                    d8 = resultSet.getDouble(10);
                    d5 = resultSet.getDouble(11);
                    string5 = resultSet.getString(12);
                    if (string4 == null || string4.trim().length() == 0) continue;
                    if (d > 0.0) {
                        d9 = d6 / d;
                    }
                    if (d2 > 0.0) {
                        d10 = d7 / d2;
                    }
                    if (d9 > 0.0 && d9 > d11) {
                        d11 = d9;
                    }
                    if (d10 > 0.0 && d10 > d12) {
                        d12 = d10;
                    }
                    if (!this.measureHash.containsKey(string4)) {
                        this.measureList = new ArrayList();
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.add(new Double(0.0));
                        this.measureList.set(4, new Double(d11));
                        this.measureList.set(5, new Double(d12));
                        this.measureHash.put(string4, this.measureList);
                    } else {
                        arrayList2 = (ArrayList<Double>)this.measureHash.get(string4);
                        double d13 = this.getDoubleValue((Double)arrayList2.get(4));
                        double d14 = this.getDoubleValue((Double)arrayList2.get(5));
                        if (d11 > d13) {
                            arrayList2.set(4, new Double(d11));
                            this.measureHash.put(string4, arrayList2);
                        }
                        if (d12 > d14) {
                            arrayList2.set(5, new Double(d12));
                            this.measureHash.put(string4, arrayList2);
                        }
                    }
                    string2 = this.getDDValue(string2);
                    string3 = this.getDDValue(string3);
                    string5 = this.getDDValue(string5);
                    string5 = string5.replaceAll("\n", "");
                    if (!(d9 > 0.0) && !(d10 > 0.0)) continue;
                    arrayList2 = new ArrayList<Double>();
                    arrayList2.add((Double)((Object)string2));
                    arrayList2.add((Double)((Object)string3));
                    arrayList2.add(new Double(d9));
                    arrayList2.add(new Double(d10));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d8));
                    arrayList2.add(new Double(d5));
                    arrayList2.add((Double)((Object)string5));
                    if (this.readLatencyHash != null && this.readLatencyHash.containsKey(string4)) {
                        ArrayList arrayList3 = (ArrayList)this.readLatencyHash.get(string4);
                        arrayList3.add(arrayList2);
                        this.readLatencyHash.put(string4, arrayList3);
                    } else {
                        arrayList.add(arrayList2);
                        this.readLatencyHash.put(string4, arrayList);
                    }
                    if (this.writeLatencyHash != null && this.writeLatencyHash.containsKey(string4)) {
                        ArrayList arrayList4 = (ArrayList)this.writeLatencyHash.get(string4);
                        arrayList4.add(arrayList2);
                        this.writeLatencyHash.put(string4, arrayList4);
                        continue;
                    }
                    arrayList.add(arrayList2);
                    this.writeLatencyHash.put(string4, arrayList);
                }
                this.closeRS(resultSet);
            }
            this.readLatencyHash = this.getSortedHash(this.readLatencyHash, 3);
            this.writeLatencyHash = this.getSortedHash(this.writeLatencyHash, 4);
            System.out.println(this.entity + " readLatencyHash :" + this.readLatencyHash + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
            System.out.println(this.entity + " writeLatencyHash :" + this.writeLatencyHash + " for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " DatabaseName :" + this.pgSQLDbName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getSortedHash(Hashtable hashtable, int n) {
        Hashtable hashtable2 = new Hashtable();
        try {
            ArrayList arrayList;
            ArrayList arrayList2;
            String string;
            Enumeration enumeration;
            if (hashtable != null && hashtable.size() > 0) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    arrayList2 = (ArrayList)hashtable.get(string);
                    if (arrayList2 == null || arrayList2.size() <= 0) continue;
                    EgSorter egSorter = new EgSorter((List)arrayList2, n);
                    arrayList = (ArrayList)egSorter.sort(n, "Double", "desc");
                    hashtable2.put(string, arrayList);
                }
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    arrayList2 = (ArrayList)hashtable.get(string);
                    if (arrayList2 == null || arrayList2.size() <= 0) continue;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        arrayList = (ArrayList)arrayList2.get(i);
                        if (arrayList == null || arrayList.size() <= 0) continue;
                        String string2 = (String)arrayList.get(0);
                        String string3 = (String)arrayList.get(1);
                        double d = this.getDoubleValue((Double)arrayList.get(2));
                        double d2 = this.getDoubleValue((Double)arrayList.get(3));
                        double d3 = this.getDoubleValue((Double)arrayList.get(4));
                        double d4 = this.getDoubleValue((Double)arrayList.get(5));
                        double d5 = this.getDoubleValue((Double)arrayList.get(6));
                        double d6 = this.getDoubleValue((Double)arrayList.get(7));
                        double d7 = this.getDoubleValue((Double)arrayList.get(8));
                        double d8 = this.getDoubleValue((Double)arrayList.get(9));
                        String string4 = (String)arrayList.get(10);
                        String string5 = string2 + fieldSep + string3 + fieldSep + d3 + fieldSep + d4 + fieldSep + d7 + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + "-" + fieldSep + d + fieldSep + d2 + fieldSep + d5 + fieldSep + d6 + fieldSep + d8 + fieldSep + string4;
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        arrayList3.add(string5);
                        hashtable2.put(string, arrayList3);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " getSortedHash()  reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
        }
        return hashtable2;
    }

    private Connection getConnection(String string, Properties properties) {
        Connection connection = null;
        try {
            Class.forName(this.pgsqlDriver);
            connection = DriverManager.getConnection(string, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connection;
    }

    public String getDDValue(String string) {
        string = string == null || string.trim().length() == 0 ? "-" : string.trim();
        return string;
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeST(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    private double getDoubleValue(Double d) {
        double d2 = 0.0;
        if (d != null) {
            d2 = d;
        }
        return d2;
    }

    public void freeTest() {
        this.physicalReadHash = new Hashtable();
        this.physicalWriteHash = new Hashtable();
        this.elapsedTimeHash = new Hashtable();
        this.memoryUsageHash = new Hashtable();
        this.readLatencyHash = new Hashtable();
        this.writeLatencyHash = new Hashtable();
    }

    public static void main(String[] stringArray) {
        PgWorkLoadTest pgWorkLoadTest = new PgWorkLoadTest(stringArray);
        pgWorkLoadTest.computeMeasures(new Hashtable());
    }
}

