/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PgTbspcGroupTest
extends GenericTest {
    private String pgsqlURL = "";
    private String pgsqlUser = "";
    private String pgsqlPW = "";
    private String pgsqlDbName = "";
    private String ssl = "false";
    private String debugFlag = "";
    private String query = "";
    private String pgsqlDriver = "";
    private Properties props = null;
    private ArrayList curList = null;
    private ArrayList preList = null;
    private boolean debug = false;
    private String excludeTblSpce = "";
    private boolean isMultipleTblSpce = false;

    public PgTbspcGroupTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isDynamicInfoTest = true;
        this.props = new Properties();
        this.curList = new ArrayList();
        this.preList = new ArrayList();
        this.pgsqlDriver = "org.postgresql.Driver";
        this.pgsqlUser = this.getValueForParam("username");
        this.pgsqlPW = this.getValueForParam("password");
        this.pgsqlDbName = this.getValueForParam("dbName");
        this.debugFlag = this.getValueForParam("debug");
        this.ssl = this.getValueForParam("ssl");
        this.excludeTblSpce = this.getValueForParam("exclude_tablespace");
        if (this.pgsqlUser == null || this.pgsqlUser.equalsIgnoreCase("NULL") || this.pgsqlUser.equalsIgnoreCase("none")) {
            this.pgsqlUser = "";
        }
        if (this.pgsqlDbName == null || this.pgsqlDbName.equalsIgnoreCase("NULL") || this.pgsqlDbName.equalsIgnoreCase("none")) {
            this.pgsqlDbName = "";
        }
        if (this.pgsqlPW == null || this.pgsqlPW.equalsIgnoreCase("NULL") || this.pgsqlPW.equalsIgnoreCase("none")) {
            this.pgsqlPW = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        if (this.excludeTblSpce == null || this.excludeTblSpce.equalsIgnoreCase("NULL") || this.excludeTblSpce.equalsIgnoreCase("none")) {
            this.excludeTblSpce = "none";
        }
        this.pgsqlURL = "jdbc:postgresql://" + this.targetHost + ":" + this.portNo + "/" + this.pgsqlDbName;
        this.props.setProperty("user", this.pgsqlUser);
        this.props.setProperty("password", this.pgsqlPW);
        if (this.ssl != null && this.ssl.equalsIgnoreCase("true")) {
            this.props.setProperty("ssl", this.ssl);
            this.props.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
        }
        if (this.excludeTblSpce.equalsIgnoreCase("none")) {
            this.query = "SELECT spcname,pg_tablespace_size(spcname) AS size_bytes FROM  pg_tablespace";
        } else {
            this.handleMultipleTableSpaces();
            String string = "";
            string = this.isMultipleTblSpce ? "where spcname not in (" + this.excludeTblSpce + ")" : "where spcname !=" + this.excludeTblSpce;
            this.query = "SELECT spcname,pg_tablespace_size(spcname) AS size_bytes FROM  pg_tablespace " + string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block23: {
            ArrayList<Double> arrayList;
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block22: {
                connection = null;
                statement = null;
                resultSet = null;
                System.out.println(this.entity + " query::" + this.query);
                Class.forName(this.pgsqlDriver);
                try {
                    connection = DriverManager.getConnection(this.pgsqlURL, this.props);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (connection != null) break block22;
                this.logToErrorFile("ERROR", this.entity, " Connection is null for for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                try {
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.closeST(statement);
                this.closeConn(connection);
                exception.printStackTrace();
                try {
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                return;
            }
            double d = 0.0;
            resultSet = statement.executeQuery(this.query);
            while (resultSet.next()) {
                arrayList = new ArrayList<Double>();
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                string2 = string2 == null || string2.equalsIgnoreCase("null") || string2.equalsIgnoreCase("") || string2.equalsIgnoreCase("NaN") || string2.length() == 0 ? "0" : string2;
                double d2 = Double.parseDouble(string2.trim());
                arrayList.add(new Double(d2 /= 1048576.0));
                d += d2;
                if (this.debug) {
                    System.out.println("[PgTbspcGroupTest]====> info====>" + string + "=====>measureList====>" + arrayList);
                }
                this.addNewMeasure(string, arrayList);
            }
            arrayList = new ArrayList();
            arrayList.add(new Double(d));
            this.addNewMeasure("Summary", arrayList);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            try {
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block23;
            catch (Exception exception) {
                try {
                    this.logToErrorFile("[PgTbspcGroupTest] compute Measure()", "Exception while uploading ", exception.toString());
                }
                catch (Throwable throwable) {
                    try {
                        this.closeRS(resultSet);
                        this.closeST(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeST(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    private void handleMultipleTableSpaces() {
        try {
            if (this.excludeTblSpce == null) {
                return;
            }
            if (this.excludeTblSpce.indexOf(",") != -1) {
                this.isMultipleTblSpce = true;
                StringTokenizer stringTokenizer = new StringTokenizer(this.excludeTblSpce, ",");
                this.excludeTblSpce = "";
                String string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    if (string == null || string.trim().length() == 0) continue;
                    string = string.trim();
                    this.excludeTblSpce = this.excludeTblSpce + "'" + string + "',";
                    this.excludeTblSpce = this.excludeTblSpce.trim();
                }
                if (this.excludeTblSpce != null && this.excludeTblSpce.indexOf(",") > 0) {
                    this.excludeTblSpce = this.excludeTblSpce.substring(0, this.excludeTblSpce.lastIndexOf(","));
                }
                if (this.debug) {
                    System.out.println("[" + this.getClass().getName() + "]-handleMultipleTableSpaces()-excludeTblSpce ==>" + this.excludeTblSpce);
                }
            } else {
                String string = this.excludeTblSpce = this.excludeTblSpce.trim();
                this.excludeTblSpce = "'" + this.excludeTblSpce + "'";
                System.out.println("[" + this.getClass().getName() + "]-handleMultipleTableSpaces() else-excludeTblSpce ==>" + this.excludeTblSpce);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error : ", this.entity + "handleMultipleTableSpaces() Incorrect tablespace string targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
            return;
        }
    }

    public static void main(String[] stringArray) {
        PgTbspcGroupTest pgTbspcGroupTest = new PgTbspcGroupTest(stringArray);
        pgTbspcGroupTest.computeMeasures(new Hashtable());
    }
}

