/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class PgNetTest
extends GenericTest {
    private String pgsqlURL = "";
    private String pgsqlUser = "";
    private String pgsqlPW = "";
    private String pgsqlDbName = "";
    private String query = "";
    private String ssl = "false";
    private String debugFlag = "";
    private String pgsqlDriver = "";
    private Properties props = null;
    private boolean debug = false;
    public ArrayList pgNetAvaDDList = new ArrayList();

    public PgNetTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.props = new Properties();
        this.pgsqlUser = this.getValueForParam("username");
        this.pgsqlPW = this.getValueForParam("password");
        this.pgsqlDbName = this.getValueForParam("dbName");
        this.debugFlag = this.getValueForParam("debug");
        this.query = this.getValueForParam("query");
        this.ssl = this.getValueForParam("ssl");
        this.pgsqlDriver = "org.postgresql.Driver";
        if (this.pgsqlUser == null || this.pgsqlUser.equalsIgnoreCase("NULL") || this.pgsqlUser.equalsIgnoreCase("none")) {
            this.pgsqlUser = "";
        }
        if (this.pgsqlDbName == null || this.pgsqlDbName.equalsIgnoreCase("NULL") || this.pgsqlDbName.equalsIgnoreCase("none")) {
            this.pgsqlDbName = "";
        }
        if (this.pgsqlPW == null || this.pgsqlPW.equalsIgnoreCase("NULL") || this.pgsqlPW.equalsIgnoreCase("none")) {
            this.pgsqlPW = "";
        }
        if (this.query == null || this.query.trim().length() == 0 || this.query.equalsIgnoreCase("none")) {
            this.query = "select * from pg_tables";
        }
        this.pgsqlURL = "jdbc:postgresql://" + this.targetHost + ":" + this.portNo + "/" + this.pgsqlDbName;
        this.props.setProperty("user", this.pgsqlUser);
        this.props.setProperty("password", this.pgsqlPW);
        if (this.ssl != null && this.ssl.equalsIgnoreCase("true")) {
            this.props.setProperty("ssl", this.ssl);
            this.props.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
        }
        System.out.println("entity :==> measureCount :" + this.measureCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block23: {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            double d = 0.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            double d5 = -5.0;
            double d6 = -5.0;
            int n = -5;
            Class.forName(this.pgsqlDriver);
            System.out.println(this.entity + " Query : " + this.query);
            long l = System.currentTimeMillis();
            try {
                connection = DriverManager.getConnection(this.pgsqlURL, this.props);
            }
            catch (Exception exception) {
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.pgNetAvaDDList.add(string);
                System.out.println("pgNetDDList : " + this.pgNetAvaDDList);
            }
            if (connection != null) {
                long l2 = System.currentTimeMillis();
                d4 = (double)(l2 - l) / 1000.0;
                d = 100.0;
                d3 = 100.0;
                d5 = 0.0;
                long l3 = System.currentTimeMillis();
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("startQryProTime::" + l3);
                if (statement != null) {
                    resultSet = statement.executeQuery(this.query);
                }
                if (resultSet != null) {
                    long l4 = System.currentTimeMillis();
                    d6 = (double)(l4 - l3) / 1000.0;
                    n = 0;
                    d5 = 100.0;
                    try {
                        while (resultSet.next()) {
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        n = 0;
                    }
                } else {
                    d5 = 0.0;
                    d6 = -5.0;
                }
            } else {
                d3 = 0.0;
            }
            long l5 = System.currentTimeMillis();
            d2 = d == 100.0 ? (double)(l5 - l) / 1000.0 : -5.0;
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            if (this.measureCount > 2) {
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(n));
            }
            System.out.println("[PgNetTest]====> measureList====>" + arrayList);
            this.addNewMeasure(arrayList);
            this.closeRS(resultSet);
            this.closeST(statement);
            this.closeConn(connection);
            try {
                this.closeRS(resultSet);
                this.closeST(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block23;
            catch (Exception exception) {
                try {
                    this.logToErrorFile("ERROR", this.entity + " compute Measure() targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        this.closeRS(resultSet);
                        this.closeST(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    this.closeRS(resultSet);
                    this.closeST(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception3) {
                    exception3.printStackTrace();
                }
            }
        }
    }

    void closeRS(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            resultSet = null;
        }
    }

    void closeST(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            statement = null;
        }
    }

    void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            connection = null;
        }
    }

    public void freeTest() {
        this.pgNetAvaDDList = new ArrayList();
    }

    public static void main(String[] stringArray) {
        PgNetTest pgNetTest = new PgNetTest(stringArray);
        pgNetTest.computeMeasures(new Hashtable());
    }
}

